/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.pointer.JSONPointerException;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PropertySchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u0001:\u0001@B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0004H\u0002JT\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152&\u0010\u001a\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001c\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010 \u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000fJ\"\u0010&\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J,\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020,2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J$\u0010-\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J,\u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J,\u00101\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J$\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J \u00105\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0004J,\u00106\u001a\u0002072\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u0002082\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J$\u00109\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000fJ\u000e\u0010=\u001a\u00020>2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010=\u001a\u00020>2\u0006\u0010%\u001a\u00020\u000fJ\f\u0010?\u001a\u00020\u000f*\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "str", "", "parse", "file", "Ljava/io/File;", "uri", "json", "Lnet/pwall/json/JSONValue;", "parseCombinationSchema", "pointer", "Lnet/pwall/json/pointer/JSONPointer;", "array", "creator", "Lkotlin/Function3;", "", "parseConst", "Lnet/pwall/json/schema/validation/ConstValidator;", "value", "parseDraft07", "parentUri", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseFile", "filename", "parseIf", "parseItems", "Lnet/pwall/json/schema/subschema/ItemSchema;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "condition", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertySchema;", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseSchema", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "parseURI", "uriString", "preLoad", "", "pointerOrRoot", "Companion", "json-kotlin-schema"})
public final class Parser {
    private final JSONReader jsonReader;
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;
    @NotNull
    private static final Function1<URI, InputStream> defaultURIResolver;
    public static final Companion Companion;

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.isFile()) {
            throw (Throwable)((Object)new JSONSchemaException("Invalid file - " + file));
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        URI uRI = uri;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
        return this.parse(json, uRI);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONValue jSONValue = json;
        if (!(jSONValue instanceof JSONObject)) {
            jSONValue = null;
        }
        JSONObject jSONObject = (JSONObject)jSONValue;
        String schemaVersion = jSONObject != null ? Companion.getStringOrNull(jSONObject, JSONPointer.Companion.getRoot().child("$schema")) : null;
        JSONPointer pointer = JSONPointer.Companion.getRoot();
        String string = schemaVersion;
        return CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string) ? this.parseSchema(json, pointer, uri) : (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string) ? this.parseDraft07(json, pointer, uri) : this.parseSchema(json, pointer, uri));
    }

    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        JSONSchema.General result;
        block28: {
            URI uri;
            URI uRI;
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
            JSONValue schemaJSON = pointer.eval(json);
            if (schemaJSON instanceof JSONBoolean) {
                return ((JSONBoolean)schemaJSON).booleanValue() ? (JSONSchema)new JSONSchema.True(parentUri, pointer) : (JSONSchema)new JSONSchema.False(parentUri, pointer);
            }
            if (!(schemaJSON instanceof JSONObject)) {
                throw (Throwable)((Object)new JSONSchemaException("Schema is not boolean or object - " + this.pointerOrRoot(pointer)));
            }
            String id = Companion.getStringOrNull((JSONObject)schemaJSON, "$id");
            if (id == null) {
                uRI = parentUri;
            } else if (parentUri == null) {
                uRI = Companion.dropFragment(new URI(id));
            } else {
                URI uRI2 = parentUri.resolve(id);
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"parentUri.resolve(id)");
                uRI = Companion.dropFragment(uRI2);
            }
            URI uRI3 = uri = uRI;
            if (uRI3 != null) {
                URI uRI4 = uRI3;
                boolean bl = false;
                boolean bl2 = false;
                URI it = uRI4;
                boolean bl3 = false;
                URI fragmentURI = uri.resolve(pointer.toURIFragment());
                JSONSchema jSONSchema = this.schemaCache.get(fragmentURI);
                if (jSONSchema != null) {
                    JSONSchema jSONSchema2 = jSONSchema;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    JSONSchema it2 = jSONSchema2;
                    boolean bl6 = false;
                    if (it2 instanceof JSONSchema.False) {
                        throw (Throwable)new JSONPointerException("Recursive $ref - " + pointer);
                    }
                    return it2;
                }
                URI uRI5 = fragmentURI;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI5, (String)"fragmentURI");
                this.schemaCache.put(uRI5, new JSONSchema.False(uri, pointer));
            }
            String title = Companion.getStringOrNull((JSONObject)schemaJSON, "title");
            String description = Companion.getStringOrNull((JSONObject)schemaJSON, "description");
            boolean it = false;
            List children = new ArrayList();
            for (Map.Entry entry : ((JSONObject)schemaJSON).entrySet()) {
                String string = (String)entry.getKey();
                if (Intrinsics.areEqual((Object)string, (Object)"$ref")) {
                    children.add(this.parseRef(json, pointer.child("type"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"$defs") || Intrinsics.areEqual((Object)string, (Object)"$schema") || Intrinsics.areEqual((Object)string, (Object)"$id") || Intrinsics.areEqual((Object)string, (Object)"$comment") || Intrinsics.areEqual((Object)string, (Object)"title") || Intrinsics.areEqual((Object)string, (Object)"description") || Intrinsics.areEqual((Object)string, (Object)"then") || Intrinsics.areEqual((Object)string, (Object)"else")) continue;
                if (Intrinsics.areEqual((Object)string, (Object)"default")) {
                    children.add(new DefaultValidator(uri, pointer.child("default"), (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"allOf")) {
                    children.add(this.parseCombinationSchema(json, pointer.child("allOf"), uri, (JSONValue)entry.getValue(), (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AllOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            Intrinsics.checkParameterIsNotNull(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).allOf(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(JSONSchema.Companion.class);
                        }

                        public final String getName() {
                            return "allOf";
                        }

                        public final String getSignature() {
                            return "allOf(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)Lnet/pwall/json/schema/subschema/AllOfSchema;";
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"anyOf")) {
                    children.add(this.parseCombinationSchema(json, pointer.child("anyOf"), uri, (JSONValue)entry.getValue(), (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AnyOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            Intrinsics.checkParameterIsNotNull(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).anyOf(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(JSONSchema.Companion.class);
                        }

                        public final String getName() {
                            return "anyOf";
                        }

                        public final String getSignature() {
                            return "anyOf(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)Lnet/pwall/json/schema/subschema/AnyOfSchema;";
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"oneOf")) {
                    children.add(this.parseCombinationSchema(json, pointer.child("oneOf"), uri, (JSONValue)entry.getValue(), (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final OneOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            Intrinsics.checkParameterIsNotNull(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).oneOf(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(JSONSchema.Companion.class);
                        }

                        public final String getName() {
                            return "oneOf";
                        }

                        public final String getSignature() {
                            return "oneOf(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)Lnet/pwall/json/schema/subschema/OneOfSchema;";
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"not")) {
                    children.add(new JSONSchema.Not(uri, pointer.child("not"), this.parseSchema(json, pointer.child("not"), uri)));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"if")) {
                    children.add(this.parseIf(json, pointer, uri));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"type")) {
                    children.add(this.parseType(pointer.child("type"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"enum")) {
                    children.add(this.parseEnum(pointer.child("enum"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"const")) {
                    children.add(this.parseConst(pointer.child("const"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"properties")) {
                    children.add(this.parseProperties(json, pointer.child("properties"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"required")) {
                    children.add(this.parseRequired(pointer.child("required"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"items")) {
                    children.add(this.parseItems(json, pointer.child("items"), uri));
                    continue;
                }
                if (NumberValidator.Companion.getTypeKeywords().contains(string)) {
                    Object k = entry.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
                    JSONPointer jSONPointer = pointer.child((String)k);
                    Object k2 = entry.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k2, (String)"entry.key");
                    children.add(this.parseNumberLimit(jSONPointer, uri, NumberValidator.Companion.findType((String)k2), (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"maxLength")) {
                    children.add(this.parseStringLength(pointer.child("maxLength"), uri, StringValidator.ValidationType.MAX_LENGTH, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"minLength")) {
                    children.add(this.parseStringLength(pointer.child("minLength"), uri, StringValidator.ValidationType.MIN_LENGTH, (JSONValue)entry.getValue()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"pattern")) {
                    children.add(this.parsePattern(pointer.child("pattern"), uri, (JSONValue)entry.getValue()));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"format")) continue;
                Object v = entry.getValue();
                boolean bl = false;
                boolean bl7 = false;
                JSONValue value = (JSONValue)v;
                boolean bl8 = false;
                if (!(value instanceof JSONString)) {
                    throw (Throwable)((Object)new JSONSchemaException("Must be string - " + pointer.child("format")));
                }
                String string2 = ((JSONString)value).get();
                boolean bl9 = false;
                boolean bl10 = false;
                String it3 = string2;
                boolean bl11 = false;
                if (!FormatValidator.Companion.getTypeKeywords().contains(it3)) continue;
                JSONPointer jSONPointer = pointer.child("format");
                String string3 = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                children.add(new FormatValidator(uri, jSONPointer, FormatValidator.Companion.findType(string3)));
            }
            result = new JSONSchema.General(schemaVersion201909.get(0), title, description, uri, pointer, children);
            URI uRI6 = uri;
            if (uRI6 == null) break block28;
            URI uRI7 = uRI6;
            boolean bl = false;
            boolean bl12 = false;
            Object it4 = uRI7;
            boolean bl13 = false;
            URI uRI8 = uri.resolve(pointer.toURIFragment());
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI8, (String)"uri.resolve(pointer.toURIFragment())");
            this.schemaCache.put(uRI8, result);
        }
        return result;
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema ifSchema = this.parseSchema(json, pointer.child("if"), uri);
        JSONPointer jSONPointer = pointer.child("then");
        boolean bl = false;
        boolean bl2 = false;
        JSONPointer it = jSONPointer;
        boolean bl3 = false;
        JSONSchema thenSchema = it.exists(json) ? this.parseSchema(json, it, uri) : null;
        JSONPointer jSONPointer2 = pointer.child("else");
        bl2 = false;
        boolean bl4 = false;
        JSONPointer it2 = jSONPointer2;
        boolean bl5 = false;
        JSONSchema elseSchema = it2.exists(json) ? this.parseSchema(json, it2, uri) : null;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(array instanceof JSONArray)) {
            throw (Throwable)new JSONPointerException("Compound must take array - " + pointer);
        }
        Iterable iterable = (Iterable)array;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$mapIndexed = false;
        void var8_11 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n3 = n2;
            collection = collection2;
            boolean bl2 = false;
            JSONSchema jSONSchema = this.parseSchema(json, pointer.child((int)i), uri);
            collection.add(jSONSchema);
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        void refURIPath;
        if (!(value instanceof JSONString)) {
            throw (Throwable)new JSONPointerException("$ref must be string - " + pointer);
        }
        String string = (uri == null ? new URI(((JSONString)value).get()) : uri.resolve(((JSONString)value).get())).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(if (uri == null) URI(va\u2026(value.get())).toString()");
        String refURIString = string;
        Pair pair = StringsKt.contains$default((CharSequence)refURIString, (char)'#', (boolean)false, (int)2, null) ? TuplesKt.to((Object)StringsKt.substringBefore$default((String)refURIString, (char)'#', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)refURIString, (char)'#', null, (int)2, null)) : TuplesKt.to((Object)refURIString, (Object)"");
        String string2 = (String)pair.component1();
        String refURIFragment = (String)pair.component2();
        JSONValue refJSON = Intrinsics.areEqual((Object)refURIPath, (Object)String.valueOf(uri)) ? json : this.jsonReader.readJSON(new URI((String)(StringsKt.endsWith$default((CharSequence)((CharSequence)refURIPath), (char)'/', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)refURIPath, (int)1) : refURIPath)));
        JSONPointer refPointer = JSONPointer.Companion.fromURIFragment('#' + refURIFragment);
        if (!refPointer.exists(refJSON)) {
            throw (Throwable)((Object)new JSONSchemaException("$ref not found " + value + " - " + pointer));
        }
        JSONSchema target = this.parseSchema(refJSON, refPointer, new URI((String)refURIPath));
        return new RefSchema(uri, pointer, target);
    }

    private final ItemSchema parseItems(JSONValue json, JSONPointer pointer, URI uri) {
        return new ItemSchema(uri, pointer, this.parseSchema(json, pointer, uri));
    }

    private final PropertySchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONObject)) {
            throw (Throwable)((Object)new JSONSchemaException("properties must be object - " + pointer));
        }
        boolean bl = false;
        List properties = new ArrayList();
        Iterator iterator = ((JSONObject)value).keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String string = key = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            properties.add(TuplesKt.to((Object)key, (Object)this.parseSchema(json, pointer.child(string), uri)));
        }
        return new PropertySchema(uri, pointer, properties);
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONArray)) {
            throw (Throwable)((Object)new JSONSchemaException("required must be array - " + this.pointerOrRoot(pointer)));
        }
        boolean bl = false;
        List properties = new ArrayList();
        Iterable $this$forEachIndexed$iv = (Iterable)value;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            JSONValue jSONValue = (JSONValue)item$iv;
            int i = n2;
            boolean bl3 = false;
            if (!(entry instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("required items must be string - " + pointer.child(i)));
            }
            String string = ((JSONString)entry).get();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.get()");
            properties.add(string);
        }
        return new RequiredSchema(uri, pointer, properties);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            String string = ((JSONString)value).get();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.get()");
            list = CollectionsKt.listOf((Object)((Object)this.checkType(string)));
        } else if (jSONValue instanceof JSONArray) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n3 = n2;
                Collection collection2 = collection;
                boolean bl2 = false;
                if (!(item instanceof JSONString)) {
                    void index;
                    throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer.child((int)index)));
                }
                String string = ((JSONString)item).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.get()");
                JSONSchema.Type type = this.checkType(string);
                collection2.add(type);
            }
            list = (List)destination$iv$iv;
        } else {
            throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer));
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(String str) {
        for (JSONSchema.Type type : JSONSchema.Type.values()) {
            if (!Intrinsics.areEqual((Object)str, (Object)type.getValue())) continue;
            return type;
        }
        throw (Throwable)((Object)new JSONSchemaException("TODO"));
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONArray)) {
            throw (Throwable)((Object)new JSONSchemaException("enum must be array - " + this.pointerOrRoot(pointer)));
        }
        return new EnumValidator(uri, pointer, (JSONArray)value);
    }

    private final ConstValidator parseConst(JSONPointer pointer, URI uri, JSONValue value) {
        return new ConstValidator(uri, pointer, value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        Number number2;
        if (!(value instanceof JSONNumberValue)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be number (was " + JSONSchema.Companion.toErrorDisplay(value) + ") - " + this.pointerOrRoot(pointer)));
        }
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONDouble || jSONValue instanceof JSONFloat || jSONValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONNumberValue)value).bigDecimalValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"value.bigDecimalValue()");
            number2 = bigDecimal;
        } else {
            number2 = number = jSONValue instanceof JSONLong ? (Number)((JSONNumberValue)value).longValue() : (Number)((JSONNumberValue)value).intValue();
        }
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            throw (Throwable)((Object)new JSONSchemaException("multipleOf must be greater than 0 - " + this.pointerOrRoot(pointer)));
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        if (!(value instanceof JSONInteger)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be integer - " + this.pointerOrRoot(pointer)));
        }
        return new StringValidator(uri, pointer, condition, ((JSONInteger)value).get());
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be string - " + this.pointerOrRoot(pointer)));
        }
        try {
            String string = ((JSONString)value).get();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.get()");
            regex = new Regex(string);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new JSONSchemaException("pattern invalid (" + JSONSchema.Companion.toErrorDisplay(value) + ") - " + this.pointerOrRoot(pointer)));
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final String pointerOrRoot(@NotNull JSONPointer $this$pointerOrRoot) {
        return Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.Companion.getRoot()) ? "root" : $this$pointerOrRoot.toString();
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    public Parser(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Map map;
        Intrinsics.checkParameterIsNotNull(uriResolver, (String)"uriResolver");
        this.jsonReader = new JSONReader(uriResolver);
        Parser parser2 = this;
        boolean bl = false;
        parser2.schemaCache = map = (Map)new LinkedHashMap();
    }

    public /* synthetic */ Parser(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = defaultURIResolver;
        }
        this(function1);
    }

    public Parser() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        schemaVersion201909 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"});
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"});
        defaultURIResolver = Companion.defaultURIResolver.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0012\u001a\u00020\u0005*\u00020\u0005J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000b*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bJ\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001cJ\n\u0010\u001d\u001a\u00020\u001b*\u00020\u001cR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "()V", "defaultURIResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "getDefaultURIResolver", "()Lkotlin/jvm/functions/Function1;", "schemaVersion201909", "", "", "schemaVersion201909$annotations", "getSchemaVersion201909", "()Ljava/util/List;", "schemaVersionDraft07", "schemaVersionDraft07$annotations", "getSchemaVersionDraft07", "dropFragment", "getStringOrDefault", "Lnet/pwall/json/JSONObject;", "pointer", "Lnet/pwall/json/pointer/JSONPointer;", "default", "getStringOrNull", "key", "isPositive", "", "", "isZero", "json-kotlin-schema"})
    public static final class Companion {
        public static /* synthetic */ void schemaVersion201909$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        public static /* synthetic */ void schemaVersionDraft07$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        @NotNull
        public final Function1<URI, InputStream> getDefaultURIResolver() {
            return defaultURIResolver;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkParameterIsNotNull((Object)$this$dropFragment, (String)"$this$dropFragment");
            String string = $this$dropFragment.toString();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            return StringsKt.contains$default((CharSequence)string2, (char)'#', (boolean)false, (int)2, null) ? new URI(StringsKt.substringBefore$default((String)it, (char)'#', null, (int)2, null)) : $this$dropFragment;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue jSONValue2 = jSONValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            if (!(it instanceof JSONString)) throw (Throwable)((Object)new JSONSchemaException("Incorrect " + key));
            String string = ((JSONString)it).get();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @NotNull JSONPointer pointer) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrNull)) {
                return null;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrNull);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).get();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONObject $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getStringOrDefault, (String)"$this$getStringOrDefault");
            Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrDefault)) {
                return string;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrDefault);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).get();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isZero, (String)"$this$isZero");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigDecimal.ZERO) : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? Intrinsics.areEqual((Object)$this$isZero, (Object)0.0) : (number instanceof Float ? Intrinsics.areEqual((Object)$this$isZero, (Object)Float.valueOf(0.0f)) : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isPositive, (String)"$this$isPositive");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

