/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import net.pwall.json.validation.JSONValidation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0014\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"Lnet/pwall/json/schema/validation/FormatValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "checker", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;)V", "getChecker", "()Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "", "validate", "Companion", "DateFormatChecker", "DateTimeFormatChecker", "DelegatingFormatChecker", "DurationFormatChecker", "EmailFormatChecker", "FormatChecker", "HostnameFormatChecker", "IPV4FormatChecker", "IPV6FormatChecker", "Int32FormatChecker", "Int64FormatChecker", "JSONPointerFormatChecker", "NullFormatChecker", "RegexFormatChecker", "RelativeJSONPointerFormatChecker", "TimeFormatChecker", "URIFormatChecker", "URIReferenceFormatChecker", "UUIDFormatChecker", "json-kotlin-schema"})
public final class FormatValidator
extends JSONSchema.Validator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FormatChecker checker;
    @NotNull
    private static final List<FormatChecker> checkers;

    public FormatValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull FormatChecker checker) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        super(uri, location);
        this.checker = checker;
    }

    @NotNull
    public final FormatChecker getChecker() {
        return this.checker;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("format");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"child(...)");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        return this.checker.check(instanceLocation.eval(json));
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        return this.checker.check(instance) ? null : this.checker.getBasicErrorEntry(this, relativeLocation, instanceLocation, json);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FormatValidator && super.equals(other) && Intrinsics.areEqual((Object)this.checker, (Object)((FormatValidator)other).checker);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.checker.hashCode();
    }

    static {
        Object[] objectArray = new FormatChecker[]{DateTimeFormatChecker.INSTANCE, DateFormatChecker.INSTANCE, TimeFormatChecker.INSTANCE, DurationFormatChecker.INSTANCE, EmailFormatChecker.INSTANCE, HostnameFormatChecker.INSTANCE, IPV4FormatChecker.INSTANCE, IPV6FormatChecker.INSTANCE, URIFormatChecker.INSTANCE, URIReferenceFormatChecker.INSTANCE, UUIDFormatChecker.INSTANCE, JSONPointerFormatChecker.INSTANCE, RelativeJSONPointerFormatChecker.INSTANCE, RegexFormatChecker.INSTANCE, Int32FormatChecker.INSTANCE, Int64FormatChecker.INSTANCE};
        checkers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$Companion;", "", "()V", "checkers", "", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "findChecker", "keyword", "", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nFormatValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatValidator.kt\nnet/pwall/json/schema/validation/FormatValidator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FormatChecker findChecker(@NotNull String keyword) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
                Iterable iterable = checkers;
                for (Object t : iterable) {
                    FormatChecker it = (FormatChecker)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)keyword)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$DateFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class DateFormatChecker
    implements FormatChecker {
        @NotNull
        public static final DateFormatChecker INSTANCE = new DateFormatChecker();
        @NotNull
        private static final String name = "date";

        private DateFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isDate((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$DateTimeFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class DateTimeFormatChecker
    implements FormatChecker {
        @NotNull
        public static final DateTimeFormatChecker INSTANCE = new DateTimeFormatChecker();
        @NotNull
        private static final String name = "date-time";

        private DateTimeFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isDateTime((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$DelegatingFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "name", "", "validators", "", "Lnet/pwall/json/schema/JSONSchema$Validator;", "(Ljava/lang/String;[Lnet/pwall/json/schema/JSONSchema$Validator;)V", "getName", "()Ljava/lang/String;", "getValidators", "()[Lnet/pwall/json/schema/JSONSchema$Validator;", "[Lnet/pwall/json/schema/JSONSchema$Validator;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "equals", "other", "", "getBasicErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "schema", "Lnet/pwall/json/schema/JSONSchema;", "relativeLocation", "Lnet/pwall/json/pointer/JSONPointer;", "instanceLocation", "json", "hashCode", "", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nFormatValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatValidator.kt\nnet/pwall/json/schema/validation/FormatValidator$DelegatingFormatChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
    public static final class DelegatingFormatChecker
    implements FormatChecker {
        @NotNull
        private final String name;
        @NotNull
        private final JSONSchema.Validator[] validators;

        public DelegatingFormatChecker(@NotNull String name, JSONSchema.Validator ... validators) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)validators, (String)"validators");
            this.name = name;
            this.validators = validators;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final JSONSchema.Validator[] getValidators() {
            return this.validators;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            for (JSONSchema.Validator validator : this.validators) {
                if (JSONSchema.validate$default((JSONSchema)validator, value, null, 2, null)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
            Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
            for (JSONSchema.Validator validator : this.validators) {
                JSONPointer jSONPointer = relativeLocation.child(this.getName());
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"child(...)");
                BasicErrorEntry basicErrorEntry = validator.getErrorEntry(jSONPointer, json, instanceLocation);
                if (basicErrorEntry == null) continue;
                BasicErrorEntry it = basicErrorEntry;
                boolean bl = false;
                return it;
            }
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DelegatingFormatChecker && Intrinsics.areEqual((Object)this.getName(), (Object)((DelegatingFormatChecker)other).getName()) && Arrays.equals(this.validators, ((DelegatingFormatChecker)other).validators);
        }

        public int hashCode() {
            return this.getName().hashCode() ^ this.validators.hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$DurationFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class DurationFormatChecker
    implements FormatChecker {
        @NotNull
        public static final DurationFormatChecker INSTANCE = new DurationFormatChecker();
        @NotNull
        private static final String name = "duration";

        private DurationFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isDuration((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$EmailFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class EmailFormatChecker
    implements FormatChecker {
        @NotNull
        public static final EmailFormatChecker INSTANCE = new EmailFormatChecker();
        @NotNull
        private static final String name = "email";

        private EmailFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isEmail((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "getBasicErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "schema", "Lnet/pwall/json/schema/JSONSchema;", "relativeLocation", "Lnet/pwall/json/pointer/JSONPointer;", "instanceLocation", "json", "json-kotlin-schema"})
    public static interface FormatChecker {
        @NotNull
        public String getName();

        public boolean check(@Nullable JSONValue var1);

        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema var1, @NotNull JSONPointer var2, @NotNull JSONPointer var3, @Nullable JSONValue var4);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static BasicErrorEntry getBasicErrorEntry(@NotNull FormatChecker $this, @NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
                Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
                JSONValue jSONValue = instanceLocation.eval(json);
                return schema.createBasicErrorEntry(relativeLocation, instanceLocation, "Value fails format check \"" + $this.getName() + "\", was " + (jSONValue != null ? jSONValue.toJSON() : null));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$HostnameFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class HostnameFormatChecker
    implements FormatChecker {
        @NotNull
        public static final HostnameFormatChecker INSTANCE = new HostnameFormatChecker();
        @NotNull
        private static final String name = "hostname";

        private HostnameFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isHostname((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$IPV4FormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class IPV4FormatChecker
    implements FormatChecker {
        @NotNull
        public static final IPV4FormatChecker INSTANCE = new IPV4FormatChecker();
        @NotNull
        private static final String name = "ipv4";

        private IPV4FormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isIPV4((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$IPV6FormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class IPV6FormatChecker
    implements FormatChecker {
        @NotNull
        public static final IPV6FormatChecker INSTANCE = new IPV6FormatChecker();
        @NotNull
        private static final String name = "ipv6";

        private IPV6FormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isIPV6((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$Int32FormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class Int32FormatChecker
    implements FormatChecker {
        @NotNull
        public static final Int32FormatChecker INSTANCE = new Int32FormatChecker();
        @NotNull
        private static final String name = "int32";

        private Int32FormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean check(@Nullable JSONValue value) {
            JSONValue jSONValue = value;
            if (jSONValue instanceof JSONLong) {
                long l = ((JSONLong)value).getValue();
                if (Integer.MIN_VALUE > l) return false;
                if (l >= 0x80000000L) return false;
                return true;
            }
            if (jSONValue instanceof JSONDecimal) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(Integer.MIN_VALUE);
                    BigDecimal bigDecimal2 = new BigDecimal(Integer.MAX_VALUE);
                    BigDecimal bigDecimal3 = ((JSONDecimal)value).bigDecimalValue().setScale(0);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"setScale(...)");
                    BigDecimal bigDecimal4 = bigDecimal3;
                    if (0 > bigDecimal4.compareTo((Object)bigDecimal)) return false;
                    if (bigDecimal4.compareTo((Object)bigDecimal2) > 0) return false;
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            if (jSONValue instanceof JSONDouble) {
                double doubleValue = ((JSONDouble)value).getValue();
                if (doubleValue != Math.floor(doubleValue)) return false;
                boolean bl = true;
                if (!bl) return false;
                if (!(-2.147483648E9 <= doubleValue)) return false;
                if (!(doubleValue <= 2.147483647E9)) return false;
                return true;
            }
            if (!(jSONValue instanceof JSONFloat)) return true;
            float floatValue = ((JSONFloat)value).getValue();
            if (floatValue != (float)Math.floor(floatValue)) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!(-2.1474836E9f <= floatValue)) return false;
            if (!(floatValue <= 2.1474836E9f)) return false;
            return true;
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$Int64FormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class Int64FormatChecker
    implements FormatChecker {
        @NotNull
        public static final Int64FormatChecker INSTANCE = new Int64FormatChecker();
        @NotNull
        private static final String name = "int64";

        private Int64FormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean check(@Nullable JSONValue value) {
            JSONValue jSONValue = value;
            if (jSONValue instanceof JSONDecimal) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(Long.MIN_VALUE);
                    BigDecimal bigDecimal2 = new BigDecimal(Long.MAX_VALUE);
                    BigDecimal bigDecimal3 = ((JSONDecimal)value).bigDecimalValue().setScale(0);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"setScale(...)");
                    BigDecimal bigDecimal4 = bigDecimal3;
                    if (0 > bigDecimal4.compareTo((Object)bigDecimal)) return false;
                    if (bigDecimal4.compareTo((Object)bigDecimal2) > 0) return false;
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            if (jSONValue instanceof JSONDouble) {
                double doubleValue = ((JSONDouble)value).getValue();
                if (doubleValue != Math.floor(doubleValue)) return false;
                boolean bl = true;
                if (!bl) return false;
                if (!(-9.223372036854776E18 <= doubleValue)) return false;
                if (!(doubleValue <= 9.223372036854776E18)) return false;
                return true;
            }
            if (!(jSONValue instanceof JSONFloat)) return true;
            float floatValue = ((JSONFloat)value).getValue();
            if (floatValue != (float)Math.floor(floatValue)) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!(-9.223372E18f <= floatValue)) return false;
            if (!(floatValue <= 9.223372E18f)) return false;
            return true;
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$JSONPointerFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class JSONPointerFormatChecker
    implements FormatChecker {
        @NotNull
        public static final JSONPointerFormatChecker INSTANCE = new JSONPointerFormatChecker();
        @NotNull
        private static final String name = "json-pointer";

        private JSONPointerFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isJSONPointer((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$NullFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "equals", "other", "", "hashCode", "", "json-kotlin-schema"})
    public static final class NullFormatChecker
    implements FormatChecker {
        @NotNull
        private final String name;

        public NullFormatChecker(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof NullFormatChecker && Intrinsics.areEqual((Object)this.getName(), (Object)((NullFormatChecker)other).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$RegexFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class RegexFormatChecker
    implements FormatChecker {
        @NotNull
        public static final RegexFormatChecker INSTANCE = new RegexFormatChecker();
        @NotNull
        private static final String name = "regex";

        private RegexFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isRegex((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$RelativeJSONPointerFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class RelativeJSONPointerFormatChecker
    implements FormatChecker {
        @NotNull
        public static final RelativeJSONPointerFormatChecker INSTANCE = new RelativeJSONPointerFormatChecker();
        @NotNull
        private static final String name = "relative-json-pointer";

        private RelativeJSONPointerFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isRelativeJSONPointer((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$TimeFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class TimeFormatChecker
    implements FormatChecker {
        @NotNull
        public static final TimeFormatChecker INSTANCE = new TimeFormatChecker();
        @NotNull
        private static final String name = "time";

        private TimeFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isTime((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$URIFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class URIFormatChecker
    implements FormatChecker {
        @NotNull
        public static final URIFormatChecker INSTANCE = new URIFormatChecker();
        @NotNull
        private static final String name = "uri";

        private URIFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isURI((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$URIReferenceFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class URIReferenceFormatChecker
    implements FormatChecker {
        @NotNull
        public static final URIReferenceFormatChecker INSTANCE = new URIReferenceFormatChecker();
        @NotNull
        private static final String name = "uri-reference";

        private URIReferenceFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isURIReference((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$UUIDFormatChecker;", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "()V", "name", "", "getName", "()Ljava/lang/String;", "check", "", "value", "Lnet/pwall/json/JSONValue;", "json-kotlin-schema"})
    public static final class UUIDFormatChecker
    implements FormatChecker {
        @NotNull
        public static final UUIDFormatChecker INSTANCE = new UUIDFormatChecker();
        @NotNull
        private static final String name = "uuid";

        private UUIDFormatChecker() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        public boolean check(@Nullable JSONValue value) {
            return !(value instanceof JSONString) || JSONValidation.isUUID((String)((JSONString)value).getValue());
        }

        @Override
        @NotNull
        public BasicErrorEntry getBasicErrorEntry(@NotNull JSONSchema schema, @NotNull JSONPointer relativeLocation, @NotNull JSONPointer instanceLocation, @Nullable JSONValue json) {
            return FormatChecker.DefaultImpls.getBasicErrorEntry(this, schema, relativeLocation, instanceLocation, json);
        }
    }
}

