/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.pwall.json.JSON;
import net.pwall.json.JSONValue;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.InputDetails;
import net.pwall.json.schema.parser.Parser;
import net.pwall.yaml.YAMLNode;
import net.pwall.yaml.YAMLSimple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\f\u0010\u001c\u001a\u00020\u0011*\u00020\u000eH\u0002R*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0006R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/parser/JSONReader;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "extendedResolver", "Lnet/pwall/json/schema/parser/InputDetails;", "getExtendedResolver", "()Lkotlin/jvm/functions/Function1;", "setExtendedResolver", "jsonCache", "", "Lnet/pwall/json/JSONValue;", "getUriResolver", "preLoad", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "filename", "", "readByResolver", "uri", "readJSON", "string", "cacheById", "Companion", "json-kotlin-schema"})
@SourceDebugExtension(value={"SMAP\nJSONReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONReader.kt\nnet/pwall/json/schema/parser/JSONReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n13309#2,2:224\n1855#3,2:226\n*S KotlinDebug\n*F\n+ 1 JSONReader.kt\nnet/pwall/json/schema/parser/JSONReader\n*L\n52#1:224,2\n78#1:226,2\n*E\n"})
public final class JSONReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<URI, InputStream> uriResolver;
    @Nullable
    private Function1<? super URI, InputDetails> extendedResolver;
    @NotNull
    private final Map<URI, JSONValue> jsonCache;

    public JSONReader(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.uriResolver = uriResolver;
        this.jsonCache = new LinkedHashMap();
    }

    @NotNull
    public final Function1<URI, InputStream> getUriResolver() {
        return this.uriResolver;
    }

    @Nullable
    public final Function1<URI, InputDetails> getExtendedResolver() {
        return this.extendedResolver;
    }

    public final void setExtendedResolver(@Nullable Function1<? super URI, InputDetails> function1) {
        this.extendedResolver = function1;
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.preLoad(new File(filename));
    }

    public final void preLoad(@NotNull File file) {
        block3: {
            URI uri;
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isDirectory()) break block2;
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) break block3;
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.startsWith$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) continue;
                        Intrinsics.checkNotNull((Object)it);
                        this.preLoad(it);
                    }
                    break block3;
                }
                if (!file.isFile()) break block3;
                uri = file.toURI();
                if (this.jsonCache.containsKey(uri)) break block3;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith((String)string, (String)".json", (boolean)true)) break block4;
                JSONValue jSONValue = JSON.parse((File)file);
                if (jSONValue == null) break block3;
                JSONValue it = jSONValue;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)uri);
                this.jsonCache.put(uri, it);
                this.cacheById(it);
                break block3;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, string, null, 2, null)) break block3;
            YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
            if (yAMLNode != null) {
                YAMLNode it = yAMLNode;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)uri);
                this.jsonCache.put(uri, (JSONValue)it);
                this.cacheById((JSONValue)it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Files.isDirectory(path, new LinkOption[0])) {
            Closeable closeable = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                DirectoryStream dir = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)dir);
                Iterable $this$forEach$iv = dir;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((CharSequence)((Object)it.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNull((Object)it);
                    this.preLoad(it);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Object object = path.getFileName();
            if (object == null || (object = object.toString()) == null) {
                throw new JSONSchemaException("Path filename is null");
            }
            Object fileName = object;
            URI uri = path.toUri();
            if (!this.jsonCache.containsKey(uri)) {
                if (StringsKt.endsWith((String)fileName, (String)".json", (boolean)true)) {
                    Closeable closeable = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        JSONValue jSONValue;
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl = false;
                        JSONValue jSONValue2 = jSONValue = JSON.parse((Reader)reader);
                        if (jSONValue2 != null) {
                            Intrinsics.checkNotNull((Object)jSONValue2);
                            JSONValue it = jSONValue;
                            boolean bl3 = false;
                            Map<URI, JSONValue> map = this.jsonCache;
                            URI uRI = path.toUri();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
                            map.put(uRI, it);
                            this.cacheById(it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        reader = unit;
                    }
                    catch (Throwable reader) {
                        throwable = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, (String)fileName, null, 2, null)) {
                    Closeable closeable = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        YAMLNode yAMLNode;
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)reader);
                        YAMLNode yAMLNode2 = yAMLNode = YAMLSimple.INSTANCE.process((Reader)reader).getRootNode();
                        if (yAMLNode2 != null) {
                            Intrinsics.checkNotNull((Object)yAMLNode2);
                            YAMLNode it = yAMLNode;
                            boolean bl4 = false;
                            Map<URI, JSONValue> map = this.jsonCache;
                            URI uRI = path.toUri();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
                            map.put(uRI, (JSONValue)it);
                            this.cacheById((JSONValue)it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        }
    }

    @NotNull
    public final JSONValue readJSON(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URI uri = file.toURI();
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            JSONValue jSONValue2;
            try {
                JSONValue jSONValue3;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, string, null, 2, null)) {
                    YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
                    if (yAMLNode == null) {
                        throw new JSONSchemaException("Schema file is null - " + file);
                    }
                    jSONValue3 = (JSONValue)yAMLNode;
                } else {
                    jSONValue3 = JSON.parse((File)file);
                    if (jSONValue3 == null) {
                        throw new JSONSchemaException("Schema file is null - " + file);
                    }
                }
                jSONValue2 = jSONValue3;
            }
            catch (JSONSchemaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONSchemaException("Error reading schema file - " + file, e);
            }
            JSONValue it = jSONValue2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)uri);
            this.jsonCache.put(uri, it);
            this.cacheById(it);
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    @NotNull
    public final JSONValue readJSON(@NotNull String string, @Nullable URI uri) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (uri != null) {
            JSONValue jSONValue = this.jsonCache.get(uri);
            if (jSONValue == null) {
                JSONValue jSONValue2;
                JSONValue jSONValue3 = JSON.parse((CharSequence)string);
                if (jSONValue3 != null) {
                    JSONValue jSONValue4;
                    JSONValue it = jSONValue4 = jSONValue3;
                    boolean bl = false;
                    this.jsonCache.put(uri, it);
                    this.cacheById(it);
                    jSONValue2 = jSONValue4;
                } else {
                    jSONValue2 = jSONValue = null;
                }
                if (jSONValue2 == null) {
                    throw new JSONSchemaException("Schema is null");
                }
            }
            return jSONValue;
        }
        JSONValue jSONValue = JSON.parse((CharSequence)string);
        if (jSONValue == null) {
            throw new JSONSchemaException("Schema is null");
        }
        return jSONValue;
    }

    public static /* synthetic */ JSONValue readJSON$default(JSONReader jSONReader, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        return jSONReader.readJSON(string, uRI);
    }

    @NotNull
    public final JSONValue readJSON(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            JSONValue jSONValue2;
            try {
                jSONValue2 = this.readByResolver(uri);
            }
            catch (JSONSchemaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONSchemaException("Error reading schema file - " + uri, e);
            }
            JSONValue it = jSONValue2;
            boolean bl = false;
            this.jsonCache.put(uri, it);
            this.cacheById(it);
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONValue readByResolver(URI uri) {
        JSONValue jSONValue;
        Function1<? super URI, InputDetails> function1 = this.extendedResolver;
        if (function1 != null) {
            JSONValue jSONValue2;
            Function1<? super URI, InputDetails> resolver = function1;
            boolean bl = false;
            InputDetails inputDetails = (InputDetails)resolver.invoke((Object)uri);
            if (inputDetails == null) {
                throw new JSONSchemaException("Can't resolve name - " + uri);
            }
            InputDetails inputDetails2 = inputDetails;
            Closeable closeable = inputDetails2.getReader();
            Throwable throwable = null;
            try {
                JSONValue jSONValue3;
                Reader it = (Reader)closeable;
                boolean bl2 = false;
                if (Companion.looksLikeYAML(Companion.extendedPath(uri), inputDetails2.getContentType())) {
                    YAMLNode yAMLNode;
                    YAMLNode yAMLNode2 = yAMLNode = YAMLSimple.INSTANCE.process(it).getRootNode();
                    if (yAMLNode2 == null) {
                        throw new JSONSchemaException("Schema file is null - " + uri);
                    }
                    Intrinsics.checkNotNull((Object)yAMLNode2);
                    jSONValue3 = (JSONValue)yAMLNode;
                } else {
                    JSONValue jSONValue4;
                    JSONValue jSONValue5 = jSONValue4 = JSON.parse((Reader)it);
                    if (jSONValue5 == null) {
                        throw new JSONSchemaException("Schema file is null - " + uri);
                    }
                    Intrinsics.checkNotNull((Object)jSONValue5);
                    jSONValue3 = jSONValue4;
                }
                jSONValue2 = jSONValue3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return jSONValue2;
        }
        InputStream inputStream = (InputStream)this.uriResolver.invoke((Object)uri);
        if (inputStream == null) {
            throw new JSONSchemaException("Can't resolve name - " + uri);
        }
        InputStream inputStream2 = inputStream;
        Closeable closeable = inputStream2;
        Throwable throwable = null;
        try {
            JSONValue jSONValue6;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, Companion.extendedPath(uri), null, 2, null)) {
                YAMLNode yAMLNode;
                YAMLNode yAMLNode3 = yAMLNode = YAMLSimple.INSTANCE.process(it).getRootNode();
                if (yAMLNode3 == null) {
                    throw new JSONSchemaException("Schema file is null - " + uri);
                }
                Intrinsics.checkNotNull((Object)yAMLNode3);
                jSONValue6 = (JSONValue)yAMLNode;
            } else {
                JSONValue jSONValue7;
                JSONValue jSONValue8 = jSONValue7 = JSON.parse((InputStream)it);
                if (jSONValue8 == null) {
                    throw new JSONSchemaException("Schema file is null - " + uri);
                }
                Intrinsics.checkNotNull((Object)jSONValue8);
                jSONValue6 = jSONValue7;
            }
            jSONValue = jSONValue6;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return jSONValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONValue readJSON(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URI uri = path.toUri();
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            JSONValue jSONValue2;
            try {
                JSONValue jSONValue3;
                Object object = path.getFileName();
                if (object == null || (object = object.toString()) == null) {
                    throw new JSONSchemaException("Path filename is null");
                }
                Object fileName = object;
                Closeable closeable = Files.newBufferedReader(path);
                Throwable throwable = null;
                try {
                    JSONValue jSONValue4;
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, (String)fileName, null, 2, null)) {
                        YAMLNode yAMLNode;
                        Intrinsics.checkNotNull((Object)reader);
                        YAMLNode yAMLNode2 = yAMLNode = YAMLSimple.INSTANCE.process((Reader)reader).getRootNode();
                        if (yAMLNode2 == null) {
                            throw new JSONSchemaException("Schema file is null - " + path);
                        }
                        Intrinsics.checkNotNull((Object)yAMLNode2);
                        jSONValue4 = (JSONValue)yAMLNode;
                    } else {
                        JSONValue jSONValue5;
                        JSONValue jSONValue6 = jSONValue5 = JSON.parse((Reader)reader);
                        if (jSONValue6 == null) {
                            throw new JSONSchemaException("Schema file is null - " + path);
                        }
                        Intrinsics.checkNotNull((Object)jSONValue6);
                        jSONValue4 = jSONValue5;
                    }
                    jSONValue3 = jSONValue4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                jSONValue2 = jSONValue3;
            }
            catch (Exception e) {
                throw new JSONSchemaException("Error reading schema file - " + path, e);
            }
            JSONValue it = jSONValue2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)uri);
            this.jsonCache.put(uri, it);
            this.cacheById(it);
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    private final void cacheById(JSONValue $this$cacheById) {
        block0: {
            String string = Parser.Companion.getIdOrNull($this$cacheById);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.jsonCache.put(Parser.Companion.dropFragment(new URI(it)), $this$cacheById);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\n\u0010\b\u001a\u00020\u0006*\u00020\t\u00a8\u0006\n"}, d2={"Lnet/pwall/json/schema/parser/JSONReader$Companion;", "", "()V", "looksLikeYAML", "", "path", "", "contentType", "extendedPath", "Ljava/net/URI;", "json-kotlin-schema"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean looksLikeYAML(@NotNull String path, @Nullable String contentType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = contentType;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.contains((CharSequence)it, (CharSequence)"yaml", (boolean)true) || StringsKt.contains((CharSequence)it, (CharSequence)"yml", (boolean)true)) {
                    return true;
                }
                if (StringsKt.contains((CharSequence)it, (CharSequence)"json", (boolean)true)) {
                    return false;
                }
            }
            return StringsKt.endsWith((String)path, (String)".yaml", (boolean)true) || StringsKt.endsWith((String)path, (String)".yml", (boolean)true);
        }

        public static /* synthetic */ boolean looksLikeYAML$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.looksLikeYAML(string, string2);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String extendedPath(@NotNull URI $this$extendedPath) {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)$this$extendedPath, (String)"<this>");
                    var2_2 = $this$extendedPath.getScheme();
                    if (var2_2 == null) break block8;
                    switch (var2_2.hashCode()) {
                        case 3143036: {
                            if (!var2_2.equals("file")) {
                                ** break;
                            }
                            ** GOTO lbl18
                        }
                        case 3213448: {
                            if (!var2_2.equals("http")) {
                                ** break;
                            }
                            ** GOTO lbl18
                        }
                        case 104987: {
                            if (var2_2.equals("jar")) break;
                            ** break;
                        }
                        case 99617003: {
                            if (!var2_2.equals("https")) ** break;
lbl18:
                            // 3 sources

                            v0 = $this$extendedPath.getPath();
                            v1 = v0;
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                            break block9;
                        }
                    }
                    v2 = $this$extendedPath.getSchemeSpecificPart();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getSchemeSpecificPart(...)");
                    v1 = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)v2, (String)"?", null, (int)2, null), (String)"!", null, (int)2, null);
                    break block9;
                }
                v1 = "UNKNOWN";
            }
            return v1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

