/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.json.JSON;
import net.pwall.json.JSONValue;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.InputDetails;
import net.pwall.json.schema.parser.Parser;
import net.pwall.yaml.YAMLNode;
import net.pwall.yaml.YAMLSimple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\f\u0010\u001c\u001a\u00020\u0011*\u00020\u000eH\u0002R*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0006R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/parser/JSONReader;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "extendedResolver", "Lnet/pwall/json/schema/parser/InputDetails;", "getExtendedResolver", "()Lkotlin/jvm/functions/Function1;", "setExtendedResolver", "jsonCache", "", "Lnet/pwall/json/JSONValue;", "getUriResolver", "preLoad", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "filename", "", "readByResolver", "uri", "readJSON", "string", "cacheById", "Companion", "json-kotlin-schema"})
public final class JSONReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<URI, InputStream> uriResolver;
    @Nullable
    private Function1<? super URI, InputDetails> extendedResolver;
    @NotNull
    private final Map<URI, JSONValue> jsonCache;

    public JSONReader(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.uriResolver = uriResolver;
        this.jsonCache = new LinkedHashMap();
    }

    @NotNull
    public final Function1<URI, InputStream> getUriResolver() {
        return this.uriResolver;
    }

    @Nullable
    public final Function1<URI, InputDetails> getExtendedResolver() {
        return this.extendedResolver;
    }

    public final void setExtendedResolver(@Nullable Function1<? super URI, InputDetails> function1) {
        this.extendedResolver = function1;
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.preLoad(new File(filename));
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                for (File element$iv : $this$forEach$iv) {
                    File it = element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (StringsKt.startsWith$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.preLoad(it);
                }
            }
        } else if (file.isFile()) {
            URI uri = file.toURI();
            if (!this.jsonCache.containsKey(uri)) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (StringsKt.endsWith((String)string, (String)".json", (boolean)true)) {
                    JSONValue jSONValue = JSON.parse((File)file);
                    if (jSONValue != null) {
                        JSONValue it = jSONValue;
                        boolean bl = false;
                        Map<URI, JSONValue> map = this.jsonCache;
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                        URI uRI = uri;
                        map.put(uRI, it);
                        this.cacheById(it);
                    }
                } else {
                    string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, string, null, 2, null)) {
                        YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
                        if (yAMLNode != null) {
                            YAMLNode it = yAMLNode;
                            boolean bl = false;
                            Map<URI, JSONValue> map = this.jsonCache;
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                            URI uRI = uri;
                            map.put(uRI, (JSONValue)it);
                            this.cacheById((JSONValue)it);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Files.isDirectory(path, new LinkOption[0])) {
            Closeable closeable = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                DirectoryStream dir = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                Iterable $this$forEach$iv = dir;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((CharSequence)((Object)it.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.preLoad(it);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Path path2 = path.getFileName();
            String string = path2 == null ? null : ((Object)path2).toString();
            if (string == null) {
                throw new JSONSchemaException("Path filename is null");
            }
            String fileName = string;
            URI uri = path.toUri();
            if (!this.jsonCache.containsKey(uri)) {
                if (StringsKt.endsWith((String)fileName, (String)".json", (boolean)true)) {
                    Closeable closeable = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl = false;
                        JSONValue jSONValue = JSON.parse((Reader)reader);
                        if (jSONValue == null) {
                            unit = null;
                        } else {
                            JSONValue it = jSONValue;
                            boolean bl3 = false;
                            Map<URI, JSONValue> map = this.jsonCache;
                            URI uRI = path.toUri();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"path.toUri()");
                            map.put(uRI, it);
                            this.cacheById(it);
                            unit = Unit.INSTANCE;
                        }
                        reader = unit;
                    }
                    catch (Throwable reader) {
                        throwable = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, fileName, null, 2, null)) {
                    Closeable closeable = Files.newBufferedReader(path);
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"reader");
                        YAMLNode yAMLNode = YAMLSimple.INSTANCE.process((Reader)reader).getRootNode();
                        if (yAMLNode == null) {
                            unit = null;
                        } else {
                            YAMLNode it = yAMLNode;
                            boolean bl4 = false;
                            Map<URI, JSONValue> map = this.jsonCache;
                            URI uRI = path.toUri();
                            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"path.toUri()");
                            map.put(uRI, (JSONValue)it);
                            this.cacheById((JSONValue)it);
                            unit = Unit.INSTANCE;
                        }
                        Unit unit2 = unit;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        }
    }

    @NotNull
    public final JSONValue readJSON(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URI uri = file.toURI();
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            String string;
            try {
                JSONValue jSONValue2;
                string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, string, null, 2, null)) {
                    YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
                    if (yAMLNode == null) {
                        throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)file));
                    }
                    jSONValue2 = (JSONValue)yAMLNode;
                } else {
                    jSONValue2 = JSON.parse((File)file);
                    if (jSONValue2 == null) {
                        throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)file));
                    }
                }
                string = jSONValue2;
            }
            catch (JSONSchemaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONSchemaException(Intrinsics.stringPlus((String)"Error reading schema file - ", (Object)file), e);
            }
            String it = string;
            boolean bl = false;
            Map<URI, JSONValue> map = this.jsonCache;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            URI uRI = uri;
            map.put(uRI, (JSONValue)it);
            this.cacheById((JSONValue)it);
            object = string;
        } else {
            object = jSONValue;
        }
        return object;
    }

    @NotNull
    public final JSONValue readJSON(@NotNull String string, @Nullable URI uri) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (uri != null) {
            JSONValue jSONValue = this.jsonCache.get(uri);
            if (jSONValue == null) {
                JSONValue jSONValue2;
                JSONValue jSONValue3;
                JSONValue jSONValue4 = JSON.parse((CharSequence)string);
                if (jSONValue4 == null) {
                    jSONValue3 = null;
                } else {
                    JSONValue jSONValue5;
                    JSONValue it = jSONValue5 = jSONValue4;
                    boolean bl = false;
                    this.jsonCache.put(uri, it);
                    this.cacheById(it);
                    jSONValue3 = jSONValue2 = jSONValue5;
                }
                if (jSONValue2 == null) {
                    throw new JSONSchemaException("Schema is null");
                }
                jSONValue = jSONValue2;
            }
            return jSONValue;
        }
        JSONValue jSONValue = JSON.parse((CharSequence)string);
        if (jSONValue == null) {
            throw new JSONSchemaException("Schema is null");
        }
        return jSONValue;
    }

    public static /* synthetic */ JSONValue readJSON$default(JSONReader jSONReader, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        return jSONReader.readJSON(string, uRI);
    }

    @NotNull
    public final JSONValue readJSON(@NotNull URI uri) {
        JSONValue jSONValue;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONValue jSONValue2 = this.jsonCache.get(uri);
        if (jSONValue2 == null) {
            JSONValue jSONValue3;
            try {
                jSONValue3 = this.readByResolver(uri);
            }
            catch (JSONSchemaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONSchemaException(Intrinsics.stringPlus((String)"Error reading schema file - ", (Object)uri), e);
            }
            JSONValue it = jSONValue3;
            boolean bl = false;
            this.jsonCache.put(uri, it);
            this.cacheById(it);
            jSONValue = jSONValue3;
        } else {
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONValue readByResolver(URI uri) {
        JSONValue jSONValue;
        Function1<? super URI, InputDetails> function1 = this.extendedResolver;
        if (function1 != null) {
            JSONValue jSONValue2;
            Function1<? super URI, InputDetails> resolver = function1;
            boolean bl = false;
            InputDetails inputDetails = (InputDetails)resolver.invoke((Object)uri);
            if (inputDetails == null) {
                throw new JSONSchemaException(Intrinsics.stringPlus((String)"Can't resolve name - ", (Object)uri));
            }
            InputDetails inputDetails2 = inputDetails;
            Closeable closeable = inputDetails2.getReader();
            Throwable throwable = null;
            try {
                JSONValue jSONValue3;
                Reader it = (Reader)closeable;
                boolean bl2 = false;
                String string = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
                if (Companion.looksLikeYAML(string, inputDetails2.getContentType())) {
                    YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(it).getRootNode();
                    if (yAMLNode == null) {
                        throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)uri));
                    }
                    jSONValue3 = (JSONValue)yAMLNode;
                } else {
                    jSONValue3 = JSON.parse((Reader)it);
                    if (jSONValue3 == null) {
                        throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)uri));
                    }
                }
                jSONValue2 = jSONValue3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return jSONValue2;
        }
        InputStream inputStream = (InputStream)this.uriResolver.invoke((Object)uri);
        if (inputStream == null) {
            throw new JSONSchemaException(Intrinsics.stringPlus((String)"Can't resolve name - ", (Object)uri));
        }
        InputStream inputStream2 = inputStream;
        Closeable closeable = inputStream2;
        Throwable throwable = null;
        try {
            JSONValue jSONValue4;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
            if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, string, null, 2, null)) {
                YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(it).getRootNode();
                if (yAMLNode == null) {
                    throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)uri));
                }
                jSONValue4 = (JSONValue)yAMLNode;
            } else {
                jSONValue4 = JSON.parse((InputStream)it);
                if (jSONValue4 == null) {
                    throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)uri));
                }
            }
            jSONValue = jSONValue4;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return jSONValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONValue readJSON(@NotNull Path path) {
        JSONValue jSONValue;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URI uri = path.toUri();
        JSONValue jSONValue2 = this.jsonCache.get(uri);
        if (jSONValue2 == null) {
            JSONValue jSONValue3;
            Object object;
            try {
                Path path2 = path.getFileName();
                String string = path2 == null ? null : ((Object)path2).toString();
                if (string == null) {
                    throw new JSONSchemaException("Path filename is null");
                }
                String fileName = string;
                Closeable closeable = Files.newBufferedReader(path);
                Throwable throwable = null;
                try {
                    JSONValue jSONValue4;
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    if (net.pwall.json.schema.parser.JSONReader$Companion.looksLikeYAML$default(Companion, fileName, null, 2, null)) {
                        Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"reader");
                        YAMLNode yAMLNode = YAMLSimple.INSTANCE.process((Reader)reader).getRootNode();
                        if (yAMLNode == null) {
                            throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)path));
                        }
                        jSONValue4 = (JSONValue)yAMLNode;
                    } else {
                        jSONValue4 = JSON.parse((Reader)reader);
                        if (jSONValue4 == null) {
                            throw new JSONSchemaException(Intrinsics.stringPlus((String)"Schema file is null - ", (Object)path));
                        }
                    }
                    object = jSONValue4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                jSONValue3 = object;
            }
            catch (Exception e) {
                throw new JSONSchemaException(Intrinsics.stringPlus((String)"Error reading schema file - ", (Object)path), e);
            }
            JSONValue it = jSONValue3;
            boolean bl = false;
            object = this.jsonCache;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            URI uRI = uri;
            object.put(uRI, it);
            this.cacheById(it);
            jSONValue = jSONValue3;
        } else {
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    private final void cacheById(JSONValue $this$cacheById) {
        String string = Parser.Companion.getIdOrNull($this$cacheById);
        if (string != null) {
            String it = string;
            boolean bl = false;
            Map<URI, JSONValue> map = this.jsonCache;
            URI uRI = Parser.Companion.dropFragment(new URI(it));
            map.put(uRI, $this$cacheById);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lnet/pwall/json/schema/parser/JSONReader$Companion;", "", "()V", "looksLikeYAML", "", "path", "", "contentType", "json-kotlin-schema"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean looksLikeYAML(@NotNull String path, @Nullable String contentType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = contentType;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.contains((CharSequence)it, (CharSequence)"yaml", (boolean)true) || StringsKt.contains((CharSequence)it, (CharSequence)"yml", (boolean)true)) {
                    return true;
                }
                if (StringsKt.contains((CharSequence)it, (CharSequence)"json", (boolean)true)) {
                    return false;
                }
            }
            return StringsKt.endsWith((String)path, (String)".yaml", (boolean)true) || StringsKt.endsWith((String)path, (String)".yml", (boolean)true);
        }

        public static /* synthetic */ boolean looksLikeYAML$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.looksLikeYAML(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

