/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\u001a\u0010\u001a\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001b"}, d2={"Lnet/pwall/json/schema/validation/ContainsValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "containsSchema", "Lnet/pwall/json/schema/JSONSchema;", "minContains", "", "maxContains", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/JSONSchema;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "validate", "json-kotlin-schema"})
public final class ContainsValidator
extends JSONSchema.Validator {
    @NotNull
    private final JSONSchema containsSchema;
    @Nullable
    private final Integer minContains;
    @Nullable
    private final Integer maxContains;

    public ContainsValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull JSONSchema containsSchema, @Nullable Integer minContains, @Nullable Integer maxContains) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)containsSchema, (String)"containsSchema");
        super(uri, location);
        this.containsSchema = containsSchema;
        this.minContains = minContains;
        this.maxContains = maxContains;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"contains\")");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        int it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return true;
        }
        int count = 0;
        int n = 0;
        int n2 = ((JSONSequence)instance).size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                JSONPointer jSONPointer = instanceLocation.child(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
                if (!this.containsSchema.validate(json, jSONPointer)) continue;
                int n3 = count;
                count = n3 + 1;
            } while (n <= n2);
        }
        if (this.minContains == null && count == 0) {
            return false;
        }
        Integer n4 = this.minContains;
        if (n4 != null) {
            Integer n5 = n4;
            bl = false;
            boolean bl2 = false;
            it = ((Number)n5).intValue();
            boolean bl3 = false;
            if (count < it) {
                return false;
            }
        }
        n4 = this.maxContains;
        if (n4 != null) {
            Integer n6 = n4;
            bl = false;
            boolean bl4 = false;
            it = ((Number)n6).intValue();
            boolean bl5 = false;
            if (count > it) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        int it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return null;
        }
        int count = 0;
        int n = 0;
        int n2 = ((JSONSequence)instance).size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                JSONPointer jSONPointer = instanceLocation.child(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
                if (!this.containsSchema.validate(json, jSONPointer)) continue;
                int n3 = count;
                count = n3 + 1;
            } while (n <= n2);
        }
        if (this.minContains == null && count == 0) {
            return this.createBasicErrorEntry(relativeLocation, instanceLocation, "No matching entry");
        }
        Integer n4 = this.minContains;
        if (n4 != null) {
            Integer n5 = n4;
            bl = false;
            boolean bl2 = false;
            it = ((Number)n5).intValue();
            boolean bl3 = false;
            if (count < it) {
                String string;
                Object object = relativeLocation.parent().child("minContains");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"relativeLocation.parent().child(\"minContains\")");
                String string2 = JSONSchema.Companion.schemaURIFragment((JSONPointer)object);
                object = this.getUri();
                if (object == null) {
                    string = null;
                } else {
                    void x;
                    Object object2 = object;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object object3 = object2;
                    String string3 = string2;
                    boolean bl6 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(x);
                    JSONPointer jSONPointer = this.getLocation().parent().child("minContains");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"location.parent().child(\"minContains\")");
                    String string4 = stringBuilder.append(JSONSchema.Companion.schemaURIFragment(jSONPointer)).toString();
                    string2 = string3;
                    string = string4;
                }
                String string5 = "Matching entry minimum " + it + ", was " + count;
                String string6 = JSONSchema.Companion.schemaURIFragment(instanceLocation);
                String string7 = string;
                String string8 = string2;
                return new BasicErrorEntry(string8, string7, string6, string5);
            }
        }
        n4 = this.maxContains;
        if (n4 != null) {
            Integer n6 = n4;
            bl = false;
            boolean bl7 = false;
            it = ((Number)n6).intValue();
            boolean bl8 = false;
            if (count > it) {
                String string;
                Object object = relativeLocation.parent().child("maxContains");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"relativeLocation.parent().child(\"maxContains\")");
                String string9 = JSONSchema.Companion.schemaURIFragment((JSONPointer)object);
                object = this.getUri();
                if (object == null) {
                    string = null;
                } else {
                    Object object4 = object;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    Object x = object4;
                    String string10 = string9;
                    boolean bl11 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(x);
                    JSONPointer jSONPointer = this.getLocation().parent().child("maxContains");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"location.parent().child(\"maxContains\")");
                    String string11 = stringBuilder.append(JSONSchema.Companion.schemaURIFragment(jSONPointer)).toString();
                    string9 = string10;
                    string = string11;
                }
                String string12 = "Matching entry maximum " + it + ", was " + count;
                String string13 = JSONSchema.Companion.schemaURIFragment(instanceLocation);
                String string14 = string;
                String string15 = string9;
                return new BasicErrorEntry(string15, string14, string13, string12);
            }
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ContainsValidator && super.equals(other) && Intrinsics.areEqual((Object)this.containsSchema, (Object)((ContainsValidator)other).containsSchema) && Intrinsics.areEqual((Object)this.minContains, (Object)((ContainsValidator)other).minContains) && Intrinsics.areEqual((Object)this.maxContains, (Object)((ContainsValidator)other).maxContains);
    }

    @Override
    public int hashCode() {
        Integer n = this.minContains;
        boolean bl = false;
        Integer n2 = n;
        n = this.maxContains;
        bl = false;
        Integer n3 = n;
        return super.hashCode() ^ this.containsSchema.hashCode() ^ (n2 != null ? ((Object)n2).hashCode() : 0) ^ (n3 != null ? ((Object)n3).hashCode() : 0);
    }
}

