/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.subschema;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicOutput;
import net.pwall.json.schema.output.DetailedOutput;
import net.pwall.json.schema.output.Output;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/pwall/json/schema/subschema/ItemsSchema;", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "itemSchema", "Lnet/pwall/json/schema/JSONSchema;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/JSONSchema;)V", "getItemSchema", "()Lnet/pwall/json/schema/JSONSchema;", "childLocation", "pointer", "equals", "", "other", "", "hashCode", "", "validate", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "validateBasic", "Lnet/pwall/json/schema/output/BasicOutput;", "relativeLocation", "validateDetailed", "Lnet/pwall/json/schema/output/DetailedOutput;", "json-kotlin-schema"})
public final class ItemsSchema
extends JSONSchema.SubSchema {
    @NotNull
    private final JSONSchema itemSchema;

    public ItemsSchema(@Nullable URI uri, @NotNull JSONPointer location, @NotNull JSONSchema itemSchema) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)itemSchema, (String)"itemSchema");
        super(uri, location);
        this.itemSchema = itemSchema;
    }

    @NotNull
    public final JSONSchema getItemSchema() {
        return this.itemSchema;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("items");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"items\")");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return true;
        }
        int n = 0;
        int n2 = ((JSONSequence)instance).size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                JSONPointer jSONPointer = instanceLocation.child(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
                if (this.itemSchema.validate(json, jSONPointer)) continue;
                return false;
            } while (n <= n2);
        }
        return true;
    }

    @Override
    @NotNull
    public BasicOutput validateBasic(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return BasicOutput.Companion.getTrueOutput();
        }
        int n = 0;
        List errors = new ArrayList();
        n = 0;
        int n2 = ((JSONSequence)instance).size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                Object object = instanceLocation.child(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"instanceLocation.child(i)");
                object = this.itemSchema.validateBasic(relativeLocation, json, (JSONPointer)object);
                boolean bl = false;
                boolean bl2 = false;
                Object itemResult = object;
                boolean bl3 = false;
                if (((Output)itemResult).getValid()) continue;
                JSONSchema.Companion.addAllFromNullable(errors, (Collection)((BasicOutput)itemResult).getErrors());
            } while (n <= n2);
        }
        if (errors.isEmpty()) {
            return BasicOutput.Companion.getTrueOutput();
        }
        return new BasicOutput(false, errors);
    }

    @Override
    @NotNull
    public DetailedOutput validateDetailed(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        DetailedOutput detailedOutput;
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "Value is not an array", null, null, 24, null);
        }
        int n = 0;
        List errors = new ArrayList();
        n = 0;
        int n2 = ((JSONSequence)instance).size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                JSONPointer jSONPointer = instanceLocation.child(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
                DetailedOutput itemResult = this.itemSchema.validateDetailed(relativeLocation, json, jSONPointer);
                if (itemResult.getValid()) continue;
                errors.add(itemResult);
            } while (n <= n2);
        }
        n = errors.size();
        switch (n) {
            case 0: {
                detailedOutput = JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "All items are valid", null, null, 24, null);
                break;
            }
            case 1: {
                detailedOutput = (DetailedOutput)errors.get(0);
                break;
            }
            default: {
                detailedOutput = JSONSchema.createError$default(this, relativeLocation, instanceLocation, "Errors in array items", errors, null, 16, null);
            }
        }
        return detailedOutput;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ItemsSchema && super.equals(other) && Intrinsics.areEqual((Object)this.itemSchema, (Object)((ItemsSchema)other).itemSchema);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.itemSchema.hashCode();
    }
}

