/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.model;

import hudson.model.BuildListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RQMObjectParseException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMGetRequest;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import net.praqma.util.structure.Tuple;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestScript
extends RqmObject<TestScript> {
    private static final String RESOURCE_RQM_MANUAL_NAME = "testscript";
    private static final String RESOURCE_RQM_NONMANUAL_NAME = "remotescript";
    private static final Logger log = Logger.getLogger(TestScript.class.getName());
    private String scriptTitle = "No script type defined";
    private boolean manual = false;
    private boolean executionSuccess = true;
    public HashMap<String, String> customAttributes = new HashMap();

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    public String getScriptTitle() {
        return this.scriptTitle;
    }

    public void setScriptTitle(String scriptTitle) {
        this.scriptTitle = scriptTitle;
    }

    @Override
    public List<TestScript> read(RqmParameterList parameters, BuildListener listener) throws IOException {
        RQMHttpClient client = null;
        try {
            client = RQMUtilities.createClient(parameters);
        }
        catch (MalformedURLException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught MalformedURLException in read throwing IO Exception", ex);
            throw new IOException("RqmMethodInvoker exception", ex);
        }
        catch (ClientCreationException cre) {
            log.logp(Level.SEVERE, this.getClass().getName(), "read", "Caught ClientCreationException in read throwing IO Exception", cre);
            throw new IOException("RqmMethodInvoker exception(ClientCreationException)", cre);
        }
        try {
            Tuple<Integer, String> res = new RQMGetRequest(client, this.getRqmObjectResourceUrl(), parameters.parameterList).executeRequest();
            this.initializeSingleResource((String)res.t2);
            return Arrays.asList(this);
        }
        catch (LoginException loginex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught login exception in invoke");
            throw new IOException("RqmMethodInvoker exception(LoginException)", loginex);
        }
        catch (RequestException reqExeception) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught RequestException in invoke");
            throw new IOException("RqmMethodInvoker exception(RequestException)", reqExeception);
        }
        catch (Exception ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught Exception in invoke");
            throw new IOException("RqmMethodInvoker exception(Exception)", ex);
        }
    }

    @Override
    public List<TestScript> createOrUpdate(RqmParameterList parameters, BuildListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TestScript() {
    }

    public TestScript(String rqmObjectResourceUrl) throws RQMObjectParseException {
        this();
        this.rqmObjectResourceUrl = rqmObjectResourceUrl;
    }

    @Override
    public HashMap<String, String> attributes() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.putAll(this.customAttributes);
        attr.put("testscript_title", this.scriptTitle);
        return attr;
    }

    @Override
    public TestScript initializeSingleResource(String xml) throws RQMObjectParseException {
        try {
            this.customAttributes.clear();
            Document doc = RqmObject.getDocumentReader(xml);
            NodeList list = doc.getElementsByTagName("ns6:title");
            String title = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node elem = list.item(i);
                if (elem.getNodeType() != 1) continue;
                title = ((Element)elem).getTextContent();
                this.setScriptTitle(title);
            }
            NodeList inputs = doc.getElementsByTagName("ns4:inputParameter");
            for (int i = 0; i < inputs.getLength(); ++i) {
                Node n = inputs.item(i);
                if (n.getNodeType() != 1) continue;
                Element en = (Element)n;
                String key = en.getElementsByTagName("ns4:name").item(0).getTextContent();
                String value = en.getElementsByTagName("ns4:value").item(0).getTextContent();
                log.fine("Key: " + key);
                log.fine("Value: " + value);
                this.customAttributes.put(key, value);
            }
        }
        catch (RQMObjectParseException ex) {
            throw new RQMObjectParseException(String.format("Failed to parse %s", this.getClass().getSimpleName()), ex);
        }
        catch (DOMException ex) {
            throw new RQMObjectParseException(String.format("Failed to parse %s", this.getClass().getSimpleName()), ex);
        }
        return this;
    }

    public String getDescriptor() {
        return RqmObject.getDescriptor(this, this.getScriptTitle());
    }

    @Override
    public String getResourceName() {
        if (this.isManual()) {
            return RESOURCE_RQM_MANUAL_NAME;
        }
        return RESOURCE_RQM_NONMANUAL_NAME;
    }

    public boolean isExecutionSuccess() {
        return this.executionSuccess;
    }

    public void setExecutionSuccess(boolean executionSuccess) {
        this.executionSuccess = executionSuccess;
    }

    public String toString() {
        return String.format("%s, Attributes = %s%nLink to this script: %s", this.scriptTitle, this.customAttributes, this.rqmObjectResourceUrl);
    }
}

