/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.collector;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.remoting.Future;
import hudson.tasks.BuildStep;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.RqmBuilder;
import net.praqma.jenkins.rqm.RqmCollector;
import net.praqma.jenkins.rqm.RqmCollectorDescriptor;
import net.praqma.jenkins.rqm.RqmObjectCreator;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestScript;
import net.praqma.jenkins.rqm.model.TestSuiteExecutionRecord;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RqmTestSuiteExectionRecordCollectionStrategy
extends RqmCollector {
    private static final Logger log = Logger.getLogger(RqmTestSuiteExectionRecordCollectionStrategy.class.getName());
    public final String executionRecordName;
    public final String projectName;
    private String planName;

    public RqmTestSuiteExectionRecordCollectionStrategy() {
        this("exrecor", "planname", "projname");
    }

    @DataBoundConstructor
    public RqmTestSuiteExectionRecordCollectionStrategy(String executionRecordName, String planName, String projectName) {
        this.planName = planName;
        this.executionRecordName = executionRecordName;
        this.projectName = projectName;
    }

    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    @Override
    public <T extends RqmObject> List<T> collect(BuildListener listener, AbstractBuild<?, ?> build) throws Exception {
        RqmParameterList list;
        NameValuePair[] filterProperties = TestSuiteExecutionRecord.getFilteringProperties(this.executionRecordName, this.planName);
        String request = TestSuiteExecutionRecord.getResourceFeedUrl(this.getHostName(), this.getPort(), this.getContextRoot(), this.projectName);
        listener.getLogger().println(String.format("Resource request feed is %s", request));
        if (!StringUtils.isBlank((String)this.credentialId) && !this.credentialId.equals("none")) {
            listener.getLogger().println("Using credentials");
            StandardUsernameCredentials usrName = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)this.credentialId, StandardUsernameCredentials.class, build, (List)Collections.EMPTY_LIST);
            UsernamePasswordCredentials userPasswordCreds = (UsernamePasswordCredentials)usrName;
            list = new RqmParameterList(this.getHostName(), this.getPort(), this.getContextRoot(), this.projectName, userPasswordCreds, request, filterProperties, "GET", null);
        } else {
            listener.getLogger().println("Using legacy");
            list = new RqmParameterList(this.getHostName(), this.getPort(), this.getContextRoot(), this.projectName, this.getUsrName(), this.getPasswd(), request, filterProperties, "GET", null);
        }
        RqmObjectCreator<TestSuiteExecutionRecord> object = new RqmObjectCreator<TestSuiteExecutionRecord>(TestSuiteExecutionRecord.class, list, listener);
        Future result = build.getWorkspace().actAsync(object);
        return (List)result.get(20L, TimeUnit.MINUTES);
    }

    @Override
    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, List<BuildStep> preBuildSteps, List<BuildStep> postBuildSteps, List<BuildStep> iterativeTestCaseBuilders, List<? extends RqmObject> results) throws Exception {
        int executionCounter = 0;
        int totalNumberOfScripts = 0;
        boolean success = true;
        List<? extends RqmObject> records = results;
        for (TestSuiteExecutionRecord testSuiteExecutionRecord : records) {
            for (final TestCase tc : testSuiteExecutionRecord.getAllTestCases()) {
                totalNumberOfScripts += tc.getScripts().size();
            }
        }
        listener.getLogger().println(String.format("Found %s test cases", totalNumberOfScripts));
        if (preBuildSteps != null) {
            listener.getLogger().println(String.format("Performing pre build step", new Object[0]));
            for (BuildStep buildStep : preBuildSteps) {
                success &= buildStep.perform(build, launcher, listener);
            }
        }
        for (final TestSuiteExecutionRecord testSuiteExecutionRecord : records) {
            listener.getLogger().println(String.format("Test Suite %s [%s] ", testSuiteExecutionRecord.getTestSuite().getTestSuiteTitle(), testSuiteExecutionRecord.getTestSuite().getRqmObjectResourceUrl()));
            listener.getLogger().println(String.format("Test Suite Execution Record %s [%s]", testSuiteExecutionRecord.getTestSuiteExecutionRecordTitle(), testSuiteExecutionRecord.getRqmObjectResourceUrl()));
            for (final TestCase tc : testSuiteExecutionRecord.getTestSuite().getTestcases()) {
                listener.getLogger().println(String.format(" Test Case %s(%s) [%s]", tc.getTestCaseTitle(), tc.getExecutionOrder(), tc.getRqmObjectResourceUrl()));
                if (tc.getScripts().isEmpty()) {
                    listener.getLogger().println("Test case %s does not contain any scripts, setting result to unstable");
                    build.setResult(Result.UNSTABLE);
                }
                for (final TestScript ts : tc.getScripts()) {
                    boolean tsSuccess = true;
                    listener.getLogger().println(String.format(" * Test Script %s [%s]", ts.getScriptTitle(), ts.getRqmObjectResourceUrl()));
                    for (BuildStep bstep : iterativeTestCaseBuilders) {
                        EnvironmentContributingAction envAction = new EnvironmentContributingAction(){

                            public void buildEnvVars(AbstractBuild<?, ?> ab, EnvVars ev) {
                                RqmBuilder.addToEnvironment(ev, testSuiteExecutionRecord.getTestSuite().attributes());
                                if (testSuiteExecutionRecord.getTestPlan() != null) {
                                    RqmBuilder.addToEnvironment(ev, testSuiteExecutionRecord.getTestPlan().attributes());
                                }
                                RqmBuilder.addToEnvironment(ev, tc.attributes());
                                RqmBuilder.addToEnvironment(ev, ts.attributes());
                            }

                            public String getIconFileName() {
                                return null;
                            }

                            public String getDisplayName() {
                                return null;
                            }

                            public String getUrlName() {
                                return null;
                            }
                        };
                        build.addAction((Action)envAction);
                        tsSuccess &= bstep.perform(build, launcher, listener);
                        build.getActions().remove(envAction);
                    }
                    success &= tsSuccess;
                    if (!tsSuccess) {
                        listener.getLogger().println(String.format("Non-zero exit code for test script: %s", ts.getScriptTitle()));
                        ts.setExecutionSuccess(false);
                        build.setResult(Result.FAILURE);
                        continue;
                    }
                    ++executionCounter;
                }
            }
        }
        if (postBuildSteps != null) {
            listener.getLogger().println(String.format("Performing post build step", new Object[0]));
            for (BuildStep buildStep : postBuildSteps) {
                success &= buildStep.perform(build, launcher, listener);
            }
        }
        listener.getLogger().println(String.format("Successfully executed %s out of %s test scripts", executionCounter, totalNumberOfScripts));
        if (executionCounter != totalNumberOfScripts) {
            listener.getLogger().println("Listing test cases which failed executing. Have you remembered to add the proper fields to your test scripts?");
            for (TestSuiteExecutionRecord testSuiteExecutionRecord : records) {
                for (final TestCase tc : testSuiteExecutionRecord.getAllTestCases()) {
                    for (TestScript tscript : tc.getScripts()) {
                        if (tscript.isExecutionSuccess()) continue;
                        listener.getLogger().println(tscript);
                    }
                }
            }
        }
        return true;
    }

    @Extension
    public static class RqmTestSuiteCollectionStrategyImpl
    extends RqmCollectorDescriptor {
        public String getDisplayName() {
            return "Test suite exection record selection stategy";
        }
    }
}

