/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildListener;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.praqma.jenkins.rqm.RqmCollectorDescriptor;
import net.praqma.jenkins.rqm.model.RqmObject;
import org.apache.commons.lang.StringUtils;

public abstract class RqmCollector
extends AbstractDescribableImpl<RqmCollector>
implements ExtensionPoint {
    @Deprecated
    private String passwd;
    @Deprecated
    private String usrName;
    private String hostName;
    private String contextRoot;
    private int port;
    protected String credentialId;

    public RqmCollectorDescriptor getDescriptor() {
        return (RqmCollectorDescriptor)super.getDescriptor();
    }

    public static DescriptorExtensionList<RqmCollector, RqmCollectorDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(RqmCollector.class);
    }

    public static List<RqmCollectorDescriptor> getDescriptors() {
        ArrayList<RqmCollectorDescriptor> list = new ArrayList<RqmCollectorDescriptor>();
        for (RqmCollectorDescriptor d : RqmCollector.all()) {
            list.add(d);
        }
        return list;
    }

    public abstract <T extends RqmObject> List<T> collect(BuildListener var1, AbstractBuild<?, ?> var2) throws Exception;

    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, List<BuildStep> preBuildSteps, List<BuildStep> postBuildSteps, List<BuildStep> iterativeTestCaseBuilders, List<? extends RqmObject> results) throws Exception {
        return true;
    }

    public RqmCollector withCredentials(String credentialsId) {
        this.credentialId = credentialsId;
        return this;
    }

    public void setup(String hostname, String contextRoot, String usrName, String passwd, int port) {
        this.setContextRoot(contextRoot);
        this.setPasswd(passwd);
        this.setPort(port);
        this.setUsrName(usrName);
        this.setHostName(hostname);
    }

    public boolean checkSetup() throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getPort() == 0) {
            errors.add("Port not defined in global configuration");
        }
        if (StringUtils.isBlank((String)this.getHostName())) {
            errors.add("Hostname not defined in global configuration");
        }
        if (StringUtils.isBlank((String)this.getContextRoot())) {
            errors.add("Context root not defined in global configuration");
        }
        if (!errors.isEmpty()) {
            throw new IOException(String.format("Error in configuration%n%s", errors));
        }
        return true;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @Deprecated
    public String getUsrName() {
        return this.usrName;
    }

    @Deprecated
    public void setUsrName(String usrName) {
        this.usrName = usrName;
    }

    @Deprecated
    public String getPasswd() {
        return this.passwd;
    }

    @Deprecated
    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

