/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.praqma.jenkins.rqm.RqmBuildAction;
import net.praqma.jenkins.rqm.RqmCollector;
import net.praqma.jenkins.rqm.RqmCollectorDescriptor;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RqmBuilder
extends Builder {
    private static final Logger log = Logger.getLogger(RqmBuilder.class.getName());
    public final List<BuildStep> preBuildSteps;
    public final List<BuildStep> postBuildSteps;
    public final List<BuildStep> iterativeTestCaseBuilders;
    public final RqmCollector collectionStrategy;
    private String credentialId;

    @DataBoundConstructor
    public RqmBuilder(RqmCollector collectionStrategy, List<BuildStep> iterativeTestCaseBuilders, List<BuildStep> preBuildSteps, List<BuildStep> postBuildSteps, String credentialId) {
        this.collectionStrategy = collectionStrategy;
        this.preBuildSteps = preBuildSteps;
        this.postBuildSteps = postBuildSteps;
        this.iterativeTestCaseBuilders = iterativeTestCaseBuilders;
        this.credentialId = credentialId;
        collectionStrategy.setup(this.getGlobalHostName(), this.getGlobalContextRoot(), this.getGlobalUsrName(), this.getGlobalPasswd(), this.getGlobalPort());
    }

    @Deprecated
    public RqmBuilder(RqmCollector collectionStrategy, List<BuildStep> iterativeTestCaseBuilders, List<BuildStep> preBuildSteps, List<BuildStep> postBuildSteps) {
        this.collectionStrategy = collectionStrategy;
        this.preBuildSteps = preBuildSteps;
        this.postBuildSteps = postBuildSteps;
        this.iterativeTestCaseBuilders = iterativeTestCaseBuilders;
        collectionStrategy.setup(this.getGlobalHostName(), this.getGlobalContextRoot(), this.getGlobalUsrName(), this.getGlobalPasswd(), this.getGlobalPort());
    }

    public final int getGlobalPort() {
        return ((RqmDescriptor)this.getDescriptor()).getPort();
    }

    public final String getGlobalHostName() {
        return ((RqmDescriptor)this.getDescriptor()).getHostName();
    }

    public final String getGlobalContextRoot() {
        return ((RqmDescriptor)this.getDescriptor()).getContextRoot();
    }

    public final String getGlobalUsrName() {
        return ((RqmDescriptor)this.getDescriptor()).getUsrName();
    }

    public final String getGlobalPasswd() {
        return ((RqmDescriptor)this.getDescriptor()).getPasswd();
    }

    public static void addToEnvironment(EnvVars env, HashMap<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            env.put(entry.getKey().toUpperCase(), entry.getValue().replace(" ", "_"));
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream console = listener.getLogger();
        console.println(Jenkins.getInstance().getPlugin("rqm-plugin").getWrapper().getVersion());
        boolean success = true;
        List results = null;
        try {
            console.println(String.format("Connecting to RQM server @ %s", this.getGlobalHostName()));
            console.println(String.format("Using port %s", this.getGlobalPort()));
            console.println(String.format("Context root is '%s'", this.getGlobalContextRoot()));
            this.collectionStrategy.setup(this.getGlobalHostName(), this.getGlobalContextRoot(), this.getGlobalUsrName(), this.getGlobalPasswd(), this.getGlobalPort());
            results = this.collectionStrategy.withCredentials(this.credentialId).collect(listener, build);
            success = this.collectionStrategy.withCredentials(this.credentialId).execute(build, listener, launcher, this.preBuildSteps, this.postBuildSteps, this.iterativeTestCaseBuilders, results);
        }
        catch (TimeoutException ex) {
            console.println(String.format("Unable to complete retrieval of RQM data, timeout exceeded", new Object[0]));
            log.logp(Level.SEVERE, ((Object)((Object)this)).getClass().getName(), "perform", "Timeout", ex);
            success = false;
            throw new AbortException("Unable to complete retrieval of RQM data, timeout exceeded. Trace written to log.");
        }
        catch (Exception ex) {
            success = false;
            console.println(String.format("Failed to retrieve relevant test data.%n%s", ex.getMessage()));
            log.logp(Level.SEVERE, ((Object)((Object)this)).getClass().getName(), "perform", "Failed to retrieve relavant test data", ex);
            throw new AbortException("Error in retrieving data from RQM, trace written to log");
        }
        finally {
            RqmBuildAction action = new RqmBuildAction(results);
            action.setIndex(build.getActions(RqmBuildAction.class).size() + 1);
            build.addAction((Action)action);
        }
        return success;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    @Extension
    public static class RqmDescriptor
    extends BuildStepDescriptor<Builder> {
        private String contextRoot;
        private String hostName;
        private String usrName;
        private String passwd;
        private int port;

        public RqmDescriptor() {
            super(RqmBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public List<Descriptor<? extends BuildStep>> getApplicableBuildSteps(AbstractProject<?, ?> p) {
            ArrayList<Descriptor<? extends BuildStep>> list = new ArrayList<Descriptor<? extends BuildStep>>();
            list.addAll((Collection<Descriptor<? extends BuildStep>>)Builder.all());
            return list;
        }

        public List<RqmCollectorDescriptor> getCollectionStrategies() {
            ArrayList<RqmCollectorDescriptor> descriptors = new ArrayList<RqmCollectorDescriptor>();
            descriptors.addAll(RqmCollector.getDescriptors());
            return descriptors;
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, context, (Authentication)ACL.SYSTEM);
            StandardListBoxModel model2 = (StandardListBoxModel)new StandardListBoxModel().withEmptySelection().withMatching(new CredentialsMatcher(){

                public boolean matches(Credentials item) {
                    return item instanceof UsernamePasswordCredentials;
                }
            }, (Iterable)credentials);
            return model2;
        }

        public String getDisplayName() {
            return "RQM TestScript Iterator";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.contextRoot = json.getString("contextRoot");
            this.usrName = json.getString("usrName");
            this.hostName = json.getString("hostName");
            this.passwd = json.getString("passwd");
            this.port = json.getInt("port");
            this.save();
            return super.configure(req, json);
        }

        public String getContextRoot() {
            return this.contextRoot;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getUsrName() {
            return this.usrName;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public int getPort() {
            return this.port;
        }
    }
}

