/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.scm;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.clearcase.exceptions.DeliverException;
import net.praqma.clearcase.exceptions.UnableToInitializeEntityException;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Component;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.UCMEntity;
import net.praqma.hudson.CCUCMBuildAction;
import net.praqma.hudson.Config;
import net.praqma.hudson.Util;
import net.praqma.hudson.exception.CCUCMException;
import net.praqma.hudson.exception.DeliverNotCancelledException;
import net.praqma.hudson.exception.TemplateException;
import net.praqma.hudson.nametemplates.NameTemplate;
import net.praqma.hudson.notifier.CCUCMNotifier;
import net.praqma.hudson.remoting.CheckoutTask;
import net.praqma.hudson.remoting.EstablishResult;
import net.praqma.hudson.remoting.RemoteClearCaseCheck;
import net.praqma.hudson.remoting.RemoteDeliver;
import net.praqma.hudson.remoting.RemoteUtil;
import net.praqma.hudson.scm.ChangeLogParserImpl;
import net.praqma.hudson.scm.Polling;
import net.praqma.hudson.scm.SCMRevisionStateImpl;
import net.praqma.hudson.scm.Unstable;
import net.praqma.util.execute.AbnormalProcessTerminationException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class CCUCMScm
extends SCM {
    private static Logger logger = Logger.getLogger(CCUCMScm.class.getName());
    private Boolean multisitePolling;
    private Project.PromotionLevel plevel;
    private String loadModule;
    private String component;
    private String stream;
    private String bl;
    private StringBuffer pollMsgs = new StringBuffer();
    private Stream integrationstream;
    private String buildProject;
    private String jobName = "";
    private Integer jobNumber;
    private String id = "";
    private boolean forceDeliver;
    private boolean removeViewPrivateFiles;
    private boolean trimmedChangeSet;
    private boolean recommend;
    private boolean makeTag;
    private boolean setDescription;
    private Unstable treatUnstable;
    private boolean createBaseline;
    private String nameTemplate;
    private Polling polling;
    private String viewtag = "";
    private Baseline lastBaseline;
    private String levelToPoll;
    private boolean addPostBuild = true;
    private static DateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");

    public CCUCMScm() {
    }

    public CCUCMScm(String component, String levelToPoll, String loadModule, boolean newest, String polling, String stream, String treatUnstable, boolean createBaseline, String nameTemplate, boolean forceDeliver, boolean recommend, boolean makeTag, boolean setDescription, String buildProject) {
        this(component, levelToPoll, loadModule, newest, polling, stream, treatUnstable, createBaseline, nameTemplate, forceDeliver, recommend, makeTag, setDescription, buildProject, true, false);
    }

    @DataBoundConstructor
    public CCUCMScm(String component, String levelToPoll, String loadModule, boolean newest, String polling, String stream, String treatUnstable, boolean createBaseline, String nameTemplate, boolean forceDeliver, boolean recommend, boolean makeTag, boolean setDescription, String buildProject, boolean removeViewPrivateFiles, boolean trimmedChangeSet) {
        this.component = component;
        this.loadModule = loadModule;
        this.stream = stream;
        this.buildProject = buildProject;
        this.polling = new Polling(polling);
        this.treatUnstable = new Unstable(treatUnstable);
        this.createBaseline = createBaseline;
        this.nameTemplate = nameTemplate;
        this.forceDeliver = forceDeliver;
        this.removeViewPrivateFiles = removeViewPrivateFiles;
        this.trimmedChangeSet = trimmedChangeSet;
        this.recommend = recommend;
        this.makeTag = makeTag;
        this.setDescription = setDescription;
        this.plevel = Util.getLevel(levelToPoll);
        this.levelToPoll = levelToPoll;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        this.jobName = ((AbstractProject)build.getParent()).getDisplayName().replace(' ', '_');
        this.jobNumber = build.getNumber();
        this.id = "[" + this.jobName + "::" + this.jobNumber + "]";
        PrintStream out = listener.getLogger();
        String version = Hudson.getInstance().getPlugin("clearcase-ucm-plugin").getWrapper().getVersion();
        out.println("[" + Config.nameShort + "] ClearCase UCM Plugin version " + version);
        out.println("[" + Config.nameShort + "] Allow for slave polling: " + this.getSlavePolling());
        out.println("[" + Config.nameShort + "] Poll for posted deliveries: " + this.getMultisitePolling());
        out.println("[" + Config.nameShort + "] Forcing deliver: " + this.forceDeliver);
        logger.info(this.id + "ClearCase UCM plugin v. " + version);
        try {
            workspace.act((Callable)new RemoteClearCaseCheck());
        }
        catch (AbnormalProcessTerminationException e) {
            build.setDescription(e.getMessage());
            throw e;
        }
        CCUCMBuildAction action = null;
        try {
            action = this.getBuildAction();
        }
        catch (UnableToInitializeEntityException e) {
            Util.println(out, (Object)e);
            throw new AbortException(e.getMessage());
        }
        action.setBuild(build);
        build.addAction((Action)action);
        action.setListener((TaskListener)listener);
        String baselineInput = this.getBaselineValue(build);
        this.ensurePublisher(build);
        if (build.getBuildVariables().get(baselineInput) != null) {
            logger.fine("Baseline parameter: " + baselineInput);
            action.setPolling(new Polling(Polling.PollingType.none));
            this.polling = action.getPolling();
            try {
                this.resolveBaselineInput(build, baselineInput, action, listener);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Resolving baseline input failed", e);
                Util.println(out, "No Baselines found");
            }
        } else {
            out.println("[" + Config.nameShort + "] Polling streams: " + this.polling.toString());
            try {
                this.resolveBaseline(workspace, build.getProject(), action, listener);
            }
            catch (CCUCMException e) {
                logger.warning(e.getMessage());
                if (this.plevel == null) {
                    logger.fine("Promotion level was null [=ANY], finding the last built baseline");
                    CCUCMBuildAction last = CCUCMScm.getLastAction(build.getProject());
                    if (action != null) {
                        action.setBaseline(last.getBaseline());
                    }
                    build.setDescription("No valid baselines found");
                    throw new AbortException("No valid baselines found");
                }
                build.setDescription("No valid baselines found");
                throw new AbortException("No valid baselines found");
            }
            catch (IOException e) {
                Exception cause = (Exception)e.getCause();
                if (cause != null) {
                    action.setResolveBaselineException(cause);
                    build.setDescription(cause.getMessage());
                    throw new AbortException(cause.getMessage());
                }
                throw new AbortException("Unable to list baselines");
            }
        }
        build.save();
        boolean result = true;
        if (action.getBaseline() != null) {
            out.println("[" + Config.nameShort + "] Using " + action.getBaseline().getNormalizedName());
            if (this.polling.isPollingSelf() || !this.polling.isPolling()) {
                logger.fine("Initializing workspace");
                result = this.initializeWorkspace(build, workspace, changelogFile, listener, action);
            } else {
                logger.fine("Deliver");
                result = this.beginDeliver(build, action, listener, changelogFile);
            }
            action.setViewTag(this.viewtag);
        }
        out.println("[" + Config.nameShort + "] Pre build steps done");
        this.addPostBuild = true;
        if (action.getBaseline() == null) {
            out.println("[" + Config.nameShort + "] Finished processing, no baseline found");
        } else {
            out.println("[" + Config.nameShort + "] Finished processing " + action.getBaseline());
        }
        return result;
    }

    public void ensurePublisher(AbstractBuild build) throws IOException {
        Describable describable = build.getProject().getPublishersList().get(CCUCMNotifier.class);
        if (describable == null) {
            logger.info("Adding notifier to project");
            build.getProject().getPublishersList().add((Object)new CCUCMNotifier());
        }
    }

    public void setAddPostBuild(boolean addPostBuild) {
        this.addPostBuild = addPostBuild;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkInput(TaskListener listener) {
        PrintStream out = listener.getLogger();
        out.println("[" + Config.nameShort + "] Verifying input");
        if (this.createBaseline) {
            if (this.polling.isPollingOther()) {
                if (this.nameTemplate != null && this.nameTemplate.length() > 0) {
                    if (this.nameTemplate.matches("^\".+\"$")) {
                        this.nameTemplate = this.nameTemplate.substring(1, this.nameTemplate.length() - 1);
                    }
                    try {
                        NameTemplate.testTemplate(this.nameTemplate);
                    }
                    catch (TemplateException e) {
                        out.println("[" + Config.nameShort + "] The template could not be parsed correctly: " + e.getMessage());
                        return false;
                    }
                } else {
                    out.println("[" + Config.nameShort + "] A valid template must be provided to create a Baseline");
                    return false;
                }
            }
            out.println("[" + Config.nameShort + "] You cannot create a baseline in this mode");
        }
        if (this.plevel != null) {
            return true;
        }
        if (this.polling.isPollingSelf()) {
            return true;
        }
        out.println("[" + Config.nameShort + "] You cannot poll any on other than self");
        return false;
    }

    private boolean initializeWorkspace(AbstractBuild<?, ?> build, FilePath workspace, File changelogFile, BuildListener listener, CCUCMBuildAction action) throws IOException, InterruptedException {
        PrintStream consoleOutput = listener.getLogger();
        EstablishResult er = null;
        CheckoutTask ct = new CheckoutTask(listener, this.jobName, build.getNumber(), action.getStream(), this.loadModule, action.getBaseline(), this.buildProject, this.plevel == null, action.doRemoveViewPrivateFiles());
        er = (EstablishResult)workspace.act((FilePath.FileCallable)ct);
        String changelog = "";
        changelog = Util.createChangelog(er.getActivities(), action.getBaseline(), this.trimmedChangeSet);
        action.setActivities(er.getActivities());
        this.viewtag = er.getViewtag();
        try {
            FileOutputStream fos = new FileOutputStream(changelogFile);
            fos.write(changelog.getBytes());
            fos.close();
        }
        catch (IOException e) {
            logger.fine(this.id + "Could not write change log file");
            consoleOutput.println("[" + Config.nameShort + "] Could not write change log file");
        }
        return true;
    }

    public void resolveBaselineInput(AbstractBuild<?, ?> build, String baselineInput, CCUCMBuildAction action, BuildListener listener) throws UnableToInitializeEntityException, IOException, InterruptedException {
        PrintStream consoleOutput = listener.getLogger();
        String baselinename = (String)build.getBuildVariables().get(baselineInput);
        action.setBaseline(Baseline.get((String)baselinename));
        action.setBaseline((Baseline)RemoteUtil.loadEntity(build.getWorkspace(), (UCMEntity)action.getBaseline(), true));
        action.setStream(action.getBaseline().getStream());
        consoleOutput.println("[" + Config.nameShort + "] Starting parameterized build with a Baseline.");
        action.setComponent(action.getBaseline().getComponent());
        action.setStream(action.getBaseline().getStream());
    }

    public String getBaselineValue(AbstractBuild<?, ?> build) {
        Set c = build.getBuildVariables().keySet();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String next = i.next().toString();
            if (!next.equalsIgnoreCase("baseline")) continue;
            return next;
        }
        return null;
    }

    private void resolveBaseline(FilePath workspace, AbstractProject<?, ?> project, CCUCMBuildAction action, BuildListener listener) throws IOException, InterruptedException, CCUCMException {
        CCUCMBuildAction lastAction;
        logger.fine("Resolving Baseline from the Stream " + action.getStream().getNormalizedName());
        PrintStream out = listener.getLogger();
        this.printParameters(out);
        action.setStream((Stream)RemoteUtil.loadEntity(workspace, (UCMEntity)action.getStream(), this.getSlavePolling()));
        List<Baseline> baselines = null;
        Date date = null;
        if (this.plevel == null && (lastAction = CCUCMScm.getLastAction(project)) != null) {
            date = lastAction.getBaseline().getDate();
        }
        if ((baselines = this.polling.isPollingSelf() ? this.getValidBaselinesFromStream(workspace, this.plevel, action.getStream(), action.getComponent(), date) : this.getBaselinesFromStreams(workspace, (TaskListener)listener, out, action.getStream(), action.getComponent(), this.polling.isPollingChilds(), date)).size() < 1) {
            throw new CCUCMException("No valid Baselines found");
        }
        action.setBaseline(this.selectBaseline(baselines, this.plevel));
        if (baselines == null || baselines.size() < 1) {
            throw new CCUCMException("Unable to get Baselines");
        }
        this.printBaselines(baselines, out);
        out.println("");
    }

    public boolean beginDeliver(AbstractBuild<?, ?> build, CCUCMBuildAction state, BuildListener listener, File changelogFile) {
        FilePath workspace = build.getWorkspace();
        PrintStream consoleOutput = listener.getLogger();
        boolean result = true;
        EstablishResult er = new EstablishResult();
        try {
            logger.config("Starting remote deliver");
            RemoteDeliver rmDeliver = new RemoteDeliver(state.getStream().getFullyQualifiedName(), listener, this.loadModule, state.getBaseline().getFullyQualifiedName(), ((AbstractProject)build.getParent()).getDisplayName(), state.doForceDeliver(), state.doRemoveViewPrivateFiles());
            er = (EstablishResult)workspace.act((FilePath.FileCallable)rmDeliver);
            CCUCMBuildAction action = (CCUCMBuildAction)build.getAction(CCUCMBuildAction.class);
            action.setViewPath(er.getView().getViewRoot());
            action.setViewTag(er.getViewtag());
            this.viewtag = er.getViewtag();
            String changelog = "";
            changelog = Util.createChangelog(er.getActivities(), action.getBaseline(), this.trimmedChangeSet);
            action.setActivities(er.getActivities());
            try {
                FileOutputStream fos = new FileOutputStream(changelogFile);
                fos.write(changelog.getBytes());
                fos.close();
            }
            catch (IOException e) {
                logger.fine(this.id + "Could not write change log file");
                consoleOutput.println("[" + Config.nameShort + "] Could not write change log file");
            }
            consoleOutput.println("[" + Config.nameShort + "] Deliver successful");
        }
        catch (Exception e) {
            consoleOutput.println("[" + Config.nameShort + "] Deliver failed");
            result = false;
            Exception cause = (Exception)net.praqma.util.ExceptionUtils.unpackFrom(IOException.class, (Throwable)e);
            consoleOutput.println("[" + Config.nameShort + "] Cause: " + cause.getClass());
            try {
                logger.log(Level.WARNING, "", cause);
                throw cause;
            }
            catch (DeliverException de) {
                consoleOutput.println("[" + Config.nameShort + "] " + de.getType());
                state.setViewPath(de.getDeliver().getViewContext());
                state.setViewTag(de.getDeliver().getViewtag());
                if (de.isStarted()) {
                    try {
                        consoleOutput.print("[" + Config.nameShort + "] Cancelling deliver. ");
                        RemoteUtil.completeRemoteDeliver(workspace, listener, state.getBaseline(), state.getStream(), de.getDeliver().getViewtag(), de.getDeliver().getViewContext(), false);
                        consoleOutput.println("Success");
                        state.setNeedsToBeCompleted(false);
                    }
                    catch (Exception ex) {
                        consoleOutput.println("[" + Config.nameShort + "] Failed to cancel deliver");
                        consoleOutput.println(ExceptionUtils.getFullStackTrace((Throwable)e));
                        logger.warning(ExceptionUtils.getFullStackTrace((Throwable)e));
                    }
                } else {
                    logger.fine(this.id + "No need for completing deliver");
                    state.setNeedsToBeCompleted(false);
                }
                if (de.getType().equals((Object)DeliverException.Type.MERGE_ERROR)) {
                    consoleOutput.println("[" + Config.nameShort + "] Changes need to be manually merged, The stream " + state.getBaseline().getStream().getShortname() + " must be rebased to the most recent baseline on " + state.getStream().getShortname() + " - During the rebase the merge conflict should be solved manually. Hereafter create a new baseline on " + state.getBaseline().getStream().getShortname() + ".");
                    state.setError("merge error");
                }
            }
            catch (DeliverNotCancelledException e1) {
                consoleOutput.println("[" + Config.nameShort + "] Failed to force cancel existing deliver");
                state.setNeedsToBeCompleted(false);
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "", e);
                e.printStackTrace(consoleOutput);
            }
        }
        return result;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeLogParserImpl();
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        String CC_BASELINE = "";
        String CC_VIEWPATH = "";
        String CC_VIEWTAG = "";
        try {
            CCUCMBuildAction action = (CCUCMBuildAction)build.getAction(CCUCMBuildAction.class);
            CC_BASELINE = action.getBaseline().getFullyQualifiedName();
        }
        catch (Exception e1) {
            System.out.println("Failed to get baseline: " + e1.getMessage());
        }
        CC_VIEWTAG = this.viewtag;
        String workspace = env.get("WORKSPACE");
        CC_VIEWPATH = workspace != null ? workspace + File.separator + "view" : "";
        env.put("CC_BASELINE", CC_BASELINE);
        env.put("CC_VIEWTAG", CC_VIEWTAG);
        env.put("CC_VIEWPATH", CC_VIEWPATH);
    }

    public PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState rstate) throws IOException, InterruptedException {
        workspace.act((Callable)new RemoteClearCaseCheck());
        this.jobName = project.getDisplayName().replace(' ', '_');
        this.jobNumber = project.getNextBuildNumber();
        this.id = "[" + this.jobName + "::" + this.jobNumber + "]";
        PollingResult p = PollingResult.NO_CHANGES;
        if (this.getMultisitePolling()) {
            if (project.isBuilding()) {
                logger.info("A build already building - cancelling poll");
                return PollingResult.NO_CHANGES;
            }
        } else if (project.isInQueue()) {
            logger.fine("A build already in queue - cancelling poll");
            return PollingResult.NO_CHANGES;
        }
        logger.fine("Need for polling");
        PrintStream out = listener.getLogger();
        Stream stream = null;
        Component component = null;
        try {
            stream = Stream.get((String)this.stream);
            component = Component.get((String)this.component);
        }
        catch (UnableToInitializeEntityException e) {
            Util.println(out, (Object)e);
            throw new AbortException("Unable initialize ClearCase entities");
        }
        logger.fine("Let's go!");
        if (this.checkInput(listener)) {
            CCUCMBuildAction lastAction;
            this.printParameters(out);
            List<Baseline> baselines = null;
            Date date = null;
            if (this.plevel == null && (lastAction = CCUCMScm.getLastAction(project)) != null) {
                date = lastAction.getBaseline().getDate();
            }
            if ((baselines = this.polling.isPollingSelf() ? this.getValidBaselinesFromStream(workspace, this.plevel, stream, component, date) : this.getBaselinesFromStreams(workspace, listener, out, stream, component, this.polling.isPollingChilds(), date)).size() > 0) {
                p = PollingResult.BUILD_NOW;
            }
        }
        return p;
    }

    private List<Baseline> getBaselinesFromStreams(FilePath workspace, TaskListener listener, PrintStream consoleOutput, Stream stream, Component component, boolean pollingChildStreams, Date date) {
        List<Stream> streams = null;
        ArrayList<Baseline> baselines = new ArrayList<Baseline>();
        try {
            streams = RemoteUtil.getRelatedStreams(workspace, listener, stream, pollingChildStreams, this.getSlavePolling(), this.getMultisitePolling());
        }
        catch (Exception e1) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e1);
            logger.log(Level.WARNING, "Could not get related streams from " + stream, root);
            consoleOutput.println("[" + Config.nameShort + "] No streams found");
            return baselines;
        }
        consoleOutput.println("[" + Config.nameShort + "] Scanning " + streams.size() + " stream" + (streams.size() == 1 ? "" : "s") + " for baselines.");
        int c = 1;
        for (Stream s : streams) {
            try {
                consoleOutput.printf("[" + Config.nameShort + "] [%02d] %s ", c, s.getShortname());
                ++c;
                List<Baseline> found = RemoteUtil.getRemoteBaselinesFromStream(workspace, component, s, this.plevel, this.getSlavePolling(), this.getMultisitePolling(), date);
                for (Baseline b : found) {
                    baselines.add(b);
                }
                consoleOutput.println(found.size() + " baseline" + (found.size() == 1 ? "" : "s") + " found");
            }
            catch (Exception e) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)e);
                logger.log(Level.WARNING, "Could not get baselines from " + s, root);
                consoleOutput.println("No baselines: " + root.getMessage());
            }
        }
        consoleOutput.println("");
        return baselines;
    }

    private List<Baseline> getValidBaselinesFromStream(FilePath workspace, Project.PromotionLevel plevel, Stream stream, Component component, Date date) throws IOException, InterruptedException {
        logger.fine(this.id + "Retrieving valid baselines.");
        ArrayList<Baseline> baselines = new ArrayList();
        baselines = RemoteUtil.getRemoteBaselinesFromStream(workspace, component, stream, plevel, this.getSlavePolling(), this.getMultisitePolling(), date);
        return baselines;
    }

    public static CCUCMBuildAction getLastAction(AbstractProject<?, ?> project) {
        for (AbstractBuild b = (AbstractBuild)project.getLastBuild(); b != null; b = (AbstractBuild)b.getPreviousBuild()) {
            CCUCMBuildAction action = (CCUCMBuildAction)b.getAction(CCUCMBuildAction.class);
            if (action == null || action.getBaseline() == null) continue;
            return action;
        }
        return null;
    }

    private CCUCMBuildAction getBuildAction() throws UnableToInitializeEntityException {
        CCUCMBuildAction action = new CCUCMBuildAction(Stream.get((String)this.stream), Component.get((String)this.component));
        action.setDescription(this.setDescription);
        action.setMakeTag(this.makeTag);
        action.setRecommend(this.recommend);
        action.setForceDeliver(this.forceDeliver);
        action.setPromotionLevel(this.plevel);
        action.setUnstable(this.treatUnstable);
        action.setLoadModule(this.loadModule);
        action.setRemoveViewPrivateFiles(this.removeViewPrivateFiles);
        action.setTrimmedChangeSet(this.trimmedChangeSet);
        action.setCreateBaseline(this.createBaseline);
        if (this.nameTemplate.matches("^\".+\"$")) {
            this.nameTemplate = this.nameTemplate.substring(1, this.nameTemplate.length() - 1);
        }
        action.setNameTemplate(this.nameTemplate);
        action.setPolling(this.polling);
        return action;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        SCMRevisionStateImpl scmRS = null;
        if (this.bl != null) {
            scmRS = new SCMRevisionStateImpl();
        }
        return scmRS;
    }

    private Baseline selectBaseline(List<Baseline> baselines, Project.PromotionLevel plevel) {
        if (baselines.size() > 0) {
            if (plevel != null) {
                return baselines.get(0);
            }
            return baselines.get(baselines.size() - 1);
        }
        return null;
    }

    private void printParameters(PrintStream ps) {
        ps.println("[" + Config.nameShort + "] Getting baselines for :");
        ps.println("[" + Config.nameShort + "] * Stream:          " + this.stream);
        ps.println("[" + Config.nameShort + "] * Component:       " + this.component);
        if (this.plevel == null) {
            ps.println("[" + Config.nameShort + "] * Promotion level: " + "ANY");
        } else {
            ps.println("[" + Config.nameShort + "] * Promotion level: " + this.plevel);
        }
        ps.println("");
    }

    public void printBaselines(List<Baseline> baselines, PrintStream ps) {
        if (baselines != null) {
            ps.println("[" + Config.nameShort + "] Retrieved " + baselines.size() + " baseline" + (baselines.size() == 1 ? "" : "s") + ":");
            if (baselines.size() <= 8) {
                for (Baseline b : baselines) {
                    ps.println("[" + Config.nameShort + "] + " + b.getShortname() + "(" + b.getDate() + ")");
                }
            } else {
                int i = baselines.size();
                ps.println("[" + Config.nameShort + "] + " + baselines.get(0).getShortname() + "(" + baselines.get(0).getDate() + ")");
                ps.println("[" + Config.nameShort + "] + " + baselines.get(1).getShortname() + "(" + baselines.get(1).getDate() + ")");
                ps.println("[" + Config.nameShort + "] + " + baselines.get(2).getShortname() + "(" + baselines.get(2).getDate() + ")");
                ps.println("[" + Config.nameShort + "]   ...");
                ps.println("[" + Config.nameShort + "] + " + baselines.get(i - 3).getShortname() + "(" + baselines.get(i - 3).getDate() + ")");
                ps.println("[" + Config.nameShort + "] + " + baselines.get(i - 2).getShortname() + "(" + baselines.get(i - 2).getDate() + ")");
                ps.println("[" + Config.nameShort + "] + " + baselines.get(i - 1).getShortname() + "(" + baselines.get(i - 1).getDate() + ")");
            }
        }
    }

    public String getLevelToPoll() {
        return this.levelToPoll;
    }

    public String getComponent() {
        return this.component;
    }

    public String getStream() {
        return this.stream;
    }

    public String getLoadModule() {
        return this.loadModule;
    }

    public Stream getStreamObject() {
        return this.integrationstream;
    }

    @Exported
    public String getBaseline() {
        return this.bl;
    }

    public boolean getSlavePolling() {
        CCUCMScmDescriptor desc = (CCUCMScmDescriptor)this.getDescriptor();
        return desc.getSlavePolling();
    }

    public boolean getMultisitePolling() {
        if (this.multisitePolling != null) {
            return this.multisitePolling;
        }
        CCUCMScmDescriptor desc = (CCUCMScmDescriptor)this.getDescriptor();
        return desc.getMultisitePolling();
    }

    @Exported
    public String getPolling() {
        return this.polling.toString();
    }

    @Exported
    public String getTreatUnstable() {
        return this.treatUnstable.toString();
    }

    public String getBuildProject() {
        return this.buildProject;
    }

    public boolean getForceDeliver() {
        return this.forceDeliver;
    }

    public boolean isTrimmedChangeSet() {
        return this.trimmedChangeSet;
    }

    public boolean isRemoveViewPrivateFiles() {
        return this.removeViewPrivateFiles;
    }

    public boolean isCreateBaseline() {
        return this.createBaseline;
    }

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    public boolean isMakeTag() {
        return this.makeTag;
    }

    public boolean isSetDescription() {
        return this.setDescription;
    }

    public boolean isRecommend() {
        return this.recommend;
    }

    public void setMultisitePolling(boolean mp) {
        this.multisitePolling = mp;
    }

    @Extension
    public static class CCUCMScmDescriptor
    extends SCMDescriptor<CCUCMScm>
    implements ModelObject {
        private boolean slavePolling;
        private boolean multisitePolling;
        private List<String> loadModules = this.getLoadModules();

        public CCUCMScmDescriptor() {
            super(CCUCMScm.class, null);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                String s = json.getString("slavePolling");
                if (s != null) {
                    this.slavePolling = Boolean.parseBoolean(s);
                }
                if ((s = json.getString("multisitePolling")) != null) {
                    this.multisitePolling = Boolean.parseBoolean(s);
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
            this.save();
            return true;
        }

        public boolean getSlavePolling() {
            return this.slavePolling;
        }

        public boolean getMultisitePolling() {
            return this.multisitePolling;
        }

        public String getDisplayName() {
            return "ClearCase UCM";
        }

        public FormValidation doExecutableCheck(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws FormValidation {
            try {
                NameTemplate.testTemplate(NameTemplate.trim(value));
                return FormValidation.ok((String)"The template seems ok");
            }
            catch (TemplateException e) {
                throw FormValidation.error((String)("Does not appear to be a valid template: " + e.getMessage()));
            }
        }

        public void doLevelCheck(@QueryParameter String polling, @QueryParameter String level) throws FormValidation {
            System.out.println("LEVEL CHECK: " + polling + " + " + level);
            if (level.equalsIgnoreCase("any") && !polling.equals("self")) {
                throw FormValidation.error((String)"You can only combine self and any");
            }
        }

        public CCUCMScm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                String polling = formData.getString("polling");
                String level = formData.getString("levelToPoll");
                if (level.equalsIgnoreCase("any") && !polling.equalsIgnoreCase("self")) {
                    throw new Descriptor.FormException("You can only use any with self polling", "polling");
                }
            }
            catch (JSONException e) {
                throw new Descriptor.FormException("You missed some fields: " + e.getMessage(), "CCUCM.polling");
            }
            CCUCMScm instance = (CCUCMScm)((Object)req.bindJSON(CCUCMScm.class, formData));
            return instance;
        }

        public List<String> getLevels() {
            return Config.getLevels();
        }

        public List<String> getLoadModules() {
            this.loadModules = new ArrayList<String>();
            this.loadModules.add("All");
            this.loadModules.add("Modifiable");
            return this.loadModules;
        }

        public FormValidation doCheckMode(@QueryParameter String mode, @QueryParameter String checked) throws IOException {
            boolean isChecked = checked.equalsIgnoreCase("true");
            if (isChecked) {
                if (mode.equals("self")) {
                    return FormValidation.warning((String)"You cannot create a baseline in self mode!");
                }
                return FormValidation.ok();
            }
            return FormValidation.ok();
        }
    }
}

