/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.remoting;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Component;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.UCMEntity;
import net.praqma.hudson.exception.CCUCMException;
import net.praqma.hudson.remoting.CreateRemoteBaseline;
import net.praqma.hudson.remoting.EndView;
import net.praqma.hudson.remoting.GetClearCaseVersion;
import net.praqma.hudson.remoting.GetRelatedStreams;
import net.praqma.hudson.remoting.GetRemoteBaselineFromStream;
import net.praqma.hudson.remoting.LoadEntity;
import net.praqma.hudson.remoting.RemoteDeliverComplete;

public abstract class RemoteUtil {
    private static final Logger logger = Logger.getLogger(RemoteUtil.class.getName());

    private RemoteUtil() {
    }

    public static void completeRemoteDeliver(FilePath workspace, BuildListener listener, Baseline baseline, Stream stream, String viewtag, File viewPath, boolean complete) throws CCUCMException {
        try {
            workspace.act((FilePath.FileCallable)new RemoteDeliverComplete(baseline, stream, viewtag, viewPath, complete, listener));
        }
        catch (Exception e) {
            logger.warning(String.format("Caught exception in RemoteUtil: %s", e));
            throw new CCUCMException("Failed to " + (complete ? "complete" : "cancel") + " the deliver", e);
        }
    }

    public static Baseline createRemoteBaseline(FilePath workspace, BuildListener listener, String baseName, Component component, File view, String username) throws IOException, InterruptedException {
        return (Baseline)workspace.act((FilePath.FileCallable)new CreateRemoteBaseline(baseName, component, view, username, listener));
    }

    public static UCMEntity loadEntity(FilePath workspace, UCMEntity entity, boolean slavePolling) throws IOException, InterruptedException {
        if (slavePolling) {
            return (UCMEntity)workspace.act((FilePath.FileCallable)new LoadEntity(entity));
        }
        LoadEntity t = new LoadEntity(entity);
        return t.invoke(null, null);
    }

    public static String getClearCaseVersion(FilePath workspace, Project project) throws IOException, InterruptedException {
        return (String)workspace.act((FilePath.FileCallable)new GetClearCaseVersion(project));
    }

    public static void endView(FilePath workspace, String viewtag) throws IOException, InterruptedException {
        workspace.act((FilePath.FileCallable)new EndView(viewtag));
    }

    public static List<Stream> getRelatedStreams(FilePath workspace, TaskListener listener, Stream stream, boolean pollingChildStreams, boolean slavePolling, boolean multisitePolling) throws IOException, InterruptedException {
        if (slavePolling) {
            return (List)workspace.act((FilePath.FileCallable)new GetRelatedStreams(listener, stream, pollingChildStreams, multisitePolling));
        }
        GetRelatedStreams t = new GetRelatedStreams(listener, stream, pollingChildStreams, multisitePolling);
        return t.invoke(null, null);
    }

    public static List<Baseline> getRemoteBaselinesFromStream(FilePath workspace, Component component, Stream stream, Project.PromotionLevel plevel, boolean slavePolling, boolean multisitePolling, Date date) throws IOException, InterruptedException {
        if (slavePolling) {
            return (List)workspace.act((FilePath.FileCallable)new GetRemoteBaselineFromStream(component, stream, plevel, multisitePolling, date));
        }
        GetRemoteBaselineFromStream t = new GetRemoteBaselineFromStream(component, stream, plevel, multisitePolling, date);
        return t.invoke(null, null);
    }
}

