/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.remoting;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Logger;
import net.praqma.clearcase.ucm.entities.Component;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.utils.BaselineFilter;
import net.praqma.clearcase.ucm.utils.BaselineList;
import net.praqma.clearcase.ucm.utils.filters.AfterDate;
import net.praqma.clearcase.ucm.utils.filters.NoDeliver;

public class GetRemoteBaselineFromStream
implements FilePath.FileCallable<BaselineList> {
    private static final long serialVersionUID = -8984877325832486334L;
    private static final Logger logger = Logger.getLogger(GetRemoteBaselineFromStream.class.getName());
    private Component component;
    private Stream stream;
    private Project.PromotionLevel plevel;
    private boolean multisitePolling;
    private Date date;

    public GetRemoteBaselineFromStream(Component component, Stream stream, Project.PromotionLevel plevel, boolean multisitePolling, Date date) {
        this.component = component;
        this.stream = stream;
        this.plevel = plevel;
        this.multisitePolling = multisitePolling;
        this.date = date;
    }

    public BaselineList invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        logger.fine("Retrieving remote baselines from " + this.stream.getShortname());
        BaselineList baselines = null;
        baselines = new BaselineList(this.stream, this.component, this.plevel, this.multisitePolling).setSorting((Comparator)new BaselineList.AscendingDateSort()).addFilter((BaselineFilter)new NoDeliver()).load();
        if (this.date != null) {
            logger.fine("Adding AfterDate filter");
            baselines.addFilter((BaselineFilter)new AfterDate(this.date));
        }
        try {
            logger.fine("Applying baselines");
            baselines.apply();
            logger.fine("Loaded BaselineList");
            logger.fine(String.format("Loaded BaselineList contains %s elements", baselines.size()));
        }
        catch (Exception e) {
            logger.warning(String.format("Caught exception in GetRemoteBaselineFromStream: %s", e));
            throw new IOException("Unable get list of Baselines", e);
        }
        return baselines;
    }
}

