/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.remoting;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.praqma.clearcase.PVob;
import net.praqma.clearcase.Rebase;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.exceptions.RebaseException;
import net.praqma.clearcase.interfaces.Diffable;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.Version;
import net.praqma.clearcase.ucm.utils.BaselineFilter;
import net.praqma.clearcase.ucm.utils.BaselineList;
import net.praqma.clearcase.ucm.utils.filters.BeforeBaseline;
import net.praqma.clearcase.ucm.view.SnapshotView;
import net.praqma.clearcase.ucm.view.UCMView;
import net.praqma.clearcase.util.ExceptionUtils;
import net.praqma.hudson.Config;
import net.praqma.hudson.Util;
import net.praqma.hudson.exception.ScmException;
import net.praqma.hudson.exception.UnableToInitializeWorkspaceException;
import net.praqma.hudson.remoting.EstablishResult;
import net.praqma.hudson.scm.ClearCaseChangeset;

public class CheckoutTask
implements FilePath.FileCallable<EstablishResult> {
    private static final long serialVersionUID = -7029877626574728221L;
    private PrintStream hudsonOut;
    private String jobname;
    private SnapshotView sv;
    private String loadModule;
    private Baseline bl;
    private String buildProject;
    private Stream targetStream;
    private BuildListener listener;
    private Integer jobNumber;
    private String id = "";
    private boolean swipe = true;
    private boolean any = false;
    private Logger logger;

    public CheckoutTask(BuildListener listener, String jobname, Integer jobNumber, Stream targetStream, String loadModule, Baseline baseline, String buildProject, boolean any, boolean swipe) {
        this.jobname = jobname;
        this.jobNumber = jobNumber;
        this.targetStream = targetStream;
        this.loadModule = loadModule;
        this.bl = baseline;
        this.buildProject = buildProject;
        this.listener = listener;
        this.any = any;
        this.swipe = swipe;
        this.id = "[" + jobname + "::" + jobNumber + "-cotask]";
    }

    public EstablishResult invoke(File workspace, VirtualChannel channel) throws IOException {
        this.logger = Logger.getLogger(CheckoutTask.class.getName());
        this.hudsonOut = this.listener.getLogger();
        this.logger.fine(this.id + "Starting CheckoutTask");
        String diff = "";
        String viewtag = this.makeViewtag();
        EstablishResult er = new EstablishResult();
        ClearCaseChangeset changeset = new ClearCaseChangeset();
        try {
            this.targetStream.load();
        }
        catch (Exception e1) {
            ExceptionUtils.print((Throwable)e1, (PrintStream)this.hudsonOut, (boolean)false);
            ExceptionUtils.log((Throwable)e1, (boolean)true);
            throw new IOException(e1);
        }
        try {
            this.logger.fine(this.id + "Getting dev stream");
            Stream devstream = this.getDeveloperStream("stream:" + viewtag, this.targetStream.getPVob());
            devstream.load();
            this.logger.fine(this.id + "Getting foundation baseline");
            Baseline foundation = devstream.getFoundationBaseline();
            foundation.load();
            if (!foundation.getStream().equals((Object)this.targetStream)) {
                this.hudsonOut.println("[" + Config.nameShort + "] The foundation baseline " + foundation.getShortname() + " does not match the stream " + this.targetStream.getShortname() + ". Changelog will probably be bogus.");
            }
            this.logger.fine(this.id + "Making workspace");
            this.makeWorkspace(workspace, viewtag);
            List bldiff = null;
            if (this.any) {
                if (devstream.isCreated()) {
                    this.logger.fine("Diffing newly created stream");
                    bldiff = Version.getBaselineDiff((Diffable)this.targetStream.getFoundationBaseline(), (Diffable)this.bl, (boolean)true, (File)this.sv.getViewRoot());
                } else {
                    this.logger.fine("Diffing OOOOld stream");
                    bldiff = Version.getBaselineDiff((Diffable)foundation, (Diffable)this.bl, (boolean)true, (File)this.sv.getViewRoot());
                }
            } else {
                BaselineList previous = new BaselineList(this.targetStream, this.bl.getComponent(), null).addFilter((BaselineFilter)new BeforeBaseline(this.bl)).setLimit(1).apply();
                bldiff = previous.size() > 0 ? Version.getBaselineDiff((Diffable)this.bl, (Diffable)((Diffable)previous.get(0)), (boolean)true, (File)this.sv.getViewRoot()) : Collections.emptyList();
            }
            er.setActivities(bldiff);
            this.logger.fine(this.id + "DONE");
            this.logger.info("CheckoutTask finished normally");
        }
        catch (Exception e) {
            throw new IOException("", new UnableToInitializeWorkspaceException("Unable to initialize workspace", e));
        }
        er.setMessage(diff);
        er.setViewtag(viewtag);
        return er;
    }

    private String makeViewtag() {
        String newJobName = this.jobname.replaceAll("\\s", "_");
        String viewtag = "CCUCM_" + newJobName + "_" + System.getenv("COMPUTERNAME");
        return viewtag;
    }

    private void makeWorkspace(File workspace, String viewtag) throws ScmException, ClearCaseException {
        if (workspace != null) {
            this.logger.fine(this.id + "workspace: " + workspace.getAbsolutePath());
        } else {
            this.logger.fine(this.id + "workspace must be null???");
        }
        File viewroot = new File(workspace, "view");
        this.logger.fine(this.id + "Creating dev strem");
        Stream devstream = this.getDeveloperStream("stream:" + viewtag, this.targetStream.getPVob());
        this.logger.fine(this.id + "Making view");
        this.sv = Util.makeView(devstream, workspace, this.listener, this.loadModule, viewroot, viewtag, false);
        this.logger.fine(this.id + "Checking rebasing");
        if (Rebase.isInProgress((Stream)devstream)) {
            this.hudsonOut.print("[" + Config.nameShort + "] Cancelling previous rebase.");
            Rebase.cancelRebase((Stream)devstream);
            this.hudsonOut.println(" Done");
        }
        this.hudsonOut.print("[" + Config.nameShort + "] Rebasing development stream (" + devstream.getShortname() + ") against parent stream (" + this.targetStream.getShortname() + ")");
        try {
            this.logger.fine(this.id + "Rebasing");
            Rebase rebase = new Rebase(devstream, (UCMView)this.sv, this.bl);
            rebase.rebase(true);
            this.logger.fine(this.id + "Rebasing done");
        }
        catch (RebaseException e1) {
            this.logger.fine(this.id + "Rebasing failed: " + e1.getMessage());
            this.hudsonOut.println(" Failed");
            throw e1;
        }
        this.hudsonOut.println(" Done");
        try {
            this.hudsonOut.println("[" + Config.nameShort + "] Updating view using " + this.loadModule.toLowerCase() + " modules");
            this.logger.fine(this.id + "Updating stream");
            this.sv.Update(this.swipe, true, true, false, new SnapshotView.LoadRules(this.sv, SnapshotView.Components.valueOf((String)this.loadModule.toUpperCase())));
            this.logger.fine(this.id + "Updating done");
        }
        catch (ClearCaseException e) {
            e.print(this.hudsonOut);
            throw new ScmException("Could not update snapshot view", (Exception)((Object)e));
        }
    }

    private Stream getDeveloperStream(String streamname, PVob pvob) throws ScmException {
        Stream devstream = null;
        try {
            if (Stream.streamExists((String)(streamname + "@" + pvob))) {
                devstream = Stream.get((String)streamname, (PVob)pvob);
            } else {
                if (this.buildProject.equals("")) {
                    this.buildProject = null;
                }
                devstream = Stream.create((Stream)Config.getIntegrationStream(this.bl, this.buildProject), (String)(streamname + "@" + pvob), (boolean)true, (Baseline)this.bl);
            }
        }
        catch (ScmException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ScmException("Could not get stream", e);
        }
        return devstream;
    }

    public SnapshotView getSnapshotView() {
        return this.sv;
    }
}

