/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.notifier;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import net.praqma.clearcase.exceptions.ClearCaseException;
import net.praqma.clearcase.exceptions.TagException;
import net.praqma.clearcase.ucm.entities.Baseline;
import net.praqma.clearcase.ucm.entities.Project;
import net.praqma.clearcase.ucm.entities.Stream;
import net.praqma.clearcase.ucm.entities.Tag;
import net.praqma.clearcase.util.ExceptionUtils;
import net.praqma.hudson.Config;
import net.praqma.hudson.notifier.CCUCMNotifier;
import net.praqma.hudson.notifier.Status;
import net.praqma.hudson.scm.Unstable;

class RemotePostBuild
implements FilePath.FileCallable<Status> {
    private static final long serialVersionUID = 1L;
    private String displayName;
    private String buildNumber;
    private Result result;
    private Baseline sourcebaseline;
    private Baseline targetbaseline;
    private Stream sourcestream;
    private Stream targetstream;
    private boolean makeTag = false;
    private boolean recommend = false;
    private Status status;
    private BuildListener listener;
    private String id = "";
    private PrintStream hudsonOut = null;
    private Unstable unstable;
    private boolean any;

    public RemotePostBuild(Result result, Status status, BuildListener listener, boolean makeTag, boolean recommended, Unstable unstable, boolean any, Baseline sourcebaseline, Baseline targetbaseline, Stream sourcestream, Stream targetstream, String displayName, String buildNumber) {
        this.displayName = displayName;
        this.buildNumber = buildNumber;
        this.id = "[" + displayName + "::" + buildNumber + "]";
        this.sourcebaseline = sourcebaseline;
        this.targetbaseline = targetbaseline;
        this.sourcestream = sourcestream;
        this.targetstream = targetstream;
        this.unstable = unstable;
        this.result = result;
        this.makeTag = makeTag;
        this.recommend = recommended;
        this.status = status;
        this.listener = listener;
        this.any = any;
    }

    public Status invoke(File workspace, VirtualChannel channel) throws IOException {
        Exception failBuild;
        String noticeString;
        Logger logger;
        block38: {
            Tag tag;
            block37: {
                Project.PromotionLevel pl;
                this.hudsonOut = this.listener.getLogger();
                logger = Logger.getLogger(RemotePostBuild.class.getName());
                logger.info("Starting PostBuild task");
                noticeString = "";
                tag = null;
                if (this.makeTag) {
                    logger.fine("Trying to get/make tag");
                    try {
                        tag = this.sourcebaseline.getTag(this.displayName, this.buildNumber);
                        this.status.setTagAvailable(true);
                    }
                    catch (Exception e) {
                        this.hudsonOut.println("Unable to get tag for " + this.sourcebaseline.getNormalizedName());
                    }
                }
                if (this.result.equals(Result.SUCCESS)) {
                    this.status.setRecommended(true);
                    if (this.status.isTagAvailable()) {
                        logger.fine("Tag is available");
                        if (this.status.isStable()) {
                            tag.setEntry("buildstatus", "SUCCESS");
                        } else {
                            tag.setEntry("buildstatus", "UNSTABLE");
                        }
                    }
                    try {
                        if (!this.any) {
                            if (this.hasRemoteMastership()) {
                                logger.fine("Source/Target masterships differ, hasRemoteMastership = true");
                                this.printPostedOutput(this.sourcebaseline);
                                noticeString = "*";
                            } else {
                                if (!this.status.isStable() && !this.unstable.treatSuccessful()) {
                                    pl = this.sourcebaseline.demote();
                                    this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline " + this.sourcebaseline.getShortname() + " is " + pl.toString() + ".");
                                } else {
                                    pl = this.sourcebaseline.promote();
                                    this.hudsonOut.print(CCUCMNotifier.logShortPrefix + " Baseline " + this.sourcebaseline.getShortname() + " promoted to " + pl.toString());
                                    if (!this.status.isStable()) {
                                        this.hudsonOut.println(", even though the build is unstable.");
                                    } else {
                                        this.hudsonOut.println(".");
                                    }
                                }
                                this.status.setPromotedLevel(pl);
                            }
                        } else {
                            this.status.setPromotedLevel(this.sourcebaseline.getPromotionLevel(false));
                        }
                        if (!this.recommend) break block37;
                        try {
                            this.targetstream.recommendBaseline(this.targetbaseline);
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline " + this.targetbaseline.getShortname() + " is now recommended.");
                        }
                        catch (ClearCaseException e) {
                            this.status.setStable(false);
                            this.status.setRecommended(false);
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Could not recommend Baseline " + this.targetbaseline.getShortname() + ": " + e.getMessage());
                            logger.warning(this.id + "Could not recommend baseline: " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        this.status.setStable(false);
                        if (this.recommend) {
                            this.status.setRecommended(false);
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Could not promote baseline " + this.sourcebaseline.getShortname() + " and will not recommend " + this.targetbaseline.getShortname() + ". " + e.getMessage());
                            logger.warning(this.id + "Could not promote baseline and will not recommend. " + e.getMessage());
                            break block37;
                        }
                        this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Could not promote baseline " + this.sourcebaseline.getShortname() + ". " + e.getMessage());
                        logger.warning(this.id + "Could not promote baseline. " + e.getMessage());
                    }
                } else {
                    this.status.setRecommended(false);
                    this.hudsonOut.println("[" + Config.nameShort + "] Build failed.");
                    if (this.status.isTagAvailable()) {
                        tag.setEntry("buildstatus", "FAILURE");
                    }
                    if (!this.any) {
                        try {
                            if (this.hasRemoteMastership()) {
                                this.printPostedOutput(this.sourcebaseline);
                                noticeString = "*";
                                break block37;
                            }
                            logger.warning(this.id + "Demoting baseline");
                            pl = this.sourcebaseline.demote();
                            this.status.setPromotedLevel(pl);
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline " + this.sourcebaseline.getShortname() + " is " + this.sourcebaseline.getPromotionLevel(true).toString() + ".");
                        }
                        catch (Exception e) {
                            this.status.setStable(false);
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Could not demote baseline " + this.sourcebaseline.getShortname() + ". " + e.getMessage());
                            logger.warning(this.id + "Could not demote baseline. " + e.getMessage());
                        }
                    } else {
                        this.status.setPromotedLevel(this.sourcebaseline.getPromotionLevel(false));
                    }
                }
            }
            failBuild = null;
            if (this.makeTag) {
                if (tag != null) {
                    try {
                        if (this.hasRemoteMastership()) {
                            this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline not marked with tag as it has different mastership");
                            break block38;
                        }
                        tag = tag.persist();
                        this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline now marked with tag: \n" + tag.stringify());
                    }
                    catch (Exception e) {
                        this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Could not change tag in ClearCase. Contact ClearCase administrator to do this manually.");
                        if (e instanceof TagException && ((TagException)e).getType().equals((Object)TagException.Type.NO_SUCH_HYPERLINK)) {
                            logger.severe("Hyperlink type not found, failing build");
                            this.hudsonOut.println("Hyperlink type not found, failing build");
                            failBuild = e;
                            break block38;
                        }
                        ExceptionUtils.print((Throwable)e, (PrintStream)this.hudsonOut, (boolean)false);
                        ExceptionUtils.log((Throwable)e, (boolean)true);
                    }
                } else {
                    logger.warning(this.id + "Tag object was null");
                    this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Tag object was null, tag not set.");
                }
            }
        }
        String newPLevel = this.sourcebaseline.getPromotionLevel(true).toString();
        if (this.sourcestream.equals((Object)this.targetstream)) {
            this.status.setBuildDescr(this.setDisplaystatusSelf(newPLevel + noticeString, this.targetbaseline.getShortname()));
        } else {
            this.status.setBuildDescr(this.setDisplaystatus(this.sourcebaseline.getShortname(), newPLevel + noticeString, this.targetbaseline.getShortname(), this.status.getErrorMessage()));
        }
        if (failBuild != null) {
            throw new IOException(failBuild);
        }
        logger.info(this.id + "Remote post build finished normally");
        return this.status;
    }

    private void printPostedOutput(Baseline sourcebaseline) throws ClearCaseException {
        this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Baseline " + sourcebaseline.getShortname() + " was a posted delivery, and has a different mastership.");
        this.hudsonOut.println(CCUCMNotifier.logShortPrefix + " Its promotion level cannot be updated, but is left as " + sourcebaseline.getPromotionLevel(true).toString());
    }

    private boolean hasRemoteMastership() throws ClearCaseException {
        return !this.sourcebaseline.getMastership().equals(this.targetbaseline.getMastership());
    }

    private String setDisplaystatusSelf(String plevel, String fqn) {
        String s = "";
        s = s + "<small>" + fqn + " <b>" + plevel + "</b></small>";
        if (this.recommend) {
            s = this.status.isRecommended() ? s + "<br/><B><small>Recommended</small></B>" : s + "<br/><B><small>Could not recommend</small></B>";
        }
        return s;
    }

    private String setDisplaystatus(String source, String plevel, String target, String error) {
        String s = "";
        if (plevel.equals("REJECTED")) {
            try {
                s = s + "<small>" + source + " made by " + this.sourcebaseline.getUser() + " was <b>" + plevel + "</b></small>";
            }
            catch (Exception e) {
                this.hudsonOut.print(e);
            }
        } else {
            s = s + "<small>" + source + " <b>" + plevel + "</b></small>";
        }
        if (this.status.isRecommended() && this.recommend) {
            s = s + "<br/><small>" + target + " <b>recommended</b></small>";
        }
        if (error != null) {
            s = s + "<br/><small>Failed with <b>" + error + "</b></small>";
        }
        return s;
    }
}

