/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.hudson.nametemplates;

import hudson.EnvVars;
import java.util.logging.Logger;
import net.praqma.hudson.CCUCMBuildAction;
import net.praqma.hudson.exception.TemplateException;
import net.praqma.hudson.nametemplates.Template;

public class EnvTemplate
extends Template {
    private Logger logger = Logger.getLogger(EnvTemplate.class.getName());

    @Override
    public String parse(CCUCMBuildAction action, String args) throws TemplateException {
        this.logger.finest("ENV PARSING");
        EnvVars vars = null;
        try {
            vars = action.getBuild().getEnvironment(action.getListener());
        }
        catch (Exception e) {
            this.logger.warning("I could not get env vars: " + e.getMessage());
            return "?";
        }
        this.logger.finest("ENV VARS: " + vars);
        this.logger.finest("ENV VARS: " + System.getenv());
        if (vars.containsKey((Object)args)) {
            this.logger.finest("EnvVars: " + args + "=" + (String)vars.get((Object)args));
            return (String)vars.get((Object)args);
        }
        if (action.getBuild().getBuildVariables().containsKey(args)) {
            this.logger.finest("BuildVars: " + args + "=" + (String)action.getBuild().getBuildVariables().get(args));
            return (String)action.getBuild().getBuildVariables().get(args);
        }
        if (System.getenv().containsKey(args)) {
            this.logger.finest("Vars: " + args + "=" + System.getenv(args));
            return (String)vars.get((Object)args);
        }
        return "?";
    }
}

