/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.openhft.posix.ClockId;
import net.openhft.posix.MAdviseFlag;
import net.openhft.posix.MMapFlag;
import net.openhft.posix.MMapProt;
import net.openhft.posix.MSyncFlag;
import net.openhft.posix.MclFlag;
import net.openhft.posix.OpenFlag;
import net.openhft.posix.WhenceFlag;
import net.openhft.posix.internal.PosixAPIHolder;
import net.openhft.posix.internal.UnsafeMemory;

public interface PosixAPI {
    public static PosixAPI posix() {
        return PosixAPIHolder.POSIX_API;
    }

    public int close(int var1);

    public int fallocate(int var1, int var2, long var3, long var5);

    public int ftruncate(int var1, long var2);

    default public long lseek(int fd, long offset, WhenceFlag whence) {
        return this.lseek(fd, offset, whence.value());
    }

    public long lseek(int var1, long var2, int var4);

    public int lockf(int var1, int var2, long var3);

    default public int madvise(long addr, long length, MAdviseFlag advice) {
        return this.madvise(addr, length, advice.value());
    }

    public int madvise(long var1, long var3, int var5);

    default public long mmap(long addr, long length, MMapProt prot, MMapFlag flags, int fd, long offset) {
        return this.mmap(addr, length, prot.value(), flags.value(), fd, offset);
    }

    public long mmap(long var1, long var3, int var5, int var6, int var7, long var8);

    default public boolean mlock(long addr, long length, boolean lockOnFault) {
        return false;
    }

    default public void mlockall(MclFlag flags) {
        this.mlockall(flags.code());
    }

    default public void mlockall(int flags) {
    }

    default public int msync(long address, long length, MSyncFlag flags) {
        return this.msync(address, length, flags.value());
    }

    public int msync(long var1, long var3, int var5);

    public int munmap(long var1, long var3);

    default public int open(CharSequence path, OpenFlag flags, int perm) {
        return this.open(path, flags.value(), perm);
    }

    public int open(CharSequence var1, int var2, int var3);

    public long read(int var1, long var2, long var4);

    public long write(int var1, long var2, long var4);

    default public long du(String filename) throws IOException {
        ProcessBuilder pb = new ProcessBuilder("du", filename);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = br.readLine();
            long l = Long.parseUnsignedLong(line.split("\\s+")[0]);
            return l;
        }
    }

    public int gettimeofday(long var1);

    public int sched_setaffinity(int var1, int var2, long var3);

    public int sched_getaffinity(int var1, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String sched_getaffinity_summary(int pid) {
        int nprocs_conf = this.get_nprocs_conf();
        int size = Math.max(8, (nprocs_conf + 7) / 64 * 8);
        long ptr = this.malloc(size);
        boolean set = false;
        int start = 0;
        StringBuilder sb = new StringBuilder();
        try {
            int ret = this.sched_getaffinity(pid, size, ptr);
            if (ret != 0) {
                String string = "na: " + this.lastError();
                return string;
            }
            for (int i = 0; i < nprocs_conf; ++i) {
                int b = UnsafeMemory.UNSAFE.getInt(ptr + (long)(i / 32));
                if ((b >> i & 1) != 0) {
                    if (set) continue;
                    start = i;
                    set = true;
                    continue;
                }
                if (!set) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(start).append('-').append(i - 1);
                set = false;
            }
            if (set) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(start).append('-').append(nprocs_conf - 1);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.free(ptr);
        }
    }

    public int lastError();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int sched_setaffinity_as(int pid, int cpu) {
        int nprocs_conf = this.get_nprocs_conf();
        int size = Math.max(8, (nprocs_conf + 7) / 64 * 8);
        long ptr = this.malloc(size);
        try {
            for (int i = 0; i < size; i += 4) {
                UnsafeMemory.UNSAFE.putInt(ptr + (long)i, 0);
            }
            UnsafeMemory.UNSAFE.putByte(ptr + (long)(cpu / 8), (byte)(1 << (cpu & 7)));
            int n = this.sched_setaffinity(pid, size, ptr);
            return n;
        }
        finally {
            this.free(ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int sched_setaffinity_range(int pid, int from, int to) {
        int nprocs_conf = this.get_nprocs_conf();
        int size = Math.max(8, (nprocs_conf + 7) / 64 * 8);
        long ptr = this.malloc(size);
        try {
            int i;
            for (i = 0; i < size; i += 4) {
                UnsafeMemory.UNSAFE.putInt(ptr + (long)i, 0);
            }
            for (i = from; i <= to; ++i) {
                UnsafeMemory.UNSAFE.putInt(ptr + (long)(i / 32), UnsafeMemory.UNSAFE.getInt(ptr + (long)(i / 32)) | 1 << i);
            }
            int n = this.sched_setaffinity(pid, size, ptr);
            return n;
        }
        finally {
            this.free(ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public long gettimeofday() {
        long ptr = this.malloc(16L);
        try {
            if (this.gettimeofday(ptr) != 0) {
                long l = 0L;
                return l;
            }
            long l = UnsafeMemory.UNSAFE.getLong(ptr) * 1000000L + (long)UnsafeMemory.UNSAFE.getInt(ptr + 8L);
            return l;
        }
        finally {
            this.free(ptr);
        }
    }

    default public long clock_gettime() {
        return this.clock_gettime(0);
    }

    default public long clock_gettime(ClockId clockId) throws IllegalArgumentException {
        return this.clock_gettime(clockId.value());
    }

    public long clock_gettime(int var1) throws IllegalArgumentException;

    public long malloc(long var1);

    public void free(long var1);

    public int get_nprocs();

    public int get_nprocs_conf();

    public int getpid();

    public int gettid();

    public String strerror(int var1);

    default public String lastErrorStr() {
        return this.strerror(this.lastError());
    }
}

