/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix.internal.jnr;

import jnr.constants.platform.Errno;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.FFIProvider;
import net.openhft.posix.MSyncFlag;
import net.openhft.posix.PosixAPI;
import net.openhft.posix.internal.jnr.JNRPosixInterface;

public class JNRPosixAPI
implements PosixAPI {
    static final Runtime RUNTIME = FFIProvider.getSystemProvider().getRuntime();
    static final Platform NATIVE_PLATFORM = Platform.getNativePlatform();
    static final String STANDARD_C_LIBRARY_NAME = NATIVE_PLATFORM.getStandardCLibraryName();
    static final Pointer NULL = Pointer.wrap((Runtime)RUNTIME, (long)0L);
    private final JNRPosixInterface jnr;
    private int get_nprocs_conf = 0;

    public JNRPosixAPI() {
        LibraryLoader loader = LibraryLoader.create(JNRPosixInterface.class);
        loader.library(STANDARD_C_LIBRARY_NAME);
        this.jnr = (JNRPosixInterface)loader.load();
    }

    @Override
    public int open(CharSequence path, int flags, int perm) {
        return this.jnr.open(path, flags, perm);
    }

    @Override
    public int ftruncate(int fd, long offset) {
        return this.jnr.ftruncate(fd, offset);
    }

    @Override
    public int close(int fd) {
        return this.jnr.close(fd);
    }

    @Override
    public long mmap(long addr, long length, int prot, int flags, int fd, long offset) {
        Pointer wrap = addr == 0L ? NULL : Pointer.wrap((Runtime)RUNTIME, (long)addr);
        long mmap = this.jnr.mmap(wrap, length, prot, flags, fd, offset);
        if (mmap == 0L || mmap == -1L) {
            int lastError = RUNTIME.getLastError();
            for (Errno errno : Errno.values()) {
                if (errno.intValue() != lastError) continue;
                throw new RuntimeException(errno.toString());
            }
        }
        return mmap;
    }

    @Override
    public int munmap(long addr, long length) {
        return this.jnr.munmap(addr, length);
    }

    @Override
    public boolean msyncSupported(MSyncFlag mode) {
        return true;
    }

    @Override
    public int msync(long address, long length, int flags) {
        return this.jnr.msync(address, length, flags);
    }

    @Override
    public int fallocate(int fd, int mode, long offset, long length) {
        return this.jnr.fallocate(fd, mode, offset, length);
    }

    @Override
    public int madvise(long addr, long length, int advice) {
        return this.jnr.madvise(addr, length, advice);
    }

    @Override
    public long read(int fd, long dst, long len) {
        return this.jnr.read(fd, dst, len);
    }

    @Override
    public long write(int fd, long src, long len) {
        return this.jnr.write(fd, src, len);
    }

    @Override
    public int gettimeofday(long timeval) {
        return this.jnr.gettimeofday(timeval, 0L);
    }

    @Override
    public long malloc(long size) {
        return this.jnr.malloc(size);
    }

    @Override
    public void free(long ptr) {
        this.jnr.free(ptr);
    }

    @Override
    public int get_nprocs() {
        return this.jnr.get_nprocs();
    }

    @Override
    public int get_nprocs_conf() {
        if (this.get_nprocs_conf == 0) {
            this.get_nprocs_conf = this.jnr.get_nprocs_conf();
        }
        return this.get_nprocs_conf;
    }

    @Override
    public int sched_setaffinity(int pid, int cpusetsize, long mask) {
        return this.jnr.sched_setaffinity(pid, cpusetsize, Pointer.wrap((Runtime)Runtime.getSystemRuntime(), (long)mask));
    }

    @Override
    public int sched_getaffinity(int pid, int cpusetsize, long mask) {
        return this.jnr.sched_getaffinity(pid, cpusetsize, Pointer.wrap((Runtime)Runtime.getSystemRuntime(), (long)mask));
    }

    @Override
    public int gettid() {
        return this.jnr.gettid();
    }

    @Override
    public int lastError() {
        return Runtime.getSystemRuntime().getLastError();
    }
}

