/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import org.slf4j.LoggerFactory;

public interface FileLifecycleListener {
    public void onEvent(EventType var1, File var2, long var3);

    public static enum FileLifecycleListeners implements FileLifecycleListener
    {
        IGNORE{

            @Override
            public void onEvent(EventType type, File file, long timeInNanos) {
            }
        }
        ,
        CONSOLE{

            @Override
            public void onEvent(EventType type, File file, long timeInNanos) {
                System.out.println("File " + file + " took " + (double)(timeInNanos / 1000L) / 1000.0 + " ms. to " + (Object)((Object)type));
            }
        }
        ,
        LOG{

            @Override
            public void onEvent(EventType type, File file, long timeInNanos) {
                LoggerFactory.getLogger(FileLifecycleListeners.class).info("File " + file + " took " + (double)(timeInNanos / 1000L) / 1000.0 + " ms. to " + (Object)((Object)type));
            }
        };

    }

    public static enum EventType {
        NEW,
        MMAP,
        UNMAP,
        GROW,
        SYNC,
        DELETE,
        CLOSE;

    }
}

