/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.ImmutableMarshaller;
import net.openhft.lang.io.serialization.impl.StringBuilderPool;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import net.openhft.lang.pool.StringInterner;

public class StringMarshaller
extends ImmutableMarshaller<String>
implements CompactBytesMarshaller<String> {
    private final int size;
    private static final StringBuilderPool sbp = new StringBuilderPool();
    private transient StringInterner interner;

    public StringMarshaller(int size) {
        this.size = size;
    }

    @Override
    public void write(@NotNull Bytes bytes, String s) {
        bytes.writeUTF\u0394(s);
    }

    @Override
    @Nullable
    public String read(@NotNull Bytes bytes) {
        StringBuilder sb = sbp.acquireStringBuilder();
        if (bytes.readUTF\u0394(sb)) {
            return this.builderToString(sb);
        }
        return null;
    }

    private String builderToString(StringBuilder reader) {
        if (this.interner == null) {
            if (this.size == 0) {
                return reader.toString();
            }
            this.interner = new StringInterner(this.size);
        }
        return this.interner.intern(reader);
    }

    @Override
    public byte code() {
        return 19;
    }
}

