/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedFile;
import net.openhft.lang.io.VanillaMappedMode;
import net.openhft.lang.io.VanillaMappedResource;

public class VanillaMappedBlocks
implements VanillaMappedResource {
    private final VanillaMappedFile mappedFile;
    private final List<VanillaMappedBytes> bytes;
    private final long blockSize;
    private final Object lock;

    public VanillaMappedBlocks(File path, VanillaMappedMode mode, long blockSize, long overlapSize) throws IOException {
        this(path, mode, blockSize + overlapSize);
    }

    public VanillaMappedBlocks(File path, VanillaMappedMode mode, long blockSize) throws IOException {
        this.mappedFile = new VanillaMappedFile(path, mode, -1L);
        this.bytes = new ArrayList<VanillaMappedBytes>();
        this.blockSize = blockSize;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VanillaMappedBytes acquire(long index) throws IOException {
        VanillaMappedBytes mb = null;
        Object object = this.lock;
        synchronized (object) {
            for (int i = this.bytes.size() - 1; i >= 0; --i) {
                if (this.bytes.get(i).index() == index && !this.bytes.get(i).unmapped()) {
                    mb = this.bytes.get(i);
                    mb.reserve();
                    continue;
                }
                if (this.bytes.get(i).refCount() > 0 && !this.bytes.get(i).unmapped()) continue;
                if (!this.bytes.get(i).unmapped()) {
                    this.bytes.get(i).cleanup();
                }
                this.bytes.remove(i);
            }
            if (mb == null) {
                mb = this.mappedFile.bytes(index * this.blockSize, this.blockSize, index);
                this.bytes.add(mb);
            }
        }
        return mb;
    }

    @Override
    public String path() {
        return this.mappedFile.path();
    }

    @Override
    public long size() {
        return this.mappedFile.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (VanillaMappedBytes vmb : this.bytes) {
                vmb.cleanup();
            }
            this.bytes.clear();
            this.mappedFile.close();
        }
    }

    public static VanillaMappedBlocks readWrite(File path, long size) throws IOException {
        return new VanillaMappedBlocks(path, VanillaMappedMode.RW, size);
    }

    public static VanillaMappedBlocks readOnly(File path, long size) throws IOException {
        return new VanillaMappedBlocks(path, VanillaMappedMode.RO, size);
    }
}

