/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

public class MappedStore
implements BytesStore {
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private final File file;
    private final FileChannel fileChannel;
    private final Cleaner cleaner;
    private final long address;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final long size;
    private final BytesMarshallerFactory bytesMarshallerFactory;

    public MappedStore(File file, FileChannel.MapMode mode, long size) throws IOException {
        this(file, mode, size, new VanillaBytesMarshallerFactory());
    }

    private MappedStore(File file, FileChannel.MapMode mode, long size, BytesMarshallerFactory bytesMarshallerFactory) throws IOException {
        if (size < 0L || size > 0x800000000000L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.file = file;
        this.size = size;
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, MappedStore.accesModeFor(mode));
            if (raf.length() != this.size) {
                if (mode != FileChannel.MapMode.READ_WRITE) {
                    throw new IOException("Cannot resize file to " + size + " as mode is not READ_WRITE");
                }
                raf.setLength(this.size);
            }
            this.fileChannel = raf.getChannel();
            this.address = MappedStore.map0(this.fileChannel, MappedStore.imodeFor(mode), 0L, size);
            this.cleaner = Cleaner.create((Object)this, (Runnable)new Unmapper(this.address, size, this.fileChannel));
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    @Override
    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void free() {
        this.cleaner.clean();
    }

    @Override
    @NotNull
    public DirectBytes bytes() {
        return new DirectBytes(this, this.refCount);
    }

    @Override
    @NotNull
    public DirectBytes bytes(long offset, long length) {
        return new DirectBytes(this, this.refCount, offset, length);
    }

    private static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    private static void unmap0(long address, long size) throws IOException {
        try {
            Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, address, size);
        }
        catch (Exception e) {
            throw MappedStore.wrap(e);
        }
    }

    private static IOException wrap(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    private static String accesModeFor(FileChannel.MapMode mode) {
        return mode == FileChannel.MapMode.READ_WRITE ? "rw" : "r";
    }

    private static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public File file() {
        return this.file;
    }

    static class Unmapper
    implements Runnable {
        private final long size;
        private final FileChannel channel;
        private volatile long address;

        Unmapper(long address, long size, FileChannel channel) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.channel = channel;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                MappedStore.unmap0(this.address, this.size);
                this.address = 0L;
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

