/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.Collection;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

abstract class CollectionMarshaller<E, C extends Collection<E>> {
    public static final int NULL_LENGTH = -1;
    final BytesMarshaller<E> eBytesMarshaller;

    protected CollectionMarshaller(BytesMarshaller<E> eBytesMarshaller) {
        this.eBytesMarshaller = eBytesMarshaller;
    }

    public void write(Bytes bytes, C c) {
        if (c == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        bytes.writeStopBit(c.size());
        for (Object e : c) {
            this.eBytesMarshaller.write(bytes, e);
        }
    }

    public C read(Bytes bytes) {
        return this.read(bytes, null);
    }

    abstract C newCollection();

    public C read(Bytes bytes, @Nullable C c) {
        long length = bytes.readStopBit();
        if (length == 0L && c != null) {
            return c;
        }
        if (length < -1L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        if (length == -1L) {
            return null;
        }
        return this.readCollection(bytes, c, (int)length);
    }

    abstract C readCollection(Bytes var1, C var2, int var3);
}

