/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.threadlocal;

import net.openhft.lang.threadlocal.StatefulCopyable;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class Provider<T> {
    public static <T> Provider<T> of(Class<T> tClass) {
        if (StatefulCopyable.class.isAssignableFrom(tClass)) {
            return StatefulProvider.INSTANCE;
        }
        return StatelessProvider.INSTANCE;
    }

    public abstract T get(ThreadLocalCopies var1, T var2);

    public abstract ThreadLocalCopies getCopies(ThreadLocalCopies var1);

    private static final class StatelessProvider<M>
    extends Provider<M> {
        private static final Provider INSTANCE = new StatelessProvider();

        private StatelessProvider() {
        }

        @Override
        public M get(ThreadLocalCopies copies, M original) {
            return original;
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            return copies;
        }
    }

    private static final class StatefulProvider<T extends StatefulCopyable<T>>
    extends Provider<T> {
        private static final Provider INSTANCE = new StatefulProvider();

        private StatefulProvider() {
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            if (copies != null) {
                return copies;
            }
            return ThreadLocalCopies.get();
        }

        @Override
        public T get(ThreadLocalCopies copies, T original) {
            if (copies.currentlyAccessed.compareAndSet(false, true)) {
                try {
                    Object id = original.stateIdentity();
                    int m = copies.mask;
                    Object[] tab = copies.table;
                    int i = System.identityHashCode(id) & m;
                    while (true) {
                        Object idInTable;
                        if ((idInTable = tab[i]) == id) {
                            StatefulCopyable statefulCopyable = (StatefulCopyable)tab[i + 1];
                            return (T)statefulCopyable;
                        }
                        if (idInTable == null) {
                            tab[i] = id;
                            Object copy = original.copy();
                            tab[i + 1] = copy;
                            copies.postInsert();
                            Object s = copy;
                            return (T)s;
                        }
                        i = i + 2 & m;
                    }
                }
                finally {
                    copies.currentlyAccessed.set(false);
                }
            }
            throw new IllegalStateException("Concurrent or recursive access to ThreadLocalCopies is not allowed");
        }
    }
}

