/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.DirectBuffer;

public class ByteBufferBytes
extends AbstractBytes {
    private final ByteBuffer buffer;
    private final int start;
    private final int capacity;
    private int position;
    private int limit;
    private AtomicBoolean barrier;

    public ByteBufferBytes(ByteBuffer buffer) {
        this(buffer, 0, buffer.capacity());
    }

    public ByteBufferBytes(ByteBuffer buffer, int start, int capacity) {
        super(BytesMarshallableSerializer.create(new VanillaBytesMarshallerFactory(), JDKZObjectSerializer.INSTANCE), new AtomicInteger(1));
        buffer.order(ByteOrder.nativeOrder());
        this.buffer = buffer;
        this.start = this.position = start;
        this.capacity = this.limit = capacity + start;
    }

    @Override
    public ByteBufferBytes slice() {
        return new ByteBufferBytes(this.buffer(), this.position, this.limit - this.position);
    }

    @Override
    public ByteBufferBytes slice(long offset, long length) {
        long sliceStart = (long)this.position + offset;
        assert (sliceStart >= (long)this.start && sliceStart < (long)this.capacity);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= (long)this.capacity);
        return new ByteBufferBytes(this.buffer(), (int)sliceStart, (int)length);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int subStart = this.position + start;
        if (subStart < this.position || subStart > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int subEnd = this.position + end;
        if (subEnd < subStart || subEnd > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        return new ByteBufferBytes(this.buffer(), subStart, end - start);
    }

    @Override
    public ByteBufferBytes bytes() {
        return new ByteBufferBytes(this.buffer(), this.start, this.capacity - this.start);
    }

    @Override
    public ByteBufferBytes bytes(long offset, long length) {
        long sliceStart = (long)this.start + offset;
        assert (sliceStart >= (long)this.start && sliceStart < (long)this.capacity);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= (long)this.capacity);
        return new ByteBufferBytes(this.buffer(), (int)sliceStart, (int)length);
    }

    @Override
    public long address() {
        if (this.buffer instanceof DirectBuffer) {
            long address = ((DirectBuffer)((Object)this.buffer)).address();
            if (address == 0L) {
                throw new IllegalStateException("This buffer has no address, is it empty?");
            }
            return address;
        }
        throw new IllegalStateException("A heap ByteBuffer doesn't have a fixed address");
    }

    @Override
    public Bytes zeroOut() {
        int i;
        this.clear();
        for (i = this.start; i < this.capacity - 7; ++i) {
            this.buffer.putLong(i, 0L);
        }
        while (i < this.capacity) {
            this.buffer.put(i, (byte)0);
            ++i;
        }
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        int i;
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        int j = (int)((long)this.start + end);
        for (i = (int)((long)this.start + start); i < j - 7; ++i) {
            this.buffer.putLong(i, 0L);
        }
        while (i < j) {
            this.buffer.put(i, (byte)0);
            ++i;
        }
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end, boolean ifNotZero) {
        return this.zeroOut(start, end);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    void readBarrier() {
        if (this.barrier == null) {
            this.barrier = new AtomicBoolean();
        }
        this.barrier.get();
    }

    void writeBarrier() {
        if (this.barrier == null) {
            this.barrier = new AtomicBoolean();
        }
        this.barrier.lazySet(false);
    }

    @Override
    public int read(@net.openhft.lang.model.constraints.NotNull byte[] bytes, int off, int len) {
        ByteBufferBytes.checkArrayOffs(bytes.length, off, len);
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min(left, (long)len);
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = this.readByte();
        }
        return len2;
    }

    @Override
    public byte readByte() {
        if (this.position < this.capacity) {
            return this.buffer.get(this.position++);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public byte readByte(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos < this.capacity) {
            return this.buffer.get(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void readFully(@net.openhft.lang.model.constraints.NotNull byte[] b, int off, int len) {
        ByteBufferBytes.checkArrayOffs(b.length, off, len);
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        for (int i = 0; i < len; ++i) {
            b[off + i] = this.readByte();
        }
    }

    @Override
    public void readFully(@NotNull char[] data, int off, int len) {
        ByteBufferBytes.checkArrayOffs(data.length, off, len);
        long left = this.remaining();
        if (left < (long)len * 2L) {
            throw new IllegalStateException(new EOFException());
        }
        for (int i = 0; i < len; ++i) {
            data[off + i] = this.readChar();
        }
    }

    @Override
    public short readShort() {
        if (this.position + 2 <= this.capacity) {
            short s = this.buffer.getShort(this.position);
            this.position += 2;
            return s;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public short readShort(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 <= this.capacity) {
            return this.buffer.getShort(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar() {
        if (this.position + 2 <= this.capacity) {
            char ch = this.buffer.getChar(this.position);
            this.position += 2;
            return ch;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public char readChar(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 <= this.capacity) {
            return this.buffer.getChar(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt() {
        if (this.position + 4 <= this.capacity) {
            int i = this.buffer.getInt(this.position);
            this.position += 4;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readInt(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 <= this.capacity) {
            return this.buffer.getInt(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int readVolatileInt() {
        this.readBarrier();
        return this.readInt();
    }

    @Override
    public int readVolatileInt(long offset) {
        this.readBarrier();
        return this.readInt(offset);
    }

    @Override
    public long readLong() {
        if (this.position + 8 <= this.capacity) {
            long l = this.buffer.getLong(this.position);
            this.position += 8;
            return l;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readLong(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 <= this.capacity) {
            return this.buffer.getLong(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long readVolatileLong() {
        this.readBarrier();
        return this.readLong();
    }

    @Override
    public long readVolatileLong(long offset) {
        this.readBarrier();
        return this.readLong(offset);
    }

    @Override
    public float readFloat() {
        if (this.position + 4 <= this.capacity) {
            float f = this.buffer.getFloat(this.position);
            this.position += 4;
            return f;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public float readFloat(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 <= this.capacity) {
            return this.buffer.getFloat(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble() {
        if (this.position + 8 <= this.capacity) {
            double d = this.buffer.getDouble(this.position);
            this.position += 8;
            return d;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double readDouble(long offset) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 <= this.capacity) {
            return this.buffer.getDouble(pos);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void write(int b) {
        if (this.position >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.put(this.position++, (byte)b);
    }

    @Override
    public void writeByte(long offset, int b) {
        int pos = (int)((long)this.start + offset);
        if (pos >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.put(pos, (byte)b);
    }

    @Override
    public void writeShort(int v) {
        if (this.position + 2 <= this.capacity) {
            this.buffer.putShort(this.position, (short)v);
            this.position += 2;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeShort(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putShort(pos, (short)v);
    }

    @Override
    public void writeChar(int v) {
        if (this.position + 2 <= this.capacity) {
            this.buffer.putChar(this.position, (char)v);
            this.position += 2;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeChar(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 2 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putChar(pos, (char)v);
    }

    @Override
    public void writeInt(int v) {
        if (this.position + 4 <= this.capacity) {
            this.buffer.putInt(this.position, v);
            this.position += 4;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeInt(long offset, int v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putInt(pos, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.writeInt(v);
        this.writeBarrier();
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.writeInt(offset, v);
        this.writeBarrier();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        if (this.buffer instanceof DirectBuffer) {
            return NativeBytes.UNSAFE.compareAndSwapInt(null, ((DirectBuffer)((Object)this.buffer)).address() + offset, expected, x);
        }
        return NativeBytes.UNSAFE.compareAndSwapInt(this.buffer.array(), (long)NativeBytes.BYTES_OFFSET + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        if (this.position + 8 <= this.capacity) {
            this.buffer.putLong(this.position, v);
            this.position += 8;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeLong(long offset, long v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putLong(pos, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.writeLong(v);
        this.writeBarrier();
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.writeLong((int)offset, v);
        this.writeBarrier();
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        if (this.buffer instanceof DirectBuffer) {
            return NativeBytes.UNSAFE.compareAndSwapLong(null, ((DirectBuffer)((Object)this.buffer)).address() + offset, expected, x);
        }
        return NativeBytes.UNSAFE.compareAndSwapLong(this.buffer.array(), (long)NativeBytes.BYTES_OFFSET + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        if (this.position + 4 <= this.capacity) {
            this.buffer.putFloat(this.position, v);
            this.position += 4;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeFloat(long offset, float v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 4 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putFloat(pos, v);
    }

    @Override
    public void writeDouble(double v) {
        if (this.position + 8 <= this.capacity) {
            this.buffer.putDouble(this.position, v);
            this.position += 8;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void writeDouble(long offset, double v) {
        int pos = (int)((long)this.start + offset);
        if (pos + 8 > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.putDouble(pos, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.position - this.start;
    }

    @Override
    public ByteBufferBytes position(long position) {
        if ((long)this.start + position > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Position to large");
        }
        this.position = (int)((long)this.start + position);
        return this;
    }

    @Override
    public long capacity() {
        return this.capacity - this.start;
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    @Override
    public long limit() {
        return this.limit - this.start;
    }

    @Override
    public ByteBufferBytes limit(long limit) {
        this.limit = (int)((long)this.start + limit);
        return this;
    }

    @Override
    @net.openhft.lang.model.constraints.NotNull
    public ByteOrder byteOrder() {
        return this.buffer.order();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        if (this.position < this.start || this.position > this.capacity) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    protected void cleanup() {
        IOTools.clean(this.buffer);
    }

    @Override
    public Bytes load() {
        int pageSize = NativeBytes.UNSAFE.pageSize();
        for (int offset = this.start; offset < this.capacity; offset += pageSize) {
            this.buffer.get(offset);
        }
        return this;
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        this.position = this.position + powerOf2 - 1 & ~(powerOf2 - 1);
    }
}

