/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.Externalizable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.BytesMarshallableMarshaller;
import net.openhft.lang.io.serialization.impl.ClassMarshaller;
import net.openhft.lang.io.serialization.impl.CompactEnumBytesMarshaller;
import net.openhft.lang.io.serialization.impl.DateMarshaller;
import net.openhft.lang.io.serialization.impl.EnumBytesMarshaller;
import net.openhft.lang.io.serialization.impl.ExternalizableMarshaller;
import net.openhft.lang.io.serialization.impl.GenericEnumMarshaller;
import net.openhft.lang.io.serialization.impl.NoMarshaller;
import net.openhft.lang.io.serialization.impl.StringMarshaller;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaBytesMarshallerFactory
implements BytesMarshallerFactory {
    private Map<Class, BytesMarshaller> marshallerMap;
    private BytesMarshaller[] compactMarshallerMap;

    private void init() {
        this.marshallerMap = new LinkedHashMap<Class, BytesMarshaller>();
        this.compactMarshallerMap = new BytesMarshaller[256];
        StringMarshaller stringMarshaller = new StringMarshaller(16384);
        this.addMarshaller(String.class, stringMarshaller);
        this.addMarshaller(CharSequence.class, stringMarshaller);
        this.addMarshaller(Class.class, new ClassMarshaller(Thread.currentThread().getContextClassLoader()));
        this.addMarshaller(Date.class, new DateMarshaller(10191));
        this.addMarshaller(Integer.class, new CompactEnumBytesMarshaller<Integer>(Integer.class, 10191, 9));
        this.addMarshaller(Long.class, new CompactEnumBytesMarshaller<Long>(Long.class, 10191, 12));
        this.addMarshaller(Double.class, new CompactEnumBytesMarshaller<Double>(Double.class, 10191, 4));
    }

    @Override
    @NotNull
    public <E> BytesMarshaller<E> acquireMarshaller(@NotNull Class<E> eClass, boolean create) {
        BytesMarshaller<Object> em;
        if (this.marshallerMap == null) {
            this.init();
        }
        if ((em = this.marshallerMap.get(eClass)) == null) {
            if (eClass.isEnum()) {
                em = new EnumBytesMarshaller<Object>(eClass, null);
                this.marshallerMap.put(eClass, em);
            } else if (BytesMarshallable.class.isAssignableFrom(eClass)) {
                em = new BytesMarshallableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else if (Externalizable.class.isAssignableFrom(eClass)) {
                em = new ExternalizableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else {
                try {
                    em = new GenericEnumMarshaller<E>(eClass, 1000);
                    this.marshallerMap.put(eClass, em);
                }
                catch (Exception e) {
                    em = NoMarshaller.INSTANCE;
                    this.marshallerMap.put(eClass, em);
                }
            }
        }
        return em;
    }

    @Override
    public <E> BytesMarshaller<E> getMarshaller(byte code) {
        if (this.marshallerMap == null) {
            this.init();
        }
        return this.compactMarshallerMap[code & 0xFF];
    }

    @Override
    public <E> void addMarshaller(Class<E> eClass, BytesMarshaller<E> marshaller) {
        if (this.marshallerMap == null) {
            this.init();
        }
        this.marshallerMap.put(eClass, marshaller);
        if (marshaller instanceof CompactBytesMarshaller) {
            this.compactMarshallerMap[((CompactBytesMarshaller)marshaller).code()] = marshaller;
        }
    }
}

