/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.util.WeakHashMap;
import net.openhft.lang.model.DataValueClassCache;

public enum DataValueClasses {

    private static final WeakHashMap<ClassLoader, DataValueClassCache> cacheMap = new WeakHashMap();

    public static <T> T newInstance(Class<T> interfaceClass) {
        DataValueClassCache dataValueClassCache = DataValueClasses.acquireCache(interfaceClass);
        return dataValueClassCache.newInstance(interfaceClass);
    }

    public static <T> T newDirectReference(Class<T> interfaceClass) {
        DataValueClassCache dataValueClassCache = DataValueClasses.acquireCache(interfaceClass);
        return dataValueClassCache.newDirectReference(interfaceClass);
    }

    public static <T> Class<T> heapClassFor(Class<T> interfaceClass) {
        DataValueClassCache dataValueClassCache = DataValueClasses.acquireCache(interfaceClass);
        return dataValueClassCache.heapClassFor(interfaceClass);
    }

    public static <T> Class<T> directClassFor(Class<T> interfaceClass) {
        DataValueClassCache dataValueClassCache = DataValueClasses.acquireCache(interfaceClass);
        return dataValueClassCache.directClassFor(interfaceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> DataValueClassCache acquireCache(Class<T> interfaceClass) {
        DataValueClassCache dataValueClassCache;
        ClassLoader classLoader = interfaceClass.getClassLoader();
        WeakHashMap<ClassLoader, DataValueClassCache> weakHashMap = cacheMap;
        synchronized (weakHashMap) {
            dataValueClassCache = cacheMap.get(classLoader);
            if (dataValueClassCache == null) {
                dataValueClassCache = new DataValueClassCache();
                cacheMap.put(classLoader, dataValueClassCache);
            }
        }
        return dataValueClassCache;
    }
}

