/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection;

import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;

public class ATSDirectBitSet
implements DirectBitSet {
    private final Bytes bytes;
    private final long longLength;

    public ATSDirectBitSet(Bytes bytes) {
        this.bytes = bytes;
        this.longLength = bytes.capacity() >> 3;
    }

    @Override
    public void reserve() {
        this.bytes.reserve();
    }

    @Override
    public void release() {
        this.bytes.release();
    }

    @Override
    public int refCount() {
        return this.bytes.refCount();
    }

    @Override
    public DirectBitSet flip(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l ^ mask)) {
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet flip(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long l22;
            long l3;
            long i;
            long l23;
            long l4;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l4 = this.bytes.readVolatileLong(fromByteIndex), l23 = l4 ^ mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    while (!this.bytes.compareAndSwapLong(i << 3, l3 = this.bytes.readVolatileLong(i << 3), l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL)) {
                    }
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                while (!this.bytes.compareAndSwapLong(i << 3, l3 = this.bytes.readVolatileLong(i << 3), l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL)) {
                }
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            while (!this.bytes.compareAndSwapLong(toByteIndex, l4 = this.bytes.readVolatileLong(toByteIndex), l23 = l4 ^ mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l ^ mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet set(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if (((l = this.bytes.readVolatileLong(byteIndex)) & mask) == 0L) continue;
            return this;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2 = l | mask));
        return this;
    }

    @Override
    public boolean setIfClear(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if ((l = this.bytes.readVolatileLong(byteIndex)) != (l2 = l | mask)) continue;
            return false;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2));
        return true;
    }

    @Override
    public DirectBitSet set(long bitIndex, boolean value) {
        return value ? this.set(bitIndex) : this.clear(bitIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet set(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l3 = this.bytes.readVolatileLong(fromByteIndex), l22 = l3 | mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    this.bytes.writeLong(i << 3, -1L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                this.bytes.writeLong(i << 3, -1L);
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
            while (!this.bytes.compareAndSwapLong(toByteIndex, l3 = this.bytes.readVolatileLong(toByteIndex), l22 = l3 | mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex & -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL);
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l | mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet setAll() {
        for (long i = 0L; i < this.longLength; ++i) {
            this.bytes.writeLong(i << 3, -1L);
        }
        return this;
    }

    @Override
    public DirectBitSet set(long fromIndex, long toIndex, boolean value) {
        return value ? this.set(fromIndex, toIndex) : this.clear(fromIndex, toIndex);
    }

    @Override
    public DirectBitSet clear(long bitIndex) {
        long l2;
        long l;
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long byteIndex = longIndex << 3;
        long mask = 1L << (int)bitIndex;
        do {
            if (((l = this.bytes.readVolatileLong(byteIndex)) & mask) != 0L) continue;
            return this;
        } while (!this.bytes.compareAndSwapLong(byteIndex, l, l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DirectBitSet clear(long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = fromIndex >> 6;
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = toIndex >> 6;
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = fromLongIndex << 3;
                mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL;
                while (!this.bytes.compareAndSwapLong(fromByteIndex, l3 = this.bytes.readVolatileLong(fromByteIndex), l22 = l3 & mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return this;
                    }
                    this.bytes.writeLong(i << 3, 0L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                this.bytes.writeLong(i << 3, 0L);
            }
            long toByteIndex = toLongIndex << 3;
            mask = -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
            while (!this.bytes.compareAndSwapLong(toByteIndex, l3 = this.bytes.readVolatileLong(toByteIndex), l22 = l3 & mask)) {
            }
            return this;
        }
        long byteIndex = fromLongIndex << 3;
        long mask = -1L << (int)fromIndex ^ 0xFFFFFFFFFFFFFFFFL | -1L >>> (int)(toIndex ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL;
        while (!this.bytes.compareAndSwapLong(byteIndex, l = this.bytes.readVolatileLong(byteIndex), l2 = l & mask)) {
        }
        return this;
    }

    @Override
    public DirectBitSet clear() {
        this.bytes.zeroOut();
        return this;
    }

    @Override
    public boolean get(long bitIndex) {
        long longIndex = bitIndex >> 6;
        if (bitIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.bytes.readVolatileLong(longIndex << 3);
        return (l & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public long getLong(long longIndex) {
        if (longIndex < 0L || longIndex >= this.longLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes.readVolatileLong(longIndex << 3);
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.bytes.readVolatileLong(fromLongIndex << 3) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long clearNextSetBit(long fromIndex) {
        long w;
        long l;
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        while ((l = (w = this.bytes.readVolatileLong(fromByteIndex)) >>> (int)fromIndex) != 0L) {
            long indexOfSetBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            if (!this.bytes.compareAndSwapLong(fromByteIndex, w, w ^ mask)) continue;
            return indexOfSetBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long l2;
            long byteIndex = i << 3;
            while ((l2 = this.bytes.readLong(byteIndex)) != 0L) {
                long indexOfSetBit = (i << 6) + (long)Long.numberOfTrailingZeros(l2);
                long mask = 1L << (int)indexOfSetBit;
                if (!this.bytes.compareAndSwapLong(byteIndex, l2, l2 ^ mask)) continue;
                return indexOfSetBit;
            }
        }
        return -1L;
    }

    @Override
    public long nextSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long nextClearBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.bytes.readVolatileLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setNextClearBit(long fromIndex) {
        long w;
        long l;
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        while ((l = ((w = this.bytes.readVolatileLong(fromByteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex) != 0L) {
            long indexOfClearBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            if (!this.bytes.compareAndSwapLong(fromByteIndex, w, w ^ mask)) continue;
            return indexOfClearBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long w2;
            long l2;
            long byteIndex = i << 3;
            while ((l2 = (w2 = this.bytes.readLong(byteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                long indexOfClearBit = (i << 6) + (long)Long.numberOfTrailingZeros(l2);
                long mask = 1L << (int)indexOfClearBit;
                if (!this.bytes.compareAndSwapLong(byteIndex, w2, w2 ^ mask)) continue;
                return indexOfClearBit;
            }
        }
        return -1L;
    }

    @Override
    public long nextClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousSetBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = this.bytes.readVolatileLong(fromLongIndex << 3) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3);
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long clearPreviousSetBit(long fromIndex) {
        long w;
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        while ((l = (w = this.bytes.readVolatileLong(fromByteIndex)) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfSetBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfSetBit;
            if (!this.bytes.compareAndSwapLong(fromByteIndex, w, w ^ mask)) continue;
            return indexOfSetBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long l2;
            long byteIndex = i << 3;
            while ((l2 = this.bytes.readLong(byteIndex)) != 0L) {
                long indexOfSetBit = (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l2);
                long mask = 1L << (int)indexOfSetBit;
                if (!this.bytes.compareAndSwapLong(byteIndex, l2, l2 ^ mask)) continue;
                return indexOfSetBit;
            }
        }
        return -1L;
    }

    @Override
    public long previousSetLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != 0L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == 0L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long previousClearBit(long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        if ((l = (this.bytes.readVolatileLong(fromLongIndex << 3) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.bytes.readLong(i << 3) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public long setPreviousClearBit(long fromIndex) {
        long w;
        long l;
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex >> 6;
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.size() - 1L;
        }
        long fromByteIndex = fromLongIndex << 3;
        while ((l = ((w = this.bytes.readVolatileLong(fromByteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfClearBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = 1L << (int)indexOfClearBit;
            if (!this.bytes.compareAndSwapLong(fromByteIndex, w, w ^ mask)) continue;
            return indexOfClearBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long w2;
            long l2;
            long byteIndex = i << 3;
            while ((l2 = (w2 = this.bytes.readLong(byteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                long indexOfClearBit = (i << 6) + 63L - (long)Long.numberOfLeadingZeros(l2);
                long mask = 1L << (int)indexOfClearBit;
                if (!this.bytes.compareAndSwapLong(byteIndex, w2, w2 ^ mask)) continue;
                return indexOfClearBit;
            }
        }
        return -1L;
    }

    @Override
    public long previousClearLong(long fromLongIndex) {
        if (fromLongIndex < 0L) {
            if (fromLongIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
        }
        if (this.bytes.readVolatileLong(fromLongIndex << 3) != -1L) {
            return fromLongIndex;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            if (this.bytes.readLong(i << 3) == -1L) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.longLength << 6;
    }

    @Override
    public long cardinality() {
        long count = Long.bitCount(this.bytes.readVolatileLong(0L));
        for (long i = 1L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.bytes.readLong(i << 3));
        }
        return count;
    }

    @Override
    public DirectBitSet and(long longIndex, long value) {
        long l2;
        long l;
        while ((l = this.bytes.readVolatileLong(longIndex << 3)) != (l2 = l & value) && !this.bytes.compareAndSwapLong(longIndex << 3, l, l2)) {
        }
        return this;
    }

    @Override
    public DirectBitSet or(long longIndex, long value) {
        long l2;
        long l;
        while ((l = this.bytes.readVolatileLong(longIndex << 3)) != (l2 = l | value) && !this.bytes.compareAndSwapLong(longIndex << 3, l, l2)) {
        }
        return this;
    }

    @Override
    public DirectBitSet xor(long longIndex, long value) {
        long l2;
        long l;
        while (!this.bytes.compareAndSwapLong(longIndex << 3, l = this.bytes.readVolatileLong(longIndex << 3), l2 = l ^ value)) {
        }
        return this;
    }

    @Override
    public DirectBitSet andNot(long longIndex, long value) {
        long l2;
        long l;
        while (!this.bytes.compareAndSwapLong(longIndex << 3, l = this.bytes.readVolatileLong(longIndex << 3), l2 = l & (value ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
        return this;
    }

    private static long rightShiftOneFill(long l, long shift) {
        return l >> (int)shift | -1L >>> (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long setNextNContinuousClearBits(long fromIndex, int numberOfBits) {
        long l;
        long w;
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.setNextClearBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        int n64Complement = 64 - numberOfBits;
        long nTrailingOnes = -1L >>> n64Complement;
        long bitIndex = fromIndex;
        long longIndex = bitIndex >> 6;
        long byteIndex = longIndex << 3;
        if ((bitIndex & 0x3FL) > (long)n64Complement) {
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = longIndex << 6;
            l = w = this.bytes.readVolatileLong(byteIndex += 8L);
        } else {
            if (longIndex >= this.longLength) {
                return -1L;
            }
            w = this.bytes.readVolatileLong(byteIndex);
            l = ATSDirectBitSet.rightShiftOneFill(w, bitIndex);
        }
        while (true) {
            block16: {
                block15: {
                    int trailingOnes;
                    if ((l & 1L) == 0L) break block15;
                    long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex += (long)(trailingOnes = Long.numberOfTrailingZeros(x))) & 0x3FL) > (long)n64Complement) break block16;
                    l = ATSDirectBitSet.rightShiftOneFill(l, trailingOnes);
                }
                while (true) {
                    int trailingOnes;
                    if ((l & nTrailingOnes) == 0L) {
                        long mask = nTrailingOnes << (int)bitIndex;
                        if (this.bytes.compareAndSwapLong(byteIndex, w, w ^ mask)) {
                            return bitIndex;
                        }
                        w = this.bytes.readLong(byteIndex);
                        l = ATSDirectBitSet.rightShiftOneFill(w, bitIndex);
                        continue;
                    }
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    bitIndex += (long)trailingZeros;
                    long x = (l = ATSDirectBitSet.rightShiftOneFill(l, trailingZeros)) ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex += (long)(trailingOnes = Long.numberOfTrailingZeros(x))) & 0x3FL) > (long)n64Complement) break;
                    l >>= trailingOnes;
                }
            }
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = longIndex << 6;
            l = w = this.bytes.readLong(byteIndex += 8L);
        }
    }

    @Override
    public long clearNextNContinuousSetBits(long fromIndex, int numberOfBits) {
        long l;
        long w;
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.clearNextSetBit(fromIndex);
        }
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        int n64Complement = 64 - numberOfBits;
        long nTrailingOnes = -1L >>> n64Complement;
        long bitIndex = fromIndex;
        long longIndex = bitIndex >> 6;
        long byteIndex = longIndex << 3;
        if ((bitIndex & 0x3FL) > (long)n64Complement) {
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = longIndex << 6;
            l = w = this.bytes.readVolatileLong(byteIndex += 8L);
        } else {
            if (longIndex >= this.longLength) {
                return -1L;
            }
            w = this.bytes.readVolatileLong(byteIndex);
            l = w >>> (int)bitIndex;
        }
        while (true) {
            block16: {
                block15: {
                    int trailingZeros;
                    if ((l & 1L) != 0L) break block15;
                    if (l == 0L || ((bitIndex += (long)(trailingZeros = Long.numberOfTrailingZeros(l))) & 0x3FL) > (long)n64Complement) break block16;
                    l >>>= trailingZeros;
                }
                while (true) {
                    int trailingZeros;
                    if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nTrailingOnes) == 0L) {
                        long mask = nTrailingOnes << (int)bitIndex;
                        if (this.bytes.compareAndSwapLong(byteIndex, w, w ^ mask)) {
                            return bitIndex;
                        }
                        w = this.bytes.readLong(byteIndex);
                        l = w >>> (int)bitIndex;
                        continue;
                    }
                    int trailingOnes = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                    bitIndex += (long)trailingOnes;
                    if ((l >>>= trailingOnes) == 0L || ((bitIndex += (long)(trailingZeros = Long.numberOfTrailingZeros(l))) & 0x3FL) > (long)n64Complement) break;
                    l >>>= trailingZeros;
                }
            }
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = longIndex << 6;
            l = w = this.bytes.readLong(byteIndex += 8L);
        }
    }

    private static long leftShiftOneFill(long l, long shift) {
        return l << (int)shift | (1L << (int)shift) - 1L;
    }

    @Override
    public long setPreviousNContinuousClearBits(long fromIndex, int numberOfBits) {
        long l;
        long w;
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.setPreviousClearBit(fromIndex);
        }
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        int numberOfBitsMinusOne = numberOfBits - 1;
        long nLeadingOnes = -1L << 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex = bitIndex >> 6;
        if (longIndex >= this.longLength) {
            longIndex = this.longLength - 1L;
            bitIndex = (longIndex << 6) + 63L;
        }
        long byteIndex = longIndex << 3;
        if ((bitIndex & 0x3FL) < (long)numberOfBitsMinusOne) {
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = (longIndex << 6) + 63L;
            l = w = this.bytes.readVolatileLong(byteIndex -= 8L);
        } else {
            w = this.bytes.readVolatileLong(byteIndex);
            l = ATSDirectBitSet.leftShiftOneFill(w, bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        while (true) {
            block17: {
                block16: {
                    int leadingOnes;
                    if (l >= 0L) break block16;
                    long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex -= (long)(leadingOnes = Long.numberOfLeadingZeros(x))) & 0x3FL) < (long)numberOfBitsMinusOne) break block17;
                    l = ATSDirectBitSet.leftShiftOneFill(l, leadingOnes);
                }
                while (true) {
                    int leadingOnes;
                    if ((l & nLeadingOnes) == 0L) {
                        long mask = nLeadingOnes >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        if (this.bytes.compareAndSwapLong(byteIndex, w, w ^ mask)) {
                            return bitIndex - (long)numberOfBitsMinusOne;
                        }
                        w = this.bytes.readLong(byteIndex);
                        l = ATSDirectBitSet.leftShiftOneFill(w, bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        continue;
                    }
                    int leadingZeros = Long.numberOfLeadingZeros(l);
                    bitIndex -= (long)leadingZeros;
                    long x = (l = ATSDirectBitSet.leftShiftOneFill(l, leadingZeros)) ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex -= (long)(leadingOnes = Long.numberOfLeadingZeros(x))) & 0x3FL) < (long)numberOfBitsMinusOne) break;
                    l = ATSDirectBitSet.leftShiftOneFill(l, leadingOnes);
                }
            }
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = (longIndex << 6) + 63L;
            l = w = this.bytes.readLong(byteIndex -= 8L);
        }
    }

    @Override
    public long clearPreviousNContinuousSetBits(long fromIndex, int numberOfBits) {
        long l;
        long w;
        if (numberOfBits <= 0 || numberOfBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numberOfBits == 1) {
            return this.clearPreviousSetBit(fromIndex);
        }
        if (fromIndex < 0L) {
            if (fromIndex == -1L) {
                return -1L;
            }
            throw new IndexOutOfBoundsException();
        }
        int numberOfBitsMinusOne = numberOfBits - 1;
        long nLeadingOnes = -1L << 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex = bitIndex >> 6;
        if (longIndex >= this.longLength) {
            longIndex = this.longLength - 1L;
            bitIndex = (longIndex << 6) + 63L;
        }
        long byteIndex = longIndex << 3;
        if ((bitIndex & 0x3FL) < (long)numberOfBitsMinusOne) {
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = (longIndex << 6) + 63L;
            l = w = this.bytes.readVolatileLong(byteIndex -= 8L);
        } else {
            w = this.bytes.readVolatileLong(byteIndex);
            l = w << (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        while (true) {
            block17: {
                block18: {
                    block16: {
                        if (l <= 0L) break block16;
                        int leadingZeros = Long.numberOfLeadingZeros(l);
                        if (((bitIndex -= (long)leadingZeros) & 0x3FL) < (long)numberOfBitsMinusOne) break block17;
                        l <<= leadingZeros;
                        break block18;
                    }
                    if (l == 0L) break block17;
                }
                while (true) {
                    int leadingZeros;
                    if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nLeadingOnes) == 0L) {
                        long mask = nLeadingOnes >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        if (this.bytes.compareAndSwapLong(byteIndex, w, w ^ mask)) {
                            return bitIndex - (long)numberOfBitsMinusOne;
                        }
                        w = this.bytes.readLong(byteIndex);
                        l = w << (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        continue;
                    }
                    int leadingOnes = Long.numberOfLeadingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                    bitIndex -= (long)leadingOnes;
                    if ((l <<= leadingOnes) == 0L || ((bitIndex -= (long)(leadingZeros = Long.numberOfLeadingZeros(l))) & 0x3FL) < (long)numberOfBitsMinusOne) break;
                    l <<= leadingZeros;
                }
            }
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = (longIndex << 6) + 63L;
            l = w = this.bytes.readLong(byteIndex -= 8L);
        }
    }
}

