/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.lang.Maths;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.MutableDecimal;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.NoMarshaller;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes
implements Bytes {
    public static final long BUSY_LOCK_LIMIT = 10000000000L;
    public static final int INT_LOCK_MASK = 0xFFFFFF;
    public static final int UNSIGNED_BYTE_MASK = 255;
    public static final int UNSIGNED_SHORT_MASK = 65535;
    public static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    static final int MAX_NUMBER_LENGTH = 1 + (int)Math.ceil(Math.log10(9.223372036854776E18));
    private static final Logger LOGGER = Logger.getLogger(AbstractBytes.class.getName());
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final byte[] MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
    private static final byte[] Infinity = "Infinity".getBytes();
    private static final byte[] NaN = "NaN".getBytes();
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final byte BYTE_EXTENDED = -127;
    private static final byte BYTE_MAX_VALUE = -126;
    private static final short UBYTE_EXTENDED = 255;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final short SHORT_EXTENDED = -32767;
    private static final short SHORT_MAX_VALUE = -32766;
    private static final int USHORT_EXTENDED = 65535;
    private static final int INT_MIN_VALUE = Integer.MIN_VALUE;
    private static final int INT_EXTENDED = -2147483647;
    private static final int INT_MAX_VALUE = -2147483646;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final byte NULL = 78;
    private static final byte ENUMED = 69;
    private static final byte SERIALIZED = 83;
    static boolean ID_LIMIT_WARNED = false;
    private final byte[] numberBuffer = new byte[MAX_NUMBER_LENGTH];
    protected boolean finished = false;
    protected BytesMarshallerFactory bytesMarshallerFactory;
    private StringInterner stringInterner = null;
    private BytesInputStream inputStream = null;
    private BytesOutputStream outputStream = null;
    private StringBuilder utfReader = null;
    private SimpleDateFormat dateFormat = null;
    private long lastDay = Long.MIN_VALUE;
    @Nullable
    private byte[] lastDateStr = null;

    protected AbstractBytes() {
        this(new VanillaBytesMarshallerFactory());
    }

    protected AbstractBytes(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
    }

    protected StringInterner stringInterner() {
        if (this.stringInterner == null) {
            this.stringInterner = new StringInterner(8192);
        }
        return this.stringInterner;
    }

    @Override
    public Boolean parseBoolean(@NotNull StopCharTester tester) {
        StringBuilder sb = this.acquireUtfReader();
        this.parseUTF(sb, tester);
        if (sb.length() == 0) {
            return null;
        }
        switch (sb.charAt(0)) {
            case 'T': 
            case 't': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "true") ? Boolean.valueOf(true) : null;
            }
            case 'Y': 
            case 'y': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "yes") ? Boolean.valueOf(true) : null;
            }
            case '0': {
                return sb.length() == 1 ? Boolean.valueOf(false) : null;
            }
            case '1': {
                return sb.length() == 1 ? Boolean.valueOf(true) : null;
            }
            case 'F': 
            case 'f': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "false") ? Boolean.valueOf(false) : null;
            }
            case 'N': 
            case 'n': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "no") ? Boolean.valueOf(false) : null;
            }
        }
        return null;
    }

    static boolean equalsCaseIgnore(StringBuilder sb, String s) {
        if (sb.length() != s.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.toLowerCase(sb.charAt(i)) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    private static void warnIdLimit(long id) {
        LOGGER.log(Level.WARNING, "High thread id may result in collisions id: " + id);
        ID_LIMIT_WARNED = true;
    }

    @Override
    public void readFully(@NotNull byte[] bytes) {
        this.readFully(bytes, 0, bytes.length);
    }

    @Override
    public int skipBytes(int n) {
        long position = this.position();
        int n2 = (int)Math.min((long)n, this.capacity() - position);
        this.position(position + (long)n2);
        return n2;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public boolean readBoolean(long offset) {
        return this.readByte(offset) != 0;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    @NotNull
    public String readLine() {
        StringBuilder input = this.acquireUtfReader();
        block4: while (this.position() < this.capacity()) {
            int c = this.readUnsignedByte();
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    long cur = this.position();
                    if (cur >= this.capacity() || this.readByte(cur) != 10) break block4;
                    this.position(cur + 1L);
                    break block4;
                }
                default: {
                    input.append((char)c);
                    continue block4;
                }
            }
        }
        return this.stringInterner().intern(input);
    }

    @Override
    @Nullable
    public String readUTF\u0394() {
        if (this.readUTF\u0394(this.acquireUtfReader())) {
            return this.utfReader.length() == 0 ? "" : this.stringInterner().intern(this.utfReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String readUTF\u0394(long offset) throws IllegalStateException {
        long position = this.position();
        try {
            this.position(offset);
            String string = this.readUTF\u0394();
            return string;
        }
        finally {
            this.position(position);
        }
    }

    @NotNull
    private StringBuilder acquireUtfReader() {
        if (this.utfReader == null) {
            this.utfReader = new StringBuilder();
        } else {
            this.utfReader.setLength(0);
        }
        return this.utfReader;
    }

    @Override
    public boolean readUTF\u0394(@NotNull StringBuilder stringBuilder) {
        try {
            stringBuilder.setLength(0);
            return this.appendUTF0(stringBuilder);
        }
        catch (IOException unexpected) {
            throw new IllegalStateException(unexpected);
        }
    }

    private boolean appendUTF0(@NotNull Appendable appendable) throws IOException {
        long len = this.readStopBit();
        if (len < -1L || len > Integer.MAX_VALUE) {
            throw new StreamCorruptedException("UTF length invalid " + len);
        }
        if (len == -1L) {
            return false;
        }
        int utflen = (int)len;
        this.readUTF0(appendable, utflen);
        return true;
    }

    private void readUTF0(@NotNull Appendable appendable, int utflen) throws IOException {
        int c;
        int count;
        for (count = 0; count < utflen; ++count) {
            c = this.readByte();
            if (c < 0) {
                this.position(this.position() - 1L);
                break;
            }
            appendable.append((char)c);
        }
        block6: while (count < utflen) {
            c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
    }

    @Override
    @NotNull
    public String parseUTF(@NotNull StopCharTester tester) {
        this.parseUTF(this.acquireUtfReader(), tester);
        return this.stringInterner().intern(this.utfReader);
    }

    @Override
    public void parseUTF(@NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        builder.setLength(0);
        try {
            this.readUTF0((Appendable)builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readUTF0(@NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        int c;
        while (this.remaining() > 0L) {
            c = this.readByte();
            if (c < 0) {
                this.position(this.position() - 1L);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        block6: while (this.remaining() > 0L) {
            c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte ");
        }
    }

    @Override
    public boolean stepBackAndSkipTo(@NotNull StopCharTester tester) {
        if (this.position() > 0L) {
            this.position(this.position() - 1L);
        }
        return this.skipTo(tester);
    }

    @Override
    public boolean skipTo(@NotNull StopCharTester tester) {
        while (this.remaining() > 0L) {
            byte ch = this.readByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String readUTF() {
        try {
            int len = this.readUnsignedShort();
            this.readUTF0((Appendable)this.acquireUtfReader(), len);
            return this.utfReader.length() == 0 ? "" : this.stringInterner().intern(this.utfReader);
        }
        catch (IOException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    @Override
    public short readCompactShort() {
        byte b = this.readByte();
        switch (b) {
            case -128: {
                return Short.MIN_VALUE;
            }
            case -126: {
                return Short.MAX_VALUE;
            }
            case -127: {
                return this.readShort();
            }
        }
        return b;
    }

    @Override
    public int readCompactUnsignedShort() {
        int b = this.readUnsignedByte();
        if (b == 255) {
            return this.readUnsignedShort();
        }
        return b;
    }

    @Override
    public int readInt24() {
        int b = this.readUnsignedByte();
        int s = this.readUnsignedShort();
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (b << 24) + (s << 8) >> 8;
        }
        return (b << 8) + (s << 16) >> 8;
    }

    @Override
    public int readInt24(long offset) {
        int b = this.readUnsignedByte(offset);
        int s = this.readUnsignedShort(offset + 1L);
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (b << 24) + (s << 8) >> 8;
        }
        return (b << 8) + (s << 16) >> 8;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public int readCompactInt() {
        short b = this.readShort();
        switch (b) {
            case -32768: {
                return Integer.MIN_VALUE;
            }
            case -32766: {
                return Integer.MAX_VALUE;
            }
            case -32767: {
                return this.readInt();
            }
        }
        return b;
    }

    @Override
    public long readCompactUnsignedInt() {
        int b = this.readUnsignedShort();
        if (b == 65535) {
            return this.readUnsignedInt();
        }
        return b;
    }

    @Override
    public long readInt48() {
        long s = this.readUnsignedShort();
        long l = this.readUnsignedInt();
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (s << 48) + (l << 16) >> 16;
        }
        return (s << 16) + (l << 32) >> 16;
    }

    @Override
    public long readInt48(long offset) {
        long s = this.readUnsignedShort(offset);
        long l = this.readUnsignedInt(offset + 2L);
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (s << 48) + (l << 16) >> 16;
        }
        return (s << 16) + (l << 32) >> 16;
    }

    @Override
    public long readCompactLong() {
        int b = this.readInt();
        switch (b) {
            case -2147483648: {
                return Long.MIN_VALUE;
            }
            case -2147483646: {
                return Long.MAX_VALUE;
            }
            case -2147483647: {
                return this.readLong();
            }
        }
        return b;
    }

    @Override
    public long readStopBit() {
        long b;
        long l = 0L;
        int count = 0;
        while ((b = (long)this.readByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b == 0L && count > 0) {
            return l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l | b << count;
    }

    @Override
    public double readCompactDouble() {
        float f = this.readFloat();
        if (Float.isNaN(f)) {
            return this.readDouble();
        }
        return f;
    }

    @Override
    public void read(@NotNull ByteBuffer bb) {
        int len;
        if (bb.order() == this.byteOrder()) {
            for (len = (int)Math.min((long)bb.remaining(), this.remaining()); len >= 8; len -= 8) {
                bb.putLong(this.readLong());
            }
        }
        while (len > 0) {
            bb.put(this.readByte());
            --len;
        }
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        int length = bytes.length;
        this.checkWrite(length);
        this.write(bytes, 0, length);
    }

    private void checkWrite(int length) {
        if ((long)length > this.remaining()) {
            throw new IllegalStateException("Cannot write " + length + " only " + this.remaining() + " remaining");
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? -1 : 0);
    }

    @Override
    public void writeBoolean(long offset, boolean v) {
        this.writeByte(offset, v ? -1 : 0);
    }

    @Override
    public void writeBytes(@NotNull String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeChars(@NotNull String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(@NotNull String str) {
        long strlen = str.length();
        long utflen = this.findUTFLength(str, strlen);
        if (utflen > 65535L) {
            throw new IllegalStateException("String too long " + utflen + " when encoded, max: 65535");
        }
        this.writeUnsignedShort((int)utflen);
        this.writeUTF0(str, strlen);
    }

    @Override
    public void writeUTF\u0394(@Nullable CharSequence str) {
        if (str == null) {
            this.writeStopBit(-1L);
            return;
        }
        long strlen = str.length();
        long utflen = this.findUTFLength(str, strlen);
        this.writeStopBit(utflen);
        this.writeUTF0(str, strlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUTF\u0394(long offset, int maxSize, @Nullable CharSequence s) throws IllegalStateException {
        assert (maxSize > 1);
        if (s == null) {
            this.writeStopBit(-1L);
            return;
        }
        long strlen = s.length();
        long utflen = this.findUTFLength(s, strlen);
        long totalSize = (long)IOTools.stopBitLength(utflen) + utflen;
        if (totalSize > (long)maxSize) {
            throw new IllegalStateException("Attempted to write " + totalSize + " byte String, when only " + maxSize + " allowed");
        }
        long position = this.position();
        try {
            this.position(offset);
            this.writeStopBit(utflen);
            this.writeUTF0(s, strlen);
        }
        finally {
            this.position(position);
        }
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence str) {
        if (str == null) {
            return this;
        }
        long strlen = str.length();
        this.writeUTF0(str, strlen);
        return this;
    }

    private long findUTFLength(@NotNull CharSequence str, long strlen) {
        long utflen = 0L;
        int i = 0;
        while ((long)i < strlen) {
            long c = str.charAt(i);
            utflen = c >= 1L && c <= 127L ? ++utflen : (c > 2047L ? (utflen += 3L) : (utflen += 2L));
            ++i;
        }
        if (utflen > this.remaining()) {
            throw new IllegalArgumentException("encoded string too long: " + utflen + " bytes, remaining=" + this.remaining());
        }
        return utflen;
    }

    private void writeUTF0(@NotNull CharSequence str, long strlen) {
        char c;
        int i = 0;
        while ((long)i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f') {
            this.write(c);
            ++i;
        }
        while ((long)i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write((byte)(0xE0 | c >> 12 & 0xF));
                this.write((byte)(0x80 | c >> 6 & 0x3F));
                this.write((byte)(0x80 | c & 0x3F));
            } else {
                this.write((byte)(0xC0 | c >> 6 & 0x1F));
                this.write((byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeUnsignedByte(int v) {
        this.writeByte(v);
    }

    @Override
    public void writeUnsignedByte(long offset, int v) {
        this.writeByte(offset, v);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        this.checkWrite(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            this.writeByte(offset + (long)i, bytes[i]);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.checkWrite(bytes.length);
        for (int i = 0; i < len; ++i) {
            this.write(bytes[off + i]);
        }
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeUnsignedShort(long offset, int v) {
        this.writeShort(offset, v);
    }

    @Override
    public void writeCompactShort(int v) {
        if (v > -126 && v <= 127) {
            this.writeByte(v);
        } else {
            switch (v) {
                case -32768: {
                    this.writeByte(-128);
                    break;
                }
                case 32767: {
                    this.writeByte(-126);
                    break;
                }
                default: {
                    this.writeByte(-127);
                    this.writeShort(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedShort(int v) {
        if (v >= 0 && v < 65535) {
            this.writeByte(v);
        } else {
            this.writeUnsignedShort(65535);
            this.writeUnsignedShort(v);
        }
    }

    @Override
    public void writeInt24(int v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(v >>> 16);
            this.writeUnsignedShort(v);
        } else {
            this.writeUnsignedByte(v);
            this.writeUnsignedShort(v >>> 8);
        }
    }

    @Override
    public void writeInt24(long offset, int v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(offset, v >>> 16);
            this.writeUnsignedShort(offset + 1L, v);
        } else {
            this.writeUnsignedByte(offset, v);
            this.writeUnsignedShort(offset + 1L, v >>> 8);
        }
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.writeInt((int)v);
    }

    @Override
    public void writeUnsignedInt(long offset, long v) {
        this.writeInt(offset, (int)v);
    }

    @Override
    public void writeCompactInt(int v) {
        if (v > -32766 && v <= Short.MAX_VALUE) {
            this.writeShort(v);
        } else {
            switch (v) {
                case -2147483648: {
                    this.writeShort(Short.MIN_VALUE);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.writeShort(-32766);
                    break;
                }
                default: {
                    this.writeShort(-32767);
                    this.writeInt(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedInt(long v) {
        if (v >= 0L && v < 65535L) {
            this.writeShort((int)v);
        } else {
            this.writeShort(65535);
            this.writeUnsignedInt(v);
        }
    }

    @Override
    public void writeInt48(long v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort((int)(v >>> 32));
            this.writeUnsignedInt(v);
        } else {
            this.writeUnsignedShort((int)v);
            this.writeUnsignedInt(v >>> 16);
        }
    }

    @Override
    public void writeInt48(long offset, long v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort(offset, (int)(v >>> 32));
            this.writeUnsignedInt(offset + 2L, v);
        } else {
            this.writeUnsignedShort(offset, (int)v);
            this.writeUnsignedInt(offset + 2L, v >>> 16);
        }
    }

    @Override
    public void writeCompactLong(long v) {
        if (v > -2147483646L && v <= Integer.MAX_VALUE) {
            this.writeInt((int)v);
        } else if (v == Long.MIN_VALUE) {
            this.writeInt(Integer.MIN_VALUE);
        } else if (v == Long.MAX_VALUE) {
            this.writeInt(-2147483646);
        } else {
            this.writeInt(-2147483647);
            this.writeLong(v);
        }
    }

    @Override
    public void writeStopBit(long n) {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            this.writeByte((byte)(0x80L | n & 0x7FL));
            n = n2;
        }
        if (neg) {
            this.writeByte((byte)(0x80L | n & 0x7FL));
            this.writeByte(0);
        } else {
            this.writeByte((byte)(n & 0x7FL));
        }
    }

    @Override
    public void writeCompactDouble(double v) {
        float f = (float)v;
        if ((double)f == v) {
            this.writeFloat(f);
        } else {
            this.writeFloat(Float.NaN);
            this.writeDouble(v);
        }
    }

    @Override
    public void write(@NotNull ByteBuffer bb) {
        if (bb.order() == this.byteOrder()) {
            while (bb.remaining() >= 8) {
                this.writeLong(bb.getLong());
            }
        }
        while (bb.remaining() >= 1) {
            this.writeByte(bb.get());
        }
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence s, int start, int end) {
        int len = Math.min(end, s.length());
        for (int i = start; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(@Nullable Enum value) {
        return value == null ? this : this.append(value.toString());
    }

    @Override
    @NotNull
    public ByteStringAppender append(boolean b) {
        this.append(b ? "true" : "false");
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(char c) {
        this.writeByte(c);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(int num) {
        return this.append((long)num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                this.write(MIN_VALUE_TEXT);
                return this;
            }
            this.writeByte(45);
            num = -num;
        }
        if (num == 0L) {
            this.writeByte(48);
        } else {
            this.appendLong0(num);
        }
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateMillis(long timeInMS) {
        long date;
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if (this.lastDay != (date = timeInMS / 86400000L)) {
            this.lastDateStr = this.dateFormat.format(new Date(timeInMS)).getBytes(ISO_8859_1);
            this.lastDay = date;
        } else assert (this.lastDateStr != null);
        this.write(this.lastDateStr);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateTimeMillis(long timeInMS) {
        this.appendDateMillis(timeInMS);
        this.writeByte(84);
        this.appendTimeMillis(timeInMS % 86400000L);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendTimeMillis(long timeInMS) {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            this.appendLong0(hours);
        } else {
            this.writeByte((char)(hours / 10 + 48));
            this.writeByte((char)(hours % 10 + 48));
        }
        this.writeByte(58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        this.writeByte((char)(minutes / 10 + 48));
        this.writeByte((char)(minutes % 10 + 48));
        this.writeByte(58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        this.writeByte((char)(seconds / 10 + 48));
        this.writeByte((char)(seconds % 10 + 48));
        this.writeByte(46);
        int millis = (int)(timeInMS % 1000L);
        this.writeByte((char)(millis / 100 + 48));
        this.writeByte((char)(millis / 10 % 10 + 48));
        this.writeByte((char)(millis % 10 + 48));
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            this.writeByte(45);
        }
        if (exp == 0 && mantissa == 0L) {
            this.writeByte(48);
            return this;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                this.write(Infinity);
            } else {
                this.write(NaN);
            }
            return this;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                this.appendLong0(intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    this.writeByte(46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        this.writeByte((char)(48L + num));
                        double parsedValue = AbstractBytes.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return this;
            }
            this.writeByte(48);
            this.writeByte(46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    this.writeByte(48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                this.writeByte(c);
                mantissa -= num << precision;
                double parsedValue = AbstractBytes.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return this;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        this.appendLong0(val2);
        for (int i = 0; i < digits; ++i) {
            this.writeByte(48);
        }
        return this;
    }

    @Override
    public double parseDouble() {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        while (true) {
            byte ch;
            if ((ch = this.readByte()) >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
                continue;
            }
            if (ch == 45) {
                negative = true;
                continue;
            }
            if (ch != 46) break;
            decimalPlaces = 0;
        }
        return AbstractBytes.asDouble(value, exp, negative, decimalPlaces);
    }

    @Override
    @NotNull
    public <E> ByteStringAppender append(@NotNull Iterable<E> list, @NotNull CharSequence separator) {
        if (list instanceof RandomAccess && list instanceof List) {
            return this.append((List)list, separator);
        }
        int i = 0;
        for (E e : list) {
            if (i++ > 0) {
                this.append(separator);
            }
            if (e == null) continue;
            this.append(e.toString());
        }
        return this;
    }

    @NotNull
    public <E> ByteStringAppender append(@NotNull List<E> list, @NotNull CharSequence separator) {
        for (int i = 0; i < list.size(); ++i) {
            E e;
            if (i > 0) {
                this.append(separator);
            }
            if ((e = list.get(i)) == null) continue;
            this.append(e.toString());
        }
        return this;
    }

    @Override
    @NotNull
    public MutableDecimal parseDecimal(@NotNull MutableDecimal decimal) {
        long num = 0L;
        long scale = Long.MIN_VALUE;
        boolean negative = false;
        while (true) {
            byte b;
            if ((b = this.readByte()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                ++scale;
                continue;
            }
            if (b == 46) {
                scale = 0L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        if (negative) {
            num = -num;
        }
        decimal.set(num, scale > 0L ? (int)scale : 0);
        return decimal;
    }

    @Override
    public long parseLong() {
        long num = 0L;
        boolean negative = false;
        while (true) {
            byte b;
            if ((b = this.readByte()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    private void appendLong0(long num) {
        int endIndex = this.appendLong1(num);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendLong1(long num) {
        this.numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        this.numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        this.numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        this.numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        this.numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        this.numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        this.numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        this.numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        this.numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        this.numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        this.numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        this.numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        this.numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        this.numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        this.numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        this.numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        this.numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        this.numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        this.numberBuffer[1] = (byte)(num % 10L + 48L);
        num /= 10L;
        return 1;
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d, int precision) {
        double d2;
        long power10;
        if (precision < 0) {
            precision = 0;
        }
        if ((power10 = Maths.power10(precision)) < 0L) {
            power10 = 100000000000000000L;
        }
        if (d < 0.0) {
            d = -d;
            this.writeByte(45);
        }
        if ((d2 = d * (double)power10) > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            return this.append(d);
        }
        long val = (long)(d2 + 0.5);
        while (precision > 1 && val % 10L == 0L) {
            val /= 10L;
            --precision;
        }
        if (precision > 0 && val % 10L == 0L) {
            val = (val + 5L) / 10L;
            --precision;
        }
        if (precision > 0) {
            this.appendDouble0(val, precision);
        } else {
            this.appendLong0(val);
        }
        return this;
    }

    private void appendDouble0(long num, int precision) {
        int endIndex = this.appendDouble1(num, precision);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendDouble1(long num, int precision) {
        int endIndex = MAX_NUMBER_LENGTH;
        int maxEnd = MAX_NUMBER_LENGTH - precision - 2;
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 1) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 2) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 3) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 4) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 5) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 6) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 7) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 8) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 9) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 10) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 11) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 12) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 13) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 14) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 15) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 16) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 17) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 18) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        return endIndex;
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull MutableDecimal md) {
        StringBuilder sb = this.acquireUtfReader();
        md.toString(sb);
        this.append(sb);
        return this;
    }

    @Override
    @NotNull
    public InputStream inputStream() {
        if (this.inputStream == null) {
            this.inputStream = new BytesInputStream();
        }
        return this.inputStream;
    }

    @Override
    @NotNull
    public OutputStream outputStream() {
        if (this.outputStream == null) {
            this.outputStream = new BytesOutputStream();
        }
        return this.outputStream;
    }

    @Override
    @NotNull
    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory;
    }

    @Override
    public <E> void writeEnum(@Nullable E e) {
        Class aClass = e == null || e instanceof CharSequence ? String.class : e.getClass();
        BytesMarshaller<String> em = this.bytesMarshallerFactory().acquireMarshaller(aClass, true);
        em.write(this, (String)e);
    }

    @Override
    public <E> E readEnum(@NotNull Class<E> eClass) {
        BytesMarshaller<E> em = this.bytesMarshallerFactory().acquireMarshaller(eClass, true);
        return em.read(this);
    }

    @Override
    public <E extends Enum<E>> E parseEnum(@NotNull Class<E> eClass, @NotNull StopCharTester tester) {
        String text = this.parseUTF(tester);
        if (text.isEmpty()) {
            return null;
        }
        return Enum.valueOf(eClass, text);
    }

    @Override
    public <E> void writeList(@NotNull Collection<E> list) {
        this.writeStopBit(list.size());
        for (E e : list) {
            this.writeEnum(e);
        }
    }

    @Override
    public <K, V> void writeMap(@NotNull Map<K, V> map) {
        this.writeStopBit(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeEnum(entry.getKey());
            this.writeEnum(entry.getValue());
        }
    }

    @Override
    public <E> void readList(@NotNull Collection<E> list, @NotNull Class<E> eClass) {
        int len = (int)this.readStopBit();
        list.clear();
        for (int i = 0; i < len; ++i) {
            E e = this.readEnum(eClass);
            list.add(e);
        }
    }

    @Override
    public <K, V> void readMap(@NotNull Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass) {
        int len = (int)this.readStopBit();
        map.clear();
        for (int i = 0; i < len; ++i) {
            map.put(this.readEnum(kClass), this.readEnum(vClass));
        }
    }

    @Override
    public int available() {
        return (int)Math.min(Integer.MAX_VALUE, this.remaining());
    }

    @Override
    public int read() {
        return this.remaining() > 0L ? (int)this.readByte() : -1;
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public abstract int read(@NotNull byte[] var1, int var2, int var3);

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Skip bytes out of range, was " + n);
        }
        if (n > this.remaining()) {
            n = this.remaining();
        }
        this.skipBytes((int)n);
        return n;
    }

    @Override
    public void close() {
        if (!this.isFinished()) {
            this.finish();
        }
    }

    @Override
    public void finish() throws IndexOutOfBoundsException {
        if (this.remaining() < 0L) {
            this.throwOverflow();
        }
        this.finished = true;
    }

    private void throwOverflow() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Buffer overflow, capacity: " + this.capacity() + " position: " + this.position());
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void reset() {
        this.finished = false;
        this.position(0L);
    }

    @Override
    public void flush() {
        this.checkEndOfBuffer();
    }

    @Override
    @Nullable
    public Object readObject() {
        byte type = this.readByte();
        switch (type) {
            case 78: {
                return null;
            }
            case 69: {
                Class clazz = this.readEnum(Class.class);
                return this.readEnum(clazz);
            }
            case 83: {
                try {
                    return new ObjectInputStream(this.inputStream()).readObject();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalStateException("Unknown type " + (char)type);
    }

    @Override
    @Nullable
    public <T> T readObject(Class<T> tClass) throws IllegalStateException {
        Object o = this.readObject();
        if (o == null || tClass.isInstance(o)) {
            return (T)o;
        }
        throw new ClassCastException("Cannot convert " + o.getClass().getName() + " to " + tClass.getName() + " was " + o);
    }

    @Override
    public void writeObject(@Nullable Object obj) {
        if (obj == null) {
            this.writeByte(78);
            return;
        }
        Class<?> clazz = obj.getClass();
        BytesMarshaller<?> em = this.bytesMarshallerFactory.acquireMarshaller(clazz, false);
        if (em == NoMarshaller.INSTANCE && this.autoGenerateMarshaller(obj)) {
            em = this.bytesMarshallerFactory.acquireMarshaller(clazz, true);
        }
        if (em != NoMarshaller.INSTANCE) {
            this.writeByte(69);
            this.writeEnum(clazz);
            em.write(this, obj);
            return;
        }
        this.writeByte(83);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.outputStream());
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.checkEndOfBuffer();
    }

    private boolean autoGenerateMarshaller(Object obj) {
        return obj instanceof Comparable && obj.getClass().getPackage().getName().startsWith("java") || obj instanceof Externalizable || obj instanceof BytesMarshallable;
    }

    @Override
    public boolean tryLockInt(long offset) {
        long id = Thread.currentThread().getId();
        if (!ID_LIMIT_WARNED && id > 0x1000000L) {
            AbstractBytes.warnIdLimit(id);
        }
        return this.tryLockNanos4a(offset, (int)id);
    }

    @Override
    public boolean tryLockNanosInt(long offset, long nanos) {
        long id = Thread.currentThread().getId();
        if (!ID_LIMIT_WARNED && id > 0x1000000L) {
            AbstractBytes.warnIdLimit(id);
        }
        int limit = nanos <= 10000L ? (int)nanos / 10 : 1000;
        for (int i = 0; i < limit; ++i) {
            if (!this.tryLockNanos4a(offset, (int)id)) continue;
            return true;
        }
        if (nanos <= 10000L) {
            return false;
        }
        long end = System.nanoTime() + nanos - 10000L;
        do {
            if (!this.tryLockNanos4a(offset, (int)id)) continue;
            return true;
        } while (end > System.nanoTime() && !Thread.currentThread().isInterrupted());
        return false;
    }

    private boolean tryLockNanos4a(long offset, int id) {
        int lowId = id & 0xFFFFFF;
        int firstValue = 0x1000000 | lowId;
        if (this.compareAndSetInt(offset, 0, firstValue)) {
            return true;
        }
        long currentValue = this.readUnsignedInt(offset);
        if ((currentValue & 0xFFFFFFL) == (long)lowId) {
            if (currentValue >= 0xFF000000L) {
                throw new IllegalStateException("Reentred 255 times without an unlock");
            }
            this.writeOrderedInt(offset, (int)(currentValue += 0x1000000L));
        }
        return false;
    }

    @Override
    public void busyLockInt(long offset) throws InterruptedException, IllegalStateException {
        boolean success = this.tryLockNanosInt(offset, 10000000000L);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (!success) {
            throw new IllegalStateException("Failed to acquire lock after 10.0 seconds.");
        }
    }

    @Override
    public void unlockInt(long offset) throws IllegalMonitorStateException {
        int lowId = (int)Thread.currentThread().getId() & 0xFFFFFF;
        int firstValue = 0x1000000 | lowId;
        if (this.compareAndSetInt(offset, firstValue, 0)) {
            return;
        }
        this.unlockFailed(offset, lowId);
    }

    private void unlockFailed(long offset, int lowId) throws IllegalMonitorStateException {
        long currentValue = this.readUnsignedInt(offset);
        long holderId = currentValue & 0xFFFFFFL;
        if (holderId != (long)lowId) {
            if (currentValue == 0L) {
                throw new IllegalMonitorStateException("No thread holds this lock");
            }
            throw new IllegalMonitorStateException("Thread " + holderId + " holds this lock, " + (currentValue >>> 24) + " times");
        }
        this.writeOrderedInt(offset, (int)(currentValue -= 0x1000000L));
    }

    @Override
    public int getAndAdd(long offset, int delta) {
        int next;
        int current;
        while (!this.compareAndSetInt(offset, current = this.readVolatileInt(offset), next = current + delta)) {
        }
        return current;
    }

    @Override
    public int addAndGetInt(long offset, int delta) {
        int next;
        int current;
        while (!this.compareAndSetInt(offset, current = this.readVolatileInt(offset), next = current + delta)) {
        }
        return next;
    }

    protected class BytesOutputStream
    extends OutputStream {
        protected BytesOutputStream() {
        }

        @Override
        public void close() throws IOException {
            AbstractBytes.this.finish();
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            AbstractBytes.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractBytes.this.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            AbstractBytes.this.checkWrite(1);
            AbstractBytes.this.writeUnsignedByte(b);
        }
    }

    protected class BytesInputStream
    extends InputStream {
        private long mark = 0L;

        protected BytesInputStream() {
        }

        @Override
        public int available() throws IOException {
            long remaining = AbstractBytes.this.remaining();
            return (int)Math.min(Integer.MAX_VALUE, remaining);
        }

        @Override
        public void close() throws IOException {
            AbstractBytes.this.finish();
        }

        @Override
        public void mark(int readlimit) {
            this.mark = AbstractBytes.this.position();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return AbstractBytes.this.read(b, off, len);
        }

        @Override
        public void reset() throws IOException {
            AbstractBytes.this.position(this.mark);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                throw new IOException("Skip too large");
            }
            return AbstractBytes.this.skipBytes((int)n);
        }

        @Override
        public int read() throws IOException {
            if (AbstractBytes.this.remaining() > 0L) {
                return AbstractBytes.this.readUnsignedByte();
            }
            return -1;
        }
    }
}

