/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.BytesMarshallerFactory;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NativeBytes
extends AbstractBytes {
    @NotNull
    protected static final Unsafe UNSAFE;
    static final int BYTES_OFFSET;
    protected long startAddr;
    protected long positionAddr;
    protected long limitAddr;

    public NativeBytes(long startAddr, long positionAddr, long limitAddr) {
        this.startAddr = startAddr;
        this.positionAddr = positionAddr;
        this.limitAddr = limitAddr;
    }

    public NativeBytes(BytesMarshallerFactory bytesMarshallerFactory, long startAddr, long positionAddr, long limitAddr) {
        super(bytesMarshallerFactory);
        this.startAddr = startAddr;
        this.positionAddr = positionAddr;
        this.limitAddr = limitAddr;
    }

    public static long longHash(byte[] bytes, int off, int len) {
        int pos;
        long hash = 0L;
        for (pos = 0; pos < len - 7; pos += 8) {
            hash = hash * 10191L + UNSAFE.getLong(bytes, (long)BYTES_OFFSET + (long)off + (long)pos);
        }
        while (pos < len) {
            hash = hash * 57L + (long)bytes[off + pos];
            ++pos;
        }
        return hash;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, left);
        UNSAFE.copyMemory(null, this.positionAddr, bytes, BYTES_OFFSET + off, len2);
        this.positionAddr += (long)len2;
        return len2;
    }

    @Override
    public byte readByte() {
        return UNSAFE.getByte(this.positionAddr++);
    }

    @Override
    public byte readByte(long offset) {
        return UNSAFE.getByte(this.startAddr + offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        UNSAFE.copyMemory(null, this.positionAddr, b, BYTES_OFFSET + off, len);
        this.positionAddr += (long)len;
    }

    @Override
    public short readShort() {
        short s = UNSAFE.getShort(this.positionAddr);
        this.positionAddr += 2L;
        return s;
    }

    @Override
    public short readShort(long offset) {
        return UNSAFE.getShort(this.startAddr + offset);
    }

    @Override
    public char readChar() {
        char ch = UNSAFE.getChar(this.positionAddr);
        this.positionAddr += 2L;
        return ch;
    }

    @Override
    public char readChar(long offset) {
        return UNSAFE.getChar(this.startAddr + offset);
    }

    @Override
    public int readInt() {
        int i = UNSAFE.getInt(this.positionAddr);
        this.positionAddr += 4L;
        return i;
    }

    @Override
    public int readInt(long offset) {
        return UNSAFE.getInt(this.startAddr + offset);
    }

    @Override
    public int readVolatileInt() {
        int i = UNSAFE.getIntVolatile(null, this.positionAddr);
        this.positionAddr += 4L;
        return i;
    }

    @Override
    public int readVolatileInt(long offset) {
        return UNSAFE.getIntVolatile(null, this.startAddr + offset);
    }

    @Override
    public long readLong() {
        long l = UNSAFE.getLong(this.positionAddr);
        this.positionAddr += 8L;
        return l;
    }

    @Override
    public long readLong(long offset) {
        return UNSAFE.getLong(this.startAddr + offset);
    }

    @Override
    public long readVolatileLong() {
        long l = UNSAFE.getLongVolatile(null, this.positionAddr);
        this.positionAddr += 8L;
        return l;
    }

    @Override
    public long readVolatileLong(long offset) {
        return UNSAFE.getLongVolatile(null, this.startAddr + offset);
    }

    @Override
    public float readFloat() {
        float f = UNSAFE.getFloat(this.positionAddr);
        this.positionAddr += 4L;
        return f;
    }

    @Override
    public float readFloat(long offset) {
        return UNSAFE.getFloat(this.startAddr + offset);
    }

    @Override
    public double readDouble() {
        double d = UNSAFE.getDouble(this.positionAddr);
        this.positionAddr += 8L;
        return d;
    }

    @Override
    public double readDouble(long offset) {
        return UNSAFE.getDouble(this.startAddr + offset);
    }

    @Override
    public void write(int b) {
        UNSAFE.putByte(this.positionAddr++, (byte)b);
    }

    @Override
    public void writeByte(long offset, int b) {
        UNSAFE.putByte(this.startAddr + offset, (byte)b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        UNSAFE.copyMemory(bytes, BYTES_OFFSET, null, this.positionAddr, bytes.length);
        this.positionAddr += (long)bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        UNSAFE.copyMemory(bytes, BYTES_OFFSET + off, null, this.positionAddr, len);
        this.positionAddr += (long)len;
    }

    @Override
    public void writeShort(int v) {
        UNSAFE.putShort(this.positionAddr, (short)v);
        this.positionAddr += 2L;
    }

    @Override
    public void writeShort(long offset, int v) {
        UNSAFE.putShort(this.startAddr + offset, (short)v);
    }

    @Override
    public void writeChar(int v) {
        UNSAFE.putChar(this.positionAddr, (char)v);
        this.positionAddr += 2L;
    }

    @Override
    public void writeChar(long offset, int v) {
        UNSAFE.putChar(this.startAddr + offset, (char)v);
    }

    @Override
    public void writeInt(int v) {
        UNSAFE.putInt(null, this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeInt(long offset, int v) {
        UNSAFE.putInt(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        UNSAFE.putOrderedInt(null, this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        UNSAFE.putOrderedInt(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSetInt(long offset, int expected, int x) {
        return UNSAFE.compareAndSwapInt(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        UNSAFE.putLong(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeLong(long offset, long v) {
        UNSAFE.putLong(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        UNSAFE.putOrderedLong(null, this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        UNSAFE.putOrderedLong(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSetLong(long offset, long expected, long x) {
        return UNSAFE.compareAndSwapLong(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        UNSAFE.putFloat(this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeFloat(long offset, float v) {
        UNSAFE.putFloat(this.startAddr + offset, v);
    }

    @Override
    public void writeDouble(double v) {
        UNSAFE.putDouble(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeDouble(long offset, double v) {
        UNSAFE.putDouble(this.startAddr + offset, v);
    }

    @Override
    public long position() {
        return this.positionAddr - this.startAddr;
    }

    @Override
    public void position(long position) {
        this.positionAddr = this.startAddr + position;
    }

    @Override
    public long capacity() {
        return this.limitAddr - this.startAddr;
    }

    @Override
    public long remaining() {
        return this.limitAddr - this.positionAddr;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

