/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;

public class DirectBytes
extends NativeBytes {
    @NotNull
    private final DirectStore store;

    DirectBytes(@NotNull DirectStore store) {
        super(store.bytesMarshallerFactory, store.address, store.address, store.address + store.size);
        this.store = store;
    }

    public void positionAndSize(long offset, long size) {
        if (offset < 0L || size < 0L || offset + size > this.store.size) {
            throw new IllegalArgumentException();
        }
        this.startAddr = this.positionAddr = this.store.address + offset;
        this.limitAddr = this.startAddr + size;
    }

    public void positionAndSize(@NotNull DirectBytes bytes, long size) {
        long start2 = bytes.positionAddr;
        long end2 = start2 + size;
        if (end2 > this.limitAddr) {
            throw new IllegalArgumentException("Slice offset and size too large");
        }
        this.startAddr = this.positionAddr = start2;
        this.limitAddr = end2;
    }

    public void positionAndSize(@NotNull DirectBytes bytes, long offset, long size) {
        long start2 = bytes.startAddr + offset;
        long end2 = start2 + size;
        if (end2 > this.limitAddr) {
            throw new IllegalArgumentException("Slice offset and size too large");
        }
        this.startAddr = this.positionAddr = start2;
        this.limitAddr = end2;
    }
}

