/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

public class Maths {
    public static final double WHOLE_NUMBER = 9.007199254740992E15;
    private static final long[] TENS = new long[19];

    public static double round2(double d) {
        double factor = 100.0;
        return d > 9.007199254740992E15 || d < -9.007199254740992E15 ? (double)((long)(d < 0.0 ? d * 100.0 - 0.5 : d * 100.0 + 0.5)) / 100.0 : d;
    }

    public static double round4(double d) {
        double factor = 10000.0;
        return d > 9.223372036854776E14 || d < -9.223372036854776E14 ? (double)((long)(d < 0.0 ? d * 10000.0 - 0.5 : d * 10000.0 + 0.5)) / 10000.0 : d;
    }

    public static double round6(double d) {
        double factor = 1000000.0;
        return d > 9.223372036854775E12 || d < -9.223372036854775E12 ? (double)((long)(d < 0.0 ? d * 1000000.0 - 0.5 : d * 1000000.0 + 0.5)) / 1000000.0 : d;
    }

    public static double round8(double d) {
        double factor = 1.0E8;
        return d > 9.223372036854776E10 || d < -9.223372036854776E10 ? (double)((long)(d < 0.0 ? d * 1.0E8 - 0.5 : d * 1.0E8 + 0.5)) / 1.0E8 : d;
    }

    public static long power10(int n) {
        if (n < 0 || n >= TENS.length) {
            return -1L;
        }
        return TENS[n];
    }

    public static int nextPower2(int n, int min) {
        if (n < min) {
            return min;
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        int i = min;
        while (i < n) {
            if ((i *= 2) > 0) continue;
            return 0x40000000;
        }
        return i;
    }

    public static int hash(int n) {
        n ^= n >> 21 ^ n >> 11;
        n ^= n >> 7 ^ n >> 4;
        return n;
    }

    public static int hash(long n) {
        n ^= n >> 43 ^ n >> 21;
        n ^= n >> 15 ^ n >> 7;
        return (int)n;
    }

    static {
        Maths.TENS[0] = 1L;
        for (int i = 1; i < TENS.length; ++i) {
            Maths.TENS[i] = TENS[i - 1] * 10L;
        }
    }
}

