/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMarshaller
implements BytesMarshaller<String> {
    private final int size;
    private final StringBuilder reader = new StringBuilder();
    private StringInterner interner;

    public StringMarshaller(int size) {
        this.size = size;
    }

    @Override
    public void write(@NotNull Bytes bytes, String s) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/StringMarshaller.write must not be null");
        }
        bytes.writeUTF\u0394(s);
    }

    @Override
    @Nullable
    public String read(@NotNull Bytes bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/StringMarshaller.read must not be null");
        }
        if (bytes.readUTF\u0394(this.reader)) {
            return this.builderToString();
        }
        return null;
    }

    private String builderToString() {
        if (this.interner == null) {
            this.interner = new StringInterner(this.size);
        }
        return this.interner.intern(this.reader);
    }
}

