/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.StopCharTester;
import org.jetbrains.annotations.NotNull;

public enum StopCharTesters implements StopCharTester
{
    CONTROL_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32;
        }
    }
    ,
    SPACE_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return Character.isWhitespace(ch) || ch == 0;
        }
    }
    ,
    XML_TEXT{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 34 || ch == 60 || ch == 62 || ch == 0;
        }
    }
    ,
    FIX_TEXT{

        @Override
        public boolean isStopChar(int ch) {
            return ch <= 1;
        }
    };


    @NotNull
    public static StopCharTester forChars(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/StopCharTesters.forChars must not be null");
        }
        if (sequence.length() == 1) {
            StopCharTester stopCharTester = StopCharTesters.forChar(sequence.charAt(0));
            if (stopCharTester == null) {
                throw new IllegalStateException("@NotNull method net/openhft/lang/io/StopCharTesters.forChars must not return null");
            }
            return stopCharTester;
        }
        CSCSTester cSCSTester = new CSCSTester(sequence);
        if (cSCSTester == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/io/StopCharTesters.forChars must not return null");
        }
        return cSCSTester;
    }

    @NotNull
    public static StopCharTester forChar(char ch) {
        CharCSTester charCSTester = new CharCSTester(ch);
        if (charCSTester == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/io/StopCharTesters.forChar must not return null");
        }
        return charCSTester;
    }

    static class CharCSTester
    implements StopCharTester {
        private final char ch;

        public CharCSTester(char ch) {
            this.ch = ch;
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.ch == ch;
        }
    }

    static class CSCSTester
    implements StopCharTester {
        @NotNull
        private final String seperators;

        public CSCSTester(@NotNull CharSequence cs) {
            if (cs == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/StopCharTesters$CSCSTester.<init> must not be null");
            }
            this.seperators = cs.toString();
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.seperators.indexOf(ch) >= 0;
        }
    }
}

