/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.jlbh;

import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PercentileSummary {
    private final boolean skipFirst;
    private final List<double[]> percentileRuns;
    private final double[] percentiles;

    public PercentileSummary(boolean skipFirst, @NotNull List<double[]> percentileRuns, double[] percentiles) {
        this.skipFirst = skipFirst;
        this.percentileRuns = percentileRuns;
        this.percentiles = percentiles;
    }

    public void printSummary() {
        System.out.print("    %ile    ");
        for (int i = 0; i < this.percentileRuns.size(); ++i) {
            System.out.printf("%10d", i);
        }
        System.out.println("    var   ");
        this.forEachRow((percentile, values, variance) -> {
            System.out.printf("%10f: ", percentile);
            for (double value : values) {
                System.out.printf("%10f", value);
            }
            System.out.printf("%10f%n", variance);
        });
    }

    public double calculateVariance(int percentileIndex) {
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        for (int j = 0; j < this.percentileRuns.size(); ++j) {
            double cellValue = this.getPercentileForRun(percentileIndex, j);
            if (this.skipFirst && j == 0 || cellValue == Double.POSITIVE_INFINITY) continue;
            if (cellValue > maxValue) {
                maxValue = cellValue;
            }
            if (!(cellValue < minValue)) continue;
            minValue = cellValue;
        }
        return 100.0 * (maxValue - minValue) / (maxValue + minValue / 2.0);
    }

    public double getPercentileForRun(int percentileIndex, int runIndex) {
        double[] percentileRun = this.percentileRuns.get(runIndex);
        if (percentileIndex == this.percentiles.length - 1) {
            return percentileRun[percentileRun.length - 1] / 1000.0;
        }
        if (percentileRun.length - 1 <= percentileIndex) {
            return Double.POSITIVE_INFINITY;
        }
        return percentileRun[percentileIndex] / 1000.0;
    }

    public void forEachRow(RowConsumer consumer) {
        for (int i = 0; i < this.percentiles.length; ++i) {
            double[] rowValues = new double[this.percentileRuns.size()];
            boolean rowHasValues = false;
            for (int j = 0; j < this.percentileRuns.size(); ++j) {
                double percentileForRun;
                rowValues[j] = percentileForRun = this.getPercentileForRun(i, j);
                rowHasValues = rowHasValues || !Double.isInfinite(percentileForRun);
            }
            if (!rowHasValues) continue;
            consumer.consume(this.percentiles[i], rowValues, this.calculateVariance(i));
        }
    }

    public static interface RowConsumer {
        public void consume(double var1, double[] var3, double var4);
    }
}

