/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.jlbh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.ImmutableJLBHResult;
import net.openhft.chronicle.jlbh.ImmutableProbeResult;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHResult;
import net.openhft.chronicle.jlbh.LatencyDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JLBH
implements NanoSampler {
    private static final Double[] NO_DOUBLES = new Double[0];
    private final SortedMap<String, Histogram> additionHistograms = new ConcurrentSkipListMap<String, Histogram>();
    private final long latencyBetweenTasks;
    private final LatencyDistributor latencyDistributor;
    @NotNull
    private final JLBHOptions jlbhOptions;
    @NotNull
    private final PrintStream printStream;
    private final Consumer<JLBHResult> resultConsumer;
    @NotNull
    private final List<double[]> percentileRuns;
    @NotNull
    private final Map<String, List<double[]>> additionalPercentileRuns;
    @NotNull
    private final OSJitterMonitor osJitterMonitor = new OSJitterMonitor();
    @NotNull
    private Histogram endToEndHistogram = this.createHistogram();
    @NotNull
    private Histogram osJitterHistogram = this.createHistogram();
    private volatile long noResultsReturned;
    @NotNull
    private AtomicBoolean warmUpComplete = new AtomicBoolean(false);
    private boolean warmedUp;
    private AtomicBoolean abortTestRun = new AtomicBoolean();
    private volatile Thread testThread;

    public JLBH(@NotNull JLBHOptions jlbhOptions) {
        this(jlbhOptions, System.out, null);
    }

    public JLBH(@NotNull JLBHOptions jlbhOptions, @NotNull PrintStream printStream, Consumer<JLBHResult> resultConsumer) {
        String resourceTracing = System.getProperty("jvm.resource.tracing");
        if (resourceTracing != null && (resourceTracing.isEmpty() || Boolean.parseBoolean(resourceTracing))) {
            System.out.println("***** WARNING : JLBH can not be run if jvm.resource.tracing=" + resourceTracing + ", please remove all \"jvm.resource.tracing\" as this will corrupt your stats *****");
            System.exit(-1);
        }
        this.jlbhOptions = jlbhOptions;
        this.printStream = printStream;
        this.resultConsumer = resultConsumer;
        if (jlbhOptions.jlbhTask == null) {
            throw new IllegalStateException("jlbhTask must be set");
        }
        this.latencyBetweenTasks = jlbhOptions.throughputTimeUnit.toNanos(1L) / (long)jlbhOptions.throughput;
        this.percentileRuns = new ArrayList<double[]>();
        this.additionalPercentileRuns = new TreeMap<String, List<double[]>>();
        this.latencyDistributor = jlbhOptions.latencyDistributor;
    }

    public NanoSampler addProbe(String name) {
        return (NanoSampler)this.additionHistograms.computeIfAbsent(name, n -> this.createHistogram());
    }

    @NotNull
    public Map<String, List<double[]>> additionalPercentileRuns() {
        return this.additionalPercentileRuns;
    }

    public void abort() {
        this.abortTestRun.set(true);
        this.testThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startTimeoutCheckerIfRequired();
        this.testThread = Thread.currentThread();
        long warmupStart = this.initStartOSJitterMonitorWarmup();
        int interruptCheckThrottle = 0;
        int interruptCheckThrottleMask = 1023;
        AffinityLock lock = this.jlbhOptions.acquireLock.get();
        try {
            for (int run = 0; run < this.jlbhOptions.runs && !this.abortTestRun.get(); ++run) {
                long startTimeNs;
                long runStart = System.currentTimeMillis();
                long lastPrint = startTimeNs = System.nanoTime();
                for (int i = 0; i < this.jlbhOptions.iterations; ++i) {
                    if (i % 8 == 0 && i % 1000 == 0 && startTimeNs > lastPrint + 5000000000L) {
                        System.out.printf("... run %,d  out of %,d%n", i, this.jlbhOptions.iterations);
                        lastPrint = startTimeNs;
                        startTimeNs = System.nanoTime();
                    }
                    if (i == 0 && run == 0) {
                        this.warmupComplete(warmupStart);
                        runStart = System.currentTimeMillis();
                        startTimeNs = System.nanoTime();
                    } else {
                        long latencyBetweenTasks = this.latencyDistributor.apply(this.latencyBetweenTasks);
                        if (this.jlbhOptions.accountForCoordinatedOmission) {
                            long millis = ((startTimeNs += latencyBetweenTasks) - System.nanoTime()) / 1000000L - 2L;
                            if (millis > 0L) {
                                Jvm.pause((long)millis);
                            }
                            Jvm.busyWaitUntil((long)startTimeNs);
                        } else {
                            if ((double)latencyBetweenTasks > 2000000.0) {
                                long end = System.nanoTime() + latencyBetweenTasks;
                                Jvm.pause((long)(latencyBetweenTasks / 1000000L - 1L));
                                Jvm.busyWaitUntil((long)end);
                            } else {
                                Jvm.busyWaitMicros((long)(latencyBetweenTasks / 1000L));
                            }
                            startTimeNs = System.nanoTime();
                        }
                    }
                    interruptCheckThrottle = interruptCheckThrottle + 1 & interruptCheckThrottleMask;
                    if (interruptCheckThrottle == 0 && this.testThread.isInterrupted()) break;
                    this.jlbhOptions.jlbhTask.run(startTimeNs);
                }
                this.endOfRun(run, runStart);
            }
        }
        finally {
            Thread.interrupted();
            Jvm.pause((long)5L);
            lock.release();
            Jvm.pause((long)5L);
        }
        this.endOfAllRuns();
    }

    private void startTimeoutCheckerIfRequired() {
        if (this.jlbhOptions.timeout > 0L) {
            Thread sampleTimeoutChecker = new Thread(this::checkSampleTimeout);
            sampleTimeoutChecker.setDaemon(true);
            sampleTimeoutChecker.start();
        }
    }

    private void warmupComplete(long warmupStart) {
        while (!this.warmUpComplete.get()) {
            Jvm.pause((long)2000L);
            this.printStream.println("Complete: " + this.noResultsReturned);
            if (!this.testThread.isInterrupted()) continue;
            return;
        }
        this.printStream.println("Warm up complete (" + this.jlbhOptions.warmUpIterations + " iterations took " + (double)(System.currentTimeMillis() - warmupStart) / 1000.0 + "s)");
        if (this.jlbhOptions.pauseAfterWarmupMS != 0) {
            this.printStream.println("Pausing after warmup for " + this.jlbhOptions.pauseAfterWarmupMS + "ms");
            Jvm.pause((long)this.jlbhOptions.pauseAfterWarmupMS);
        }
        this.jlbhOptions.jlbhTask.warmedUp();
    }

    private long initStartOSJitterMonitorWarmup() {
        this.jlbhOptions.jlbhTask.init(this);
        if (this.jlbhOptions.recordOSJitter) {
            this.osJitterMonitor.setDaemon(true);
            this.osJitterMonitor.start();
        }
        long warmupStart = System.currentTimeMillis();
        for (int i = 0; i < this.jlbhOptions.warmUpIterations; ++i) {
            this.jlbhOptions.jlbhTask.run(System.nanoTime());
        }
        return warmupStart;
    }

    private void endOfAllRuns() {
        this.printPercentilesSummary("end to end", this.percentileRuns, this.printStream);
        if (this.additionalPercentileRuns.size() > 0) {
            this.additionalPercentileRuns.forEach((label, percentileRuns1) -> this.printPercentilesSummary((String)label, (List<double[]>)percentileRuns1, this.printStream));
        }
        this.consumeResults();
        this.jlbhOptions.jlbhTask.complete();
    }

    public List<double[]> percentileRuns() {
        return this.percentileRuns;
    }

    private void endOfRun(int run, long runStart) {
        while (!this.abortTestRun.get() && this.endToEndHistogram.totalCount() < (long)this.jlbhOptions.iterations) {
            Thread.yield();
        }
        long totalRunTime = System.currentTimeMillis() - runStart;
        this.percentileRuns.add(this.endToEndHistogram.getPercentiles());
        this.printStream.println("-------------------------------- BENCHMARK RESULTS (RUN " + (run + 1) + ") --------------------------------------------------------");
        this.printStream.println("Run time: " + (double)totalRunTime / 1000.0 + "s, distribution: " + this.latencyDistributor);
        this.printStream.println("Correcting for co-ordinated:" + this.jlbhOptions.accountForCoordinatedOmission);
        this.printStream.println("Target throughput:" + this.jlbhOptions.throughput + "/" + this.timeUnitToString(this.jlbhOptions.throughputTimeUnit) + " = 1 message every " + this.latencyBetweenTasks / 1000L + "us");
        this.printStream.printf("%-48s", String.format("End to End: (%,d)", this.endToEndHistogram.totalCount()));
        this.printStream.println(this.endToEndHistogram.toMicrosFormat());
        if (this.additionHistograms.size() > 0) {
            this.additionHistograms.forEach((key, value) -> {
                List ds = this.additionalPercentileRuns.computeIfAbsent((String)key, i -> new ArrayList());
                ds.add(value.getPercentiles());
                this.printStream.printf("%-48s", String.format("%s (%,d)", key, value.totalCount()));
                this.printStream.println(value.toMicrosFormat());
            });
        }
        if (this.jlbhOptions.recordOSJitter) {
            this.printStream.printf("%-48s", String.format("OS Jitter (%,d)", this.osJitterHistogram.totalCount()));
            this.printStream.println(this.osJitterHistogram.toMicrosFormat());
        }
        this.printStream.println("-------------------------------------------------------------------------------------------------------------------");
        this.noResultsReturned = 0L;
        this.endToEndHistogram.reset();
        this.additionHistograms.values().forEach(Histogram::reset);
        this.osJitterMonitor.reset();
        this.jlbhOptions.jlbhTask.runComplete();
    }

    private void checkSampleTimeout() {
        long previousSampleCount = 0L;
        long previousSampleTime = 0L;
        while (true) {
            Jvm.pause((long)TimeUnit.SECONDS.toMillis(10L));
            if (previousSampleCount < this.noResultsReturned) {
                previousSampleCount = this.noResultsReturned;
                previousSampleTime = System.currentTimeMillis();
                continue;
            }
            if (previousSampleTime < System.currentTimeMillis() - this.jlbhOptions.timeout) break;
        }
        this.printStream.println("Sample timed out. Aborting test...");
        this.abort();
    }

    public JLBHEventHandler eventLoopHandler() {
        if (!this.jlbhOptions.accountForCoordinatedOmission) {
            throw new UnsupportedOperationException();
        }
        long warmupStart = this.initStartOSJitterMonitorWarmup();
        this.warmupComplete(warmupStart);
        return new JLBHEventHandler();
    }

    private void consumeResults() {
        if (this.resultConsumer != null) {
            ImmutableProbeResult endToEndProbeResult = new ImmutableProbeResult(this.percentileRuns);
            Map<String, ImmutableProbeResult> additionalProbeResults = this.additionalPercentileRuns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, probe -> new ImmutableProbeResult((List)probe.getValue())));
            this.resultConsumer.accept(new ImmutableJLBHResult(endToEndProbeResult, additionalProbeResults));
        }
    }

    public void printPercentilesSummary(String label, @NotNull List<double[]> percentileRuns, Appendable appendable) {
        try {
            appendable.append("-------------------------------- SUMMARY (").append(label).append(") -----------------------------------------------------------\n");
            @NotNull ArrayList<Double> consistencies = new ArrayList<Double>();
            double maxValue = Double.MIN_VALUE;
            double minValue = Double.MAX_VALUE;
            double[] percentFor = Histogram.percentilesFor((long)this.jlbhOptions.iterations);
            int length = percentFor.length;
            for (int i = 0; i < length; ++i) {
                boolean skipFirst;
                boolean bl = skipFirst = length > 3;
                if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.SKIP) {
                    skipFirst = true;
                } else if (this.jlbhOptions.skipFirstRun == JLBHOptions.SKIP_FIRST_RUN.NO_SKIP) {
                    skipFirst = false;
                }
                for (double[] percentileRun : percentileRuns) {
                    if (skipFirst) {
                        skipFirst = false;
                        continue;
                    }
                    if (i >= percentileRun.length) continue;
                    double v = percentileRun[i];
                    if (v > maxValue) {
                        maxValue = v;
                    }
                    if (!(v < minValue)) continue;
                    minValue = v;
                }
                consistencies.add(100.0 * (maxValue - minValue) / (maxValue + minValue / 2.0));
                maxValue = Double.MIN_VALUE;
                minValue = Double.MAX_VALUE;
            }
            @NotNull ArrayList<Double> summary = new ArrayList<Double>();
            for (int i = 0; i < length; ++i) {
                for (double[] percentileRun : percentileRuns) {
                    if (i < percentileRun.length) {
                        summary.add(percentileRun[i] / 1000.0);
                        continue;
                    }
                    summary.add(Double.POSITIVE_INFINITY);
                }
                summary.add((Double)consistencies.get(i));
            }
            @NotNull StringBuilder sb = new StringBuilder();
            this.addHeaderToPrint(sb, this.jlbhOptions.runs);
            appendable.append(sb.toString()).append('\n');
            sb = new StringBuilder();
            for (Object p : (Object)percentFor) {
                reference var19_22;
                String s = p == 1.0 ? "worst" : ((double)((long)(var19_22 = p * 100.0)) == var19_22 ? Long.toString((long)var19_22) : Double.toString((double)var19_22));
                s = s + ":     ";
                s = s.substring(0, 8);
                this.addPrToPrint(sb, s, this.jlbhOptions.runs);
            }
            try {
                Double[] args = summary.toArray(NO_DOUBLES);
                appendable.append(String.format(sb.toString(), args));
            }
            catch (Exception e) {
                appendable.append(e.getMessage());
            }
            appendable.append("-------------------------------------------------------------------------------------------------------------------\n");
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private void addPrToPrint(@NotNull StringBuilder sb, String pr, int runs) {
        sb.append(pr);
        for (int i = 0; i < runs; ++i) {
            sb.append("%12.2f ");
        }
        sb.append("%12.2f");
        sb.append("%n");
    }

    private void addHeaderToPrint(@NotNull StringBuilder sb, int runs) {
        sb.append("Percentile");
        for (int i = 1; i < runs + 1; ++i) {
            if (i == 1) {
                sb.append("   run").append(i);
                continue;
            }
            sb.append("         run").append(i);
        }
        sb.append("      % Variation");
    }

    private String timeUnitToString(@NotNull TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalArgumentException("Unrecognized time unit value '" + (Object)((Object)timeUnit) + "'");
    }

    public void sampleNanos(long nanos) {
        this.sample(nanos);
    }

    public void sample(long nanoTime) {
        ++this.noResultsReturned;
        if (this.noResultsReturned < (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.endToEndHistogram.sample((double)nanoTime);
            return;
        }
        if (this.noResultsReturned == (long)this.jlbhOptions.warmUpIterations && !this.warmedUp) {
            this.warmedUp = true;
            this.endToEndHistogram.reset();
            if (this.additionHistograms.size() > 0) {
                this.additionHistograms.values().forEach(Histogram::reset);
            }
            this.warmUpComplete.set(true);
            return;
        }
        this.endToEndHistogram.sample((double)nanoTime);
    }

    @NotNull
    protected Histogram createHistogram() {
        return new Histogram();
    }

    private class JLBHEventHandler
    implements EventHandler {
        private int iteration;
        private long runStart;
        private long nextInvokeTime;
        private boolean waitingForEndOfRun = false;

        JLBHEventHandler() {
            this.resetTime();
        }

        private void resetTime() {
            this.runStart = System.currentTimeMillis();
            this.nextInvokeTime = System.nanoTime() + JLBH.this.latencyBetweenTasks;
        }

        public boolean action() {
            boolean busy = false;
            int run = this.iteration / ((JLBH)JLBH.this).jlbhOptions.iterations;
            int i = this.iteration % ((JLBH)JLBH.this).jlbhOptions.iterations;
            if (!this.waitingForEndOfRun) {
                long now = System.nanoTime();
                if (now >= this.nextInvokeTime) {
                    this.nextInvokeTime += JLBH.this.latencyBetweenTasks;
                    ((JLBH)JLBH.this).jlbhOptions.jlbhTask.run(this.nextInvokeTime);
                    busy = true;
                    ++this.iteration;
                    if (i == ((JLBH)JLBH.this).jlbhOptions.iterations - 1) {
                        this.waitingForEndOfRun = true;
                    }
                }
            } else if (JLBH.this.endToEndHistogram.totalCount() >= (long)((JLBH)JLBH.this).jlbhOptions.iterations) {
                JLBH.this.endOfRun(run - 1, this.runStart);
                this.resetTime();
                this.waitingForEndOfRun = false;
                if (run == ((JLBH)JLBH.this).jlbhOptions.runs) {
                    JLBH.this.endOfAllRuns();
                }
            }
            return busy;
        }
    }

    private class OSJitterMonitor
    extends Thread {
        final AtomicBoolean reset = new AtomicBoolean(false);

        private OSJitterMonitor() {
        }

        @Override
        public void run() {
            Affinity.setAffinity((BitSet)AffinityLock.BASE_AFFINITY);
            @Nullable AffinityLock affinityLock = null;
            if (((JLBH)JLBH.this).jlbhOptions.jitterAffinity) {
                JLBH.this.printStream.println("Jitter thread running with affinity.");
                affinityLock = AffinityLock.acquireLock();
            }
            try {
                long lastTime;
                long start = lastTime = System.nanoTime();
                while (true) {
                    if (this.reset.compareAndSet(true, false)) {
                        JLBH.this.osJitterHistogram.reset();
                        lastTime = System.nanoTime();
                    }
                    for (int i = 0; i < 1000; ++i) {
                        long time = System.nanoTime();
                        if (time - lastTime > (long)((JLBH)JLBH.this).jlbhOptions.recordJitterGreaterThanNs) {
                            JLBH.this.osJitterHistogram.sample((double)(time - lastTime));
                        }
                        lastTime = time;
                    }
                    if (!((double)lastTime > (double)start + 6.0E10)) continue;
                    Jvm.pause((long)1L);
                }
            }
            catch (Throwable throwable) {
                if (affinityLock != null) {
                    affinityLock.release();
                }
                throw throwable;
            }
        }

        void reset() {
            this.reset.set(true);
        }
    }
}

