/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import net.openhft.compiler.CompilerUtils;
import net.openhft.compiler.JavaSourceFromString;
import net.openhft.compiler.MyJavaFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedCompiler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CachedCompiler.class);
    private static final PrintWriter DEFAULT_WRITER = CachedCompiler.createDefaultWriter();
    private static final List<String> DEFAULT_OPTIONS = Arrays.asList("-g", "-nowarn");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("[\\p{Alnum}_$.\\-]+");
    private static final Pattern CLASS_NAME_SEGMENT_PATTERN = Pattern.compile("[\\p{Alnum}_$]+(?:-[\\p{Alnum}_$]+)*");
    private final Map<ClassLoader, Map<String, Class<?>>> loadedClassesMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<ClassLoader, MyJavaFileManager> fileManagerMap = Collections.synchronizedMap(new WeakHashMap());
    public volatile Function<StandardJavaFileManager, MyJavaFileManager> fileManagerOverride;
    @Nullable
    private final File sourceDir;
    @Nullable
    private final File classDir;
    @NotNull
    private final List<String> options;
    private final ConcurrentMap<String, JavaFileObject> javaFileObjects = new ConcurrentHashMap<String, JavaFileObject>();

    public CachedCompiler(@Nullable File sourceDir, @Nullable File classDir) {
        this(sourceDir, classDir, DEFAULT_OPTIONS);
    }

    public CachedCompiler(@Nullable File sourceDir, @Nullable File classDir, @NotNull List<String> options) {
        this.sourceDir = sourceDir;
        this.classDir = classDir;
        this.options = Collections.unmodifiableList(new ArrayList<String>(options));
    }

    @Override
    public void close() {
        try {
            for (MyJavaFileManager fileManager : this.fileManagerMap.values()) {
                fileManager.close();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Class<?> loadFromJava(@NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        CachedCompiler.validateClassName(className);
        return this.loadFromJava(this.getClass().getClassLoader(), className, javaCode, DEFAULT_WRITER);
    }

    public Class<?> loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        CachedCompiler.validateClassName(className);
        return this.loadFromJava(classLoader, className, javaCode, DEFAULT_WRITER);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode, MyJavaFileManager fileManager) {
        CachedCompiler.validateClassName(className);
        return this.compileFromJava(className, javaCode, DEFAULT_WRITER, fileManager);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode, final @NotNull PrintWriter writer, MyJavaFileManager fileManager) {
        Iterable<Object> compilationUnits;
        CachedCompiler.validateClassName(className);
        if (this.sourceDir != null) {
            String filename = className.replaceAll("\\.", '\\' + File.separator) + ".java";
            File file = CachedCompiler.safeResolve(this.sourceDir, filename);
            CompilerUtils.writeText(file, javaCode);
            if (CompilerUtils.s_standardJavaFileManager == null) {
                CompilerUtils.s_standardJavaFileManager = CompilerUtils.s_compiler.getStandardFileManager(null, null, null);
            }
            compilationUnits = CompilerUtils.s_standardJavaFileManager.getJavaFileObjects(file);
        } else {
            this.javaFileObjects.put(className, new JavaSourceFromString(className, javaCode));
            compilationUnits = new ArrayList(this.javaFileObjects.values());
        }
        boolean ok = CompilerUtils.s_compiler.getTask(writer, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    writer.println(diagnostic);
                }
            }
        }, this.options, null, compilationUnits).call();
        if (!ok) {
            if (this.sourceDir == null) {
                this.javaFileObjects.remove(className);
            }
            return Collections.emptyMap();
        }
        Map<String, byte[]> result = fileManager.getAllBuffers();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode, @Nullable PrintWriter writer) throws ClassNotFoundException {
        PrintWriter printWriter;
        Map<String, Class<?>> loadedClasses;
        Class<?> clazz = null;
        Map<ClassLoader, Map<String, Class<?>>> map = this.loadedClassesMap;
        synchronized (map) {
            loadedClasses = this.loadedClassesMap.get(classLoader);
            if (loadedClasses == null) {
                loadedClasses = new LinkedHashMap();
                this.loadedClassesMap.put(classLoader, loadedClasses);
            } else {
                clazz = loadedClasses.get(className);
            }
        }
        PrintWriter printWriter2 = printWriter = writer == null ? DEFAULT_WRITER : writer;
        if (clazz != null) {
            return clazz;
        }
        MyJavaFileManager fileManager = this.fileManagerMap.get(classLoader);
        if (fileManager == null) {
            StandardJavaFileManager standardJavaFileManager = CompilerUtils.s_compiler.getStandardFileManager(null, null, null);
            fileManager = this.getFileManager(standardJavaFileManager);
            this.fileManagerMap.put(classLoader, fileManager);
        }
        Map<String, byte[]> compiled = this.compileFromJava(className, javaCode, printWriter, fileManager);
        for (Map.Entry<String, byte[]> entry : compiled.entrySet()) {
            String filename;
            boolean changed2;
            String className2 = entry.getKey();
            CachedCompiler.validateClassName(className2);
            Map<ClassLoader, Map<String, Class<?>>> map2 = this.loadedClassesMap;
            synchronized (map2) {
                if (loadedClasses.containsKey(className2)) {
                    continue;
                }
            }
            byte[] bytes = entry.getValue();
            if (this.classDir != null && (changed2 = CompilerUtils.writeBytes(CachedCompiler.safeResolve(this.classDir, filename = className2.replaceAll("\\.", '\\' + File.separator) + ".class"), bytes))) {
                LOG.info("Updated {} in {}", (Object)className2, (Object)this.classDir);
            }
            String string = className2.intern();
            synchronized (string) {
                Map<ClassLoader, Map<String, Class<?>>> changed2 = this.loadedClassesMap;
                synchronized (changed2) {
                    if (loadedClasses.containsKey(className2)) {
                        continue;
                    }
                }
                Class<?> clazz2 = CompilerUtils.defineClass(classLoader, className2, bytes);
                Map<ClassLoader, Map<String, Class<?>>> map3 = this.loadedClassesMap;
                synchronized (map3) {
                    loadedClasses.put(className2, clazz2);
                }
            }
        }
        Map<ClassLoader, Map<String, Class<?>>> map4 = this.loadedClassesMap;
        synchronized (map4) {
            clazz = classLoader.loadClass(className);
            loadedClasses.put(className, clazz);
        }
        return clazz;
    }

    public void updateFileManagerForClassLoader(ClassLoader classLoader, Consumer<MyJavaFileManager> updateFileManager) {
        MyJavaFileManager fileManager = this.fileManagerMap.get(classLoader);
        if (fileManager != null) {
            updateFileManager.accept(fileManager);
        }
    }

    public void setFileManagerOverride(Function<StandardJavaFileManager, MyJavaFileManager> fileManagerOverride) {
        this.fileManagerOverride = fileManagerOverride;
    }

    @NotNull
    private MyJavaFileManager getFileManager(StandardJavaFileManager fm) {
        return this.fileManagerOverride != null ? this.fileManagerOverride.apply(fm) : new MyJavaFileManager(fm);
    }

    private static void validateClassName(String className) {
        Objects.requireNonNull(className, "className");
        if (!CLASS_NAME_PATTERN.matcher(className).matches()) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
        for (String segment : className.split("\\.", -1)) {
            if (CLASS_NAME_SEGMENT_PATTERN.matcher(segment).matches()) continue;
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    static File safeResolve(File root, String relativePath) {
        Objects.requireNonNull(root, "root");
        Objects.requireNonNull(relativePath, "relativePath");
        Path base = root.toPath().toAbsolutePath().normalize();
        Path candidate = base.resolve(relativePath).normalize();
        if (!candidate.startsWith(base)) {
            throw new IllegalArgumentException("Attempted path traversal for " + relativePath);
        }
        return candidate.toFile();
    }

    private static PrintWriter createDefaultWriter() {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8);
        return new PrintWriter(writer, true){

            @Override
            public void close() {
                this.flush();
            }
        };
    }
}

