/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import net.openhft.compiler.CompilerUtils;
import net.openhft.compiler.JavaSourceFromString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedCompiler {
    private static final Map<ClassLoader, Map<String, Class>> loadedClassesMap = new WeakHashMap<ClassLoader, Map<String, Class>>();
    @Nullable
    private final File sourceDir;
    @Nullable
    private final File classDir;
    private final List<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();

    public CachedCompiler(@Nullable File sourceDir, @Nullable File classDir) {
        this.sourceDir = sourceDir;
        this.classDir = classDir;
    }

    public static void close() {
        try {
            CompilerUtils.s_fileManager.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Class loadFromJava(@NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        return this.loadFromJava(this.getClass().getClassLoader(), className, javaCode);
    }

    @NotNull
    Map<String, byte[]> compileFromJava(@NotNull String className, @NotNull String javaCode) {
        Iterable<JavaFileObject> compilationUnits;
        if (this.sourceDir != null) {
            String filename = className.replaceAll("\\.", '\\' + File.separator) + ".java";
            File file = new File(this.sourceDir, filename);
            CompilerUtils.writeText(file, javaCode);
            compilationUnits = CompilerUtils.s_standardJavaFileManager.getJavaFileObjects(file);
        } else {
            this.javaFileObjects.add(new JavaSourceFromString(className, javaCode));
            compilationUnits = this.javaFileObjects;
        }
        CompilerUtils.s_compiler.getTask(null, CompilerUtils.s_fileManager, null, null, null, compilationUnits).call();
        return CompilerUtils.s_fileManager.getAllBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadFromJava(@NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        Map<String, Class> loadedClasses;
        Class<?> clazz = null;
        Map<ClassLoader, Map<String, Class>> map = loadedClassesMap;
        synchronized (map) {
            loadedClasses = loadedClassesMap.get(classLoader);
            if (loadedClasses == null) {
                loadedClasses = new LinkedHashMap<String, Class>();
                loadedClassesMap.put(classLoader, loadedClasses);
            } else {
                clazz = loadedClasses.get(className);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        for (Map.Entry<String, byte[]> entry : this.compileFromJava(className, javaCode).entrySet()) {
            String filename;
            boolean changed;
            String className2 = entry.getKey();
            Map<ClassLoader, Map<String, Class>> map2 = loadedClassesMap;
            synchronized (map2) {
                if (loadedClasses.containsKey(className2)) {
                    continue;
                }
            }
            byte[] bytes = entry.getValue();
            if (this.classDir != null && (changed = CompilerUtils.writeBytes(new File(this.classDir, filename = className2.replaceAll("\\.", '\\' + File.separator) + ".class"), bytes))) {
                Logger.getLogger(CachedCompiler.class.getName()).info("Updated " + className2 + " in " + this.classDir);
            }
            Class clazz2 = CompilerUtils.defineClass(classLoader, className2, bytes);
            Map<ClassLoader, Map<String, Class>> map3 = loadedClassesMap;
            synchronized (map3) {
                loadedClasses.put(className2, clazz2);
            }
        }
        map = loadedClassesMap;
        synchronized (map) {
            clazz = classLoader.loadClass(className);
            loadedClasses.put(className, clazz);
        }
        return clazz;
    }
}

