/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.BinanceApiError;
import com.binance.api.client.exception.BinanceApiException;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BinanceApiCallbackAdapter<T>
implements Callback<T> {
    private final BinanceApiCallback<T> callback;

    public BinanceApiCallbackAdapter(BinanceApiCallback<T> callback) {
        this.callback = callback;
    }

    public void onResponse(Call<T> call, Response<T> response) {
        if (response.isSuccessful()) {
            this.callback.onResponse(response.body());
        } else {
            if (response.code() == 504) {
                return;
            }
            try {
                BinanceApiError apiError = BinanceApiServiceGenerator.getBinanceApiError(response);
                this.onFailure(call, new BinanceApiException(apiError));
            }
            catch (IOException e) {
                this.onFailure(call, new BinanceApiException(e));
            }
        }
    }

    public void onFailure(Call<T> call, Throwable throwable) {
        if (throwable instanceof BinanceApiException) {
            this.callback.onFailure(throwable);
        } else {
            this.callback.onFailure(new BinanceApiException(throwable));
        }
    }
}

