/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import net.openhft.chronicle.bytes.util.PropertyReplacer;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.wire.TextWire;

public enum ConfigLoader {


    public static String loadFile(Class<?> classLoader, String filename) throws IOException {
        return new String(IOTools.readFile(classLoader, (String)filename), StandardCharsets.UTF_8);
    }

    public static <T> T loadFromFile(String filename) throws IOException {
        return ConfigLoader.loadFromFile(ConfigLoader.class, filename);
    }

    public static <T> T loadFromFile(Class<?> classLoader, String filename) throws IOException {
        return ConfigLoader.load(ConfigLoader.loadFile(classLoader, filename));
    }

    public static <T> T loadFromFile(String filename, Properties properties) throws IOException {
        return ConfigLoader.loadFromFile(ConfigLoader.class, filename, properties);
    }

    public static <T> T loadFromFile(Class<?> classLoader, String filename, Properties properties) throws IOException {
        return ConfigLoader.loadWithProperties(ConfigLoader.loadFile(classLoader, filename), properties);
    }

    public static <T> T load(String fileAsString) {
        return (T)TextWire.from(PropertyReplacer.replaceTokensWithProperties((String)fileAsString)).readObject();
    }

    public static <T> T loadWithProperties(String fileAsString, Properties properties) {
        return (T)TextWire.from(PropertyReplacer.replaceTokensWithProperties((String)fileAsString, (Properties)properties)).readObject();
    }
}

