/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.WriteDocumentContext;

public interface MessageHistory
extends Marshallable {
    public static MessageHistory get() {
        return VanillaMessageHistory.getThreadLocal();
    }

    public static void set(MessageHistory md) {
        VanillaMessageHistory.setThreadLocal(md);
    }

    public static void clear() {
        VanillaMessageHistory.setThreadLocal(null);
    }

    public static void emptyHistory() {
        VanillaMessageHistory.setThreadLocal(new VanillaMessageHistory());
    }

    @UsedViaReflection
    public static void writeHistory(DocumentContext dc) {
        if (((WriteDocumentContext)dc).isEmpty()) {
            MessageHistory.get().doWriteHistory(dc);
        }
    }

    default public void doWriteHistory(DocumentContext dc) {
        dc.wire().writeEventName("history").marshallable(MessageHistory.get());
    }

    public int timings();

    public long timing(int var1);

    public int sources();

    public int sourceId(int var1);

    public boolean sourceIdsEndsWith(int[] var1);

    public long sourceIndex(int var1);

    @Override
    public void reset();

    public void reset(int var1, long var2);

    public int lastSourceId();

    public long lastSourceIndex();

    public boolean isDirty();
}

