/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.wire.TextMethodTester;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.YamlMethodTester;
import net.openhft.chronicle.wire.utils.YamlAgitator;

public interface YamlTester {
    public static final boolean REGRESS_TESTS = Jvm.getBoolean((String)"regress.tests");
    public static final boolean BASE_TESTS = Jvm.getBoolean((String)"base.tests");

    public static YamlTester runTest(Class<?> implClass, String path) throws AssertionError {
        for (Constructor<?> cons : implClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes;
            if (cons.getParameterCount() != 1 || !(parameterTypes = cons.getParameterTypes())[0].isInterface()) continue;
            return YamlTester.runTest((T out) -> {
                try {
                    return cons.newInstance(out);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }, parameterTypes[0], path);
        }
        throw new IllegalArgumentException("Unable to find a constructor with one interface as an argument");
    }

    public static <T> YamlTester runTest(Function<T, Object> builder, Class<T> outClass, String path) throws AssertionError {
        try {
            return new TextMethodTester<T>(path + "/in.yaml", builder, outClass, path + "/out.yaml").setup(path + "/setup.yaml").run();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public static <T> YamlTester runTest(Function<T, Object> builder, Function<WireOut, T> outFunction, String path) throws AssertionError {
        try {
            return new TextMethodTester<T>(path + "/in.yaml", builder, outFunction, path + "/out.yaml").setup(path + "/setup.yaml").run();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public static <T> List<Object[]> parameters(ThrowingFunction<T, Object, Throwable> builder, Class<T> outClass, String paths, YamlAgitator ... agitators) {
        String[] pathArr;
        Function compFunction = ThrowingFunction.asFunction(builder);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String path : pathArr = paths.split(",")) {
            String in_yaml;
            if ((path = path.trim()).isEmpty()) continue;
            String setup = path + "/_setup.yaml";
            TextMethodTester yt = new YamlMethodTester<T>(path + "/in.yaml", compFunction, outClass, path + "/out.yaml").genericEvent("event").setup(setup);
            Object[] test = new Object[]{path, yt};
            params.add(test);
            if (BASE_TESTS) continue;
            try {
                in_yaml = new String(IOTools.readFile(outClass, (String)(path + "/in.yaml")), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            String _setup_yaml = "";
            try {
                _setup_yaml = new String(IOTools.readFile(outClass, (String)(path + "/_setup.yaml")), StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TreeSet<String> skipping = new TreeSet<String>();
            for (String path2 : pathArr) {
                if ((path2 = path2.trim()).isEmpty()) continue;
                String name = path2.replaceAll("[:/\\\\]+", "_");
                String output = path + "/out-" + name + ".yaml";
                try {
                    String in_yaml2;
                    if (!REGRESS_TESTS) {
                        IOTools.urlFor(builder.getClass(), (String)output);
                    }
                    try {
                        in_yaml2 = new String(IOTools.readFile(outClass, (String)(path2 + "/in.yaml")), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                    String _setup_yaml2 = "";
                    try {
                        _setup_yaml2 = new String(IOTools.readFile(outClass, (String)(path2 + "/_setup.yaml")), StandardCharsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String in2 = "=\n" + in_yaml + "\n" + in_yaml2;
                    String setup2 = "=\n" + _setup_yaml + "\n" + _setup_yaml2;
                    TextMethodTester yt2 = new YamlMethodTester<T>(in2, compFunction, outClass, output).genericEvent("event").setup(setup2);
                    Object[] test2 = new Object[]{path + "+" + path2, yt2};
                    params.add(test2);
                }
                catch (FileNotFoundException ioe) {
                    skipping.add(path + "/" + path + "+" + path2);
                }
            }
            if (agitators.length > 0) {
                LinkedHashMap<String, String> inputToNameMap = new LinkedHashMap<String, String>();
                for (YamlAgitator agitator : agitators) {
                    Map<String, String> agitateMap = yt.agitate(agitator);
                    for (Map.Entry<String, String> entry : agitateMap.entrySet()) {
                        inputToNameMap.putIfAbsent(entry.getKey(), entry.getValue());
                    }
                }
                for (Map.Entry entry : inputToNameMap.entrySet()) {
                    String name = (String)entry.getValue();
                    String output = path + "/out-" + name + ".yaml";
                    try {
                        if (!REGRESS_TESTS) {
                            IOTools.urlFor(builder.getClass(), (String)output);
                        }
                        TextMethodTester yta = new YamlMethodTester<T>((String)entry.getKey(), compFunction, outClass, output).genericEvent("event").setup(setup);
                        Object[] testa = new Object[]{path + "/" + name, yta};
                        params.add(testa);
                    }
                    catch (FileNotFoundException ioe) {
                        skipping.add(path + "/" + name);
                    }
                }
            }
            if (skipping.isEmpty()) continue;
            Jvm.debug().on(YamlTester.class, "Skipping " + skipping);
        }
        return params;
    }

    default public Map<String, String> agitate(YamlAgitator agitator) throws IORuntimeException {
        throw new UnsupportedOperationException();
    }

    public String expected();

    public String actual();
}

