/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel.impl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.EventPoller;
import net.openhft.chronicle.wire.channel.HostPortCfg;
import net.openhft.chronicle.wire.channel.InternalChronicleChannel;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import net.openhft.chronicle.wire.channel.SystemContext;
import net.openhft.chronicle.wire.channel.impl.HTTPDetectedException;
import net.openhft.chronicle.wire.channel.impl.InvalidProtocolException;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.converter.NanoTime;

public class TCPChronicleChannel
extends AbstractCloseable
implements InternalChronicleChannel {
    static final int CAPACITY = Integer.getInteger("tcp.capacity", 0x200000);
    private static final String HEADER = "header";
    private static final ChannelHeader NO_HEADER = (ChannelHeader)Mocker.ignored(ChannelHeader.class, (Class[])new Class[0]);
    private static final boolean DUMP_YAML = Jvm.getBoolean((String)"dumpYaml");
    private final ReentrantLock lock = new ReentrantLock();
    private final ChronicleChannelCfg channelCfg;
    private final Wire in = this.createBuffer();
    private final Wire out = this.createBuffer();
    private final DocumentContextHolder dch = new ConnectionDocumentContextHolder();
    private final Function<ChannelHeader, ChannelHeader> replaceInHeader;
    private final Function<ChannelHeader, ChannelHeader> replaceOutHeader;
    private ChronicleContext chronicleContext;
    private SystemContext systemContext;
    private SocketChannel sc;
    private ChannelHeader headerIn;
    private ChannelHeader headerInToUse;
    private ChannelHeader headerOut;
    private long lastTestMessage;
    private SocketRegistry socketRegistry;
    private boolean privateSocketRegistry;
    private boolean endOfData = false;
    private boolean unsentTestMessage = false;
    private int bufferSize = CAPACITY * 2;

    public TCPChronicleChannel(ChronicleChannelCfg channelCfg, ChannelHeader headerOut, SocketRegistry socketRegistry) throws InvalidMarshallableException {
        try {
            this.channelCfg = Objects.requireNonNull(channelCfg);
            this.headerOut = Objects.requireNonNull(headerOut);
            this.socketRegistry = socketRegistry;
            this.replaceInHeader = null;
            this.replaceOutHeader = null;
            this.sc = null;
            assert (channelCfg.initiator());
            this.checkConnected();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public TCPChronicleChannel(SystemContext systemContext, ChronicleChannelCfg channelCfg, SocketChannel sc, Function<ChannelHeader, ChannelHeader> replaceInHeader, Function<ChannelHeader, ChannelHeader> replaceOutHeader) {
        try {
            this.systemContext = systemContext;
            this.channelCfg = Objects.requireNonNull(channelCfg);
            this.sc = Objects.requireNonNull(sc);
            this.replaceInHeader = Objects.requireNonNull(replaceInHeader);
            this.replaceOutHeader = Objects.requireNonNull(replaceOutHeader);
            this.headerOut = null;
            assert (!channelCfg.initiator());
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    static boolean validateHeader(int header) {
        if (header < 0) {
            throw new IllegalStateException("Not ready header " + Integer.toUnsignedString(header, 16));
        }
        if (header < 0x40000000 && header > 0x200000) {
            throw new IllegalStateException("Oversized data header " + Integer.toUnsignedString(header, 16));
        }
        if (header > 0x40001000) {
            throw new IllegalStateException("Oversized meta-data header " + Integer.toUnsignedString(header, 16));
        }
        return true;
    }

    @Override
    public ChronicleChannelCfg channelCfg() {
        return this.channelCfg;
    }

    void flush() {
        this.flushOut(this.out);
    }

    void flushOut(Wire out) {
        Bytes<?> bytes = out.bytes();
        if (out.bytes().writeRemaining() <= 0L) {
            return;
        }
        ByteBuffer bb = (ByteBuffer)bytes.underlyingObject();
        assert (bb != null);
        bb.position(Math.toIntExact(bytes.readPosition()));
        bb.limit(Math.toIntExact(bytes.readLimit()));
        while (bb.remaining() > 0) {
            int len;
            try {
                len = this.sc.write(bb);
            }
            catch (IOException e) {
                Thread.yield();
                if (this.isClosing()) {
                    return;
                }
                throw ClosedIORuntimeException.newIORuntimeException((Exception)e);
            }
            if (len >= 0) continue;
            throw new ClosedIORuntimeException("Closed");
        }
        out.clear();
    }

    private Wire createBuffer() {
        Bytes bytes = Bytes.elasticByteBuffer((int)CAPACITY);
        IOTools.unmonitor((Object)bytes);
        bytes.singleThreadedCheckDisabled(true);
        return (Wire)WireType.BINARY_LIGHT.apply(bytes);
    }

    @Override
    public DocumentContext readingDocument() throws ClosedIORuntimeException {
        DocumentContext dc;
        if (this.unsentTestMessage && this.out.writingIsComplete()) {
            this.testMessage(this.lastTestMessage);
        }
        if ((dc = this.readingDocument0()).isMetaData()) {
            Wire wire = dc.wire();
            long pos = wire.bytes().readPosition();
            String event = wire.readEvent(String.class);
            if ("testMessage".equals(event)) {
                long testMessage = wire.getValueIn().readLong(NanoTime.INSTANCE);
                this.unsentTestMessage = testMessage > this.lastTestMessage;
                this.lastTestMessage = testMessage;
            }
            wire.bytes().readPosition(pos);
        }
        return dc;
    }

    private DocumentContext readingDocument0() {
        int read;
        DocumentContext dc;
        this.checkConnected();
        Bytes<?> bytes = this.in.bytes();
        if (bytes.readRemaining() == 0L) {
            bytes.clear();
        }
        if ((dc = this.in.readingDocument()).isPresent()) {
            return dc;
        }
        if (this.in.bytes().isEmpty() && this.endOfData) {
            this.endOfData = false;
            return dc;
        }
        if (bytes.readPosition() * 2L > Math.max((long)(CAPACITY / 2), bytes.readLimit())) {
            bytes.compact();
        }
        ByteBuffer bb = (ByteBuffer)bytes.underlyingObject();
        bb.position(Math.toIntExact(bytes.writePosition()));
        bb.limit(Math.min(bb.capacity(), Math.toIntExact(bytes.writeLimit())));
        try {
            read = this.sc.read(bb);
        }
        catch (IOException e) {
            this.close();
            throw ClosedIORuntimeException.newIORuntimeException((Exception)e);
        }
        if (read < 0) {
            this.close();
            throw new ClosedIORuntimeException("Closed");
        }
        this.endOfData = true;
        bytes.writeSkip((long)read);
        int header = bytes.readInt(bytes.readPosition());
        if (this.headerOut == NO_HEADER) {
            if (header == 542393671) {
                throw new HTTPDetectedException("Start of request\n" + bytes);
            }
            if (header >> 16 != 16384) {
                throw new InvalidProtocolException("Dump\n" + bytes.toHexString());
            }
        }
        assert (bytes.readRemaining() < 4L || TCPChronicleChannel.validateHeader(header));
        if (DUMP_YAML) {
            System.out.println("in - " + Integer.toUnsignedString(header, 16) + "\n" + Wires.fromSizePrefixedBlobs(this.in));
        }
        return this.in.readingDocument();
    }

    synchronized void checkConnected() throws InvalidMarshallableException {
        if (this.sc != null && this.sc.isOpen()) {
            if (this.headerOut == null) {
                this.acceptorRespondToHeader();
            }
            return;
        }
        Closeable.closeQuietly((Object)this.sc);
        if (this.isClosing()) {
            throw new IllegalStateException("Closed");
        }
        Set<HostPortCfg> hostPorts = this.channelCfg.hostPorts();
        if (this.channelCfg.initiator()) {
            boolean success = false;
            block4: for (HostPortCfg hp : hostPorts) {
                if (hp.port() < -1) {
                    throw new IllegalArgumentException("Invalid port " + hp.port() + " connecting to " + hp.hostname());
                }
                try {
                    long end = System.nanoTime() + (long)(this.channelCfg.connectionTimeoutSecs() * 1.0E9);
                    if (this.socketRegistry == null) {
                        this.socketRegistry = new SocketRegistry();
                        this.privateSocketRegistry = true;
                    }
                    int delay = 1;
                    while (true) {
                        try {
                            this.sc = this.socketRegistry.createSocketChannel(hp.hostname(), hp.port());
                            this.configureSocket();
                            this.writeHeader();
                            this.readHeader();
                            success = true;
                            break block4;
                        }
                        catch (IOException e) {
                            if (System.nanoTime() > end) {
                                throw new IORuntimeException("hostport=" + hp, (Throwable)e);
                            }
                            Jvm.pause((long)delay);
                            ++delay;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "failed to connect to host-port=" + hp);
                }
            }
            if (!success) {
                throw new IORuntimeException("failed to connect to any of the following " + hostPorts);
            }
        }
        this.in.clear();
        this.out.clear();
    }

    private void configureSocket() throws IOException {
        if (this.channelCfg.pauserMode() == PauserMode.busy) {
            this.sc.configureBlocking(false);
        }
        Socket socket = this.sc.socket();
        socket.setReceiveBufferSize(CAPACITY);
        socket.setSendBufferSize(CAPACITY);
        this.bufferSize = socket.getReceiveBufferSize() + socket.getSendBufferSize();
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.sc);
        if (this.privateSocketRegistry) {
            Closeable.closeQuietly((Object)((Object)this.socketRegistry));
        }
    }

    synchronized void acceptorRespondToHeader() throws InvalidMarshallableException {
        this.headerOut = NO_HEADER;
        this.readHeader();
        this.headerInToUse = this.replaceInHeader.apply(this.headerIn);
        ChannelHeader replyHeader = this.replaceOutHeader.apply(this.headerInToUse);
        this.headerOut = replyHeader == null ? (this.headerIn instanceof ChannelHandler ? ((ChannelHandler)this.headerIn).responseHeader(this.chronicleContext) : new RedirectHeader(Collections.EMPTY_LIST)) : replyHeader;
        if (this.systemContext != null) {
            this.headerOut.systemContext(this.systemContext);
        }
        this.writeHeader();
    }

    private void writeHeader() throws InvalidMarshallableException {
        try (DocumentContext dc = this.writingDocument(true);){
            dc.wire().write(HEADER).object(this.headerOut);
        }
        this.out.bytes().singleThreadedCheckReset();
    }

    @Override
    public ChannelHeader headerOut() {
        assert (this.headerOut != null);
        return this.headerOut;
    }

    @Override
    public ChannelHeader headerIn() {
        if (this.headerIn == null) {
            this.acceptorRespondToHeader();
        }
        return this.headerIn;
    }

    @Override
    public ChannelHeader headerInToUse() {
        if (this.headerInToUse == null) {
            this.acceptorRespondToHeader();
        }
        return this.headerInToUse;
    }

    private void readHeader() throws InvalidMarshallableException {
        while (!Thread.currentThread().isInterrupted()) {
            DocumentContext dc = this.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) {
                    Thread.yield();
                    continue;
                }
                String s = dc.wire().readEvent(String.class);
                if (!HEADER.equals(s)) {
                    Jvm.warn().on(this.getClass(), "Unexpected first message type " + s);
                }
                this.headerIn = dc.wire().getValueIn().object(ChannelHeader.class);
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
            }
        }
        this.in.bytes().singleThreadedCheckReset();
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.checkConnected();
        this.lock.lock();
        DocumentContext dc = this.out.writingDocument(metaData);
        this.dch.documentContext(dc);
        return this.dch;
    }

    public ChronicleChannelCfg connectionCfg() {
        return this.channelCfg;
    }

    @Override
    public void testMessage(long now) {
        try (DocumentContext dc = this.writingDocument(true);){
            dc.wire().write("testMessage").writeLong(NanoTime.INSTANCE, now);
        }
        catch (Exception e) {
            if (this.isClosing()) {
                Jvm.debug().on(this.getClass(), "Ignoring testMessage exception as it is closing " + e);
                return;
            }
            throw e;
        }
    }

    @Override
    public long lastTestMessage() {
        return this.lastTestMessage;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.checkConnected();
        this.lock.lock();
        DocumentContext dc = this.out.acquireWritingDocument(metaData);
        this.dch.documentContext(dc);
        return this.dch;
    }

    @Override
    public boolean supportsEventPoller() {
        return false;
    }

    @Override
    public EventPoller eventPoller() {
        return null;
    }

    @Override
    public ChronicleChannel eventPoller(EventPoller eventPoller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Wire acquireProducer() {
        this.lock.lock();
        return this.out;
    }

    @Override
    public void releaseProducer() {
        this.flush();
        this.lock.unlock();
    }

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean recordHistory() {
        if (this.headerOut instanceof ChannelHandler && ((ChannelHandler)this.headerOut).recordHistory()) {
            return true;
        }
        return this.headerInToUse instanceof ChannelHandler && ((ChannelHandler)this.headerInToUse).recordHistory();
    }

    private class ConnectionDocumentContextHolder
    extends DocumentContextHolder
    implements WriteDocumentContext {
        private boolean chainedElement;

        private ConnectionDocumentContextHolder() {
        }

        @Override
        public void close() {
            super.close();
            if (!this.chainedElement) {
                try {
                    TCPChronicleChannel.this.flush();
                }
                catch (ClosedIORuntimeException closedIORuntimeException) {
                    // empty catch block
                }
            }
            TCPChronicleChannel.this.lock.unlock();
        }

        @Override
        public void start(boolean metaData) {
        }

        @Override
        public boolean chainedElement() {
            return this.chainedElement;
        }

        @Override
        public void chainedElement(boolean chainedElement) {
            this.chainedElement = chainedElement;
            DocumentContext dc = this.documentContext();
            if (dc instanceof WriteDocumentContext) {
                ((WriteDocumentContext)dc).chainedElement(chainedElement);
            }
        }
    }
}

