/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.CoreDynamicEnum;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.BitSetUtil;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ObjectIntObjectConsumer;
import net.openhft.chronicle.wire.RawText;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueOut {
    public static final ThreadLocal<MapMarshaller> MM_TL = ThreadLocal.withInitial(MapMarshaller::new);
    public static final int SMALL_MESSAGE = 64;
    public static final String ZEROS_64 = "0000000000000000000000000000000000000000000000000000000000000000";

    public static boolean isAnEnum(Object v) {
        return v instanceof Enum || v instanceof DynamicEnum;
    }

    @NotNull
    public WireOut bool(Boolean var1);

    @NotNull
    public WireOut text(@Nullable CharSequence var1);

    @NotNull
    default public WireOut text(@Nullable String s) {
        return this.text((CharSequence)s);
    }

    @NotNull
    default public WireOut nu11() {
        return this.text((CharSequence)null);
    }

    @NotNull
    default public WireOut text(char c) {
        try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
            WireOut wireOut = this.text(((StringBuilder)stlSb.get()).append(c));
            return wireOut;
        }
    }

    @NotNull
    default public WireOut character(char c) {
        return this.text(c);
    }

    @NotNull
    default public WireOut text(@Nullable BytesStore s) {
        return this.text((CharSequence)s);
    }

    @NotNull
    default public WireOut int8(long x) {
        return this.int8(Maths.toInt8((long)x));
    }

    @NotNull
    public WireOut int8(byte var1);

    @NotNull
    public WireOut bytes(@Nullable BytesStore var1);

    @NotNull
    default public WireOut bytesLiteral(@Nullable BytesStore fromBytes) {
        return this.bytes(fromBytes);
    }

    @NotNull
    public WireOut bytes(String var1, @Nullable BytesStore var2);

    @NotNull
    public WireOut rawBytes(byte[] var1);

    @NotNull
    default public WireOut rawText(CharSequence value) {
        return this.text(value);
    }

    @NotNull
    public ValueOut writeLength(long var1);

    @NotNull
    public WireOut bytes(byte[] var1);

    @NotNull
    public WireOut bytes(String var1, byte[] var2);

    @NotNull
    default public WireOut uint8(int x) {
        return this.uint8checked(Maths.toUInt8((long)(x & 0xFF)));
    }

    @NotNull
    public WireOut uint8checked(int var1);

    @NotNull
    default public WireOut int16(long x) {
        return this.int16(Maths.toInt16((long)x));
    }

    @NotNull
    public WireOut int16(short var1);

    @NotNull
    default public WireOut uint16(long x) {
        return this.uint16checked((int)x);
    }

    @NotNull
    public WireOut uint16checked(int var1);

    @NotNull
    public WireOut utf8(int var1);

    @NotNull
    default public WireOut int32(long x) {
        return this.int32(Maths.toInt32((long)x));
    }

    @NotNull
    public WireOut int32(int var1);

    @NotNull
    default public WireOut int32(int i32, int previous) {
        return this.int32(i32);
    }

    @NotNull
    default public WireOut uint32(long x) {
        return this.uint32checked(x);
    }

    @NotNull
    public WireOut uint32checked(long var1);

    @NotNull
    public WireOut int64(long var1);

    @NotNull
    default public WireOut int64(long i64, long previous) {
        return this.int64(i64);
    }

    @NotNull
    public WireOut int128forBinding(long var1, long var3, TwoLongValue var5);

    @NotNull
    public WireOut int64_0x(long var1);

    @NotNull
    public WireOut int64array(long var1);

    @NotNull
    public WireOut int64array(long var1, LongArrayValues var3);

    @NotNull
    public WireOut float32(float var1);

    @NotNull
    public WireOut float64(double var1);

    @NotNull
    default public WireOut float32(float f, float previous) {
        return this.float32(f);
    }

    @NotNull
    default public WireOut float64(double d, double previous) {
        return this.float64(d);
    }

    @NotNull
    public WireOut time(LocalTime var1);

    @NotNull
    public WireOut zonedDateTime(ZonedDateTime var1);

    @NotNull
    public WireOut date(LocalDate var1);

    @NotNull
    public WireOut dateTime(LocalDateTime var1);

    @NotNull
    public ValueOut typePrefix(CharSequence var1);

    @NotNull
    default public ValueOut typePrefix(Class type) {
        return type == null ? this : this.typePrefix(this.classLookup().nameFor(type));
    }

    public ClassLookup classLookup();

    @NotNull
    default public WireOut typeLiteral(@Nullable Class type) {
        return type == null ? this.nu11() : this.typeLiteral((t, b) -> {
            Bytes cfr_ignored_0 = (Bytes)b.appendUtf8((CharSequence)this.classLookup().nameFor(t));
        }, type);
    }

    @NotNull
    default public WireOut typeLiteral(@Nullable Type type) {
        return type == null ? this.nu11() : (type instanceof Class ? this.typeLiteral((Class)type) : this.typeLiteral(type.getTypeName()));
    }

    @NotNull
    public WireOut typeLiteral(@Nullable CharSequence var1);

    @NotNull
    public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> var1, @Nullable Class var2);

    @NotNull
    public WireOut uuid(UUID var1);

    @NotNull
    public WireOut int32forBinding(int var1);

    @NotNull
    public WireOut int32forBinding(int var1, @NotNull IntValue var2);

    @NotNull
    public WireOut int64forBinding(long var1);

    @NotNull
    default public WireOut int128forBinding(long value, long value2) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public WireOut int64forBinding(long var1, @NotNull LongValue var3);

    @NotNull
    public WireOut boolForBinding(boolean var1, @NotNull BooleanValue var2);

    @NotNull
    default public WireOut sequence(WriteValue writer) {
        return this.sequence(writer, WriteValue::writeValue);
    }

    @NotNull
    default public <T> WireOut sequence(Iterable<T> t) {
        Class typePrefix = t instanceof SortedSet ? SortedSet.class : (t instanceof Set ? Set.class : null);
        if (typePrefix != null) {
            this.typePrefix(typePrefix);
        }
        WireOut result = this.sequence(t, (it, out) -> {
            for (Object o : it) {
                out.object(o);
            }
        });
        if (typePrefix != null) {
            this.endTypePrefix();
        }
        return result;
    }

    @NotNull
    public <T> WireOut sequence(T var1, BiConsumer<T, ValueOut> var2);

    @NotNull
    public <T, K> WireOut sequence(T var1, K var2, TriConsumer<T, K, ValueOut> var3) throws InvalidMarshallableException;

    default public <T> WireOut sequenceWithLength(T t, int length, ObjectIntObjectConsumer<T, ValueOut> writer) {
        boolean b = this.swapLeaf(true);
        WireOut sequence = this.sequence(t, length, writer::accept);
        this.swapLeaf(b);
        return sequence;
    }

    default public WireOut array(Bytes[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.bytes((BytesStore)a[i]);
            }
        });
    }

    default public WireOut array(double[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.float64(a[i]);
            }
        });
    }

    default public WireOut arrayDelta(double[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            if (len <= 0) {
                return;
            }
            out.float64(a[0]);
            double a0 = a[0];
            if (Double.isNaN(a0)) {
                a0 = 0.0;
            }
            for (int i = 1; i < len; ++i) {
                out.float64(Maths.round6((double)(a[i] - a0)));
            }
        });
    }

    default public WireOut array(boolean[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.bool(a[i]);
            }
        });
    }

    default public WireOut array(long[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.int64(a[i]);
            }
        });
    }

    default public WireOut arrayDelta(long[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            if (len <= 0) {
                return;
            }
            out.int64(a[0]);
            long a0 = a[0];
            for (int i = 1; i < len; ++i) {
                out.int64(a[i] - a0);
            }
        });
    }

    default public WireOut array(int[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.int32(a[i]);
            }
        });
    }

    default public WireOut array(byte[] array, int length) {
        return this.sequenceWithLength(array, length, (a, len, out) -> {
            for (int i = 0; i < len; ++i) {
                out.int8(a[i]);
            }
        });
    }

    @NotNull
    default public WireOut array(@NotNull WriteValue writer, @NotNull Class arrayType) {
        if (arrayType == String[].class) {
            this.typePrefix("String[] ");
        } else if (arrayType != Object[].class) {
            this.typePrefix(this.classLookup().nameFor(arrayType.getComponentType()) + "[]");
        }
        return this.sequence(writer);
    }

    @NotNull
    public WireOut marshallable(WriteMarshallable var1) throws InvalidMarshallableException;

    @NotNull
    public WireOut marshallable(Serializable var1) throws InvalidMarshallableException;

    @NotNull
    public WireOut map(Map var1) throws InvalidMarshallableException;

    default public boolean swapLeaf(boolean isLeaf) {
        return false;
    }

    @NotNull
    default public WireOut typedMarshallable(@Nullable WriteMarshallable marshallable) throws InvalidMarshallableException {
        if (marshallable == null) {
            return this.nu11();
        }
        String typeName = Wires.typeNameFor(this.classLookup(), marshallable);
        if (typeName != null) {
            this.typePrefix(typeName);
        }
        WireOut wire = this.marshallable(marshallable);
        if (typeName != null) {
            this.endTypePrefix();
        }
        return wire;
    }

    default public void endTypePrefix() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    default public WireOut typedMarshallable(@Nullable Serializable object) throws InvalidMarshallableException {
        if (object == null) {
            return this.nu11();
        }
        try {
            this.typePrefix(object.getClass());
            if (object instanceof WriteMarshallable) {
                WireOut wireOut = this.marshallable((WriteMarshallable)((Object)object));
                return wireOut;
            }
            if (object instanceof Enum) {
                WireOut wireOut = this.asEnum((Enum)((Object)object));
                return wireOut;
            }
            if (Wires.isScalar(object)) {
                if (object instanceof LocalDate) {
                    LocalDate d = (LocalDate)object;
                    try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                        WireOut wireOut = this.text(((StringBuilder)stlSb.get()).append(d.getYear()).append('-').append(d.getMonthValue() < 10 ? "0" : "").append(d.getMonthValue()).append('-').append(d.getDayOfMonth() < 10 ? "0" : "").append(d.getDayOfMonth()));
                        return wireOut;
                    }
                }
                WireOut wireOut = this.text(object.toString());
                return wireOut;
            }
            if (object instanceof Locale) {
                WireOut wireOut = this.text(((Locale)object).toLanguageTag());
                return wireOut;
            }
            WireOut wireOut = this.marshallable(object);
            return wireOut;
        }
        finally {
            this.endTypePrefix();
        }
    }

    @NotNull
    default public WireOut typedMarshallable(CharSequence typeName, WriteMarshallable object) throws InvalidMarshallableException {
        this.typePrefix(typeName);
        return this.marshallable(object);
    }

    @NotNull
    default public <E extends Enum<E>> WireOut asEnum(@Nullable E e) {
        return this.text(e == null ? null : e.name());
    }

    @NotNull
    default public <V> WireOut set(Set<V> coll) throws InvalidMarshallableException {
        return this.set(coll, null);
    }

    @NotNull
    default public <V> WireOut set(Set<V> coll, Class<V> assumedClass) throws InvalidMarshallableException {
        return this.collection(coll, assumedClass);
    }

    @NotNull
    default public <V> WireOut list(List<V> coll) throws InvalidMarshallableException {
        return this.list(coll, null);
    }

    @NotNull
    default public <V> WireOut list(List<V> coll, Class<V> assumedClass) throws InvalidMarshallableException {
        this.sequence(coll, assumedClass, (s, kls, out) -> {
            int size = s.size();
            for (int i = 0; i < size; ++i) {
                boolean wasLeaf = out.swapLeaf(true);
                this.marshallable((WriteMarshallable)s.get(i));
                out.swapLeaf(wasLeaf);
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public <V> WireOut collection(Collection<V> coll, Class<V> assumedClass) throws InvalidMarshallableException {
        this.sequence(coll, assumedClass, (s, kls, out) -> {
            for (Object v : s) {
                this.object((Class)kls, (Object)v);
            }
        });
        return this.wireOut();
    }

    @NotNull
    default public <V> WireOut object(@NotNull Class<V> expectedType, V v) throws InvalidMarshallableException {
        Class<Void> vClass;
        Class<Void> clazz = vClass = v == null ? Void.TYPE : v.getClass();
        if (v instanceof WriteMarshallable && !ValueOut.isAnEnum(v)) {
            if (ObjectUtils.matchingClass(expectedType, vClass)) {
                this.marshallable((WriteMarshallable)v);
            } else {
                this.typedMarshallable((WriteMarshallable)v);
            }
        } else if (v != null && ObjectUtils.matchingClass(expectedType, vClass)) {
            this.untypedObject(v);
        } else {
            this.object(v);
        }
        return this.wireOut();
    }

    @NotNull
    default public <K, V> WireOut marshallable(Map<K, V> map) throws InvalidMarshallableException {
        return this.marshallable(map, Object.class, Object.class, true);
    }

    @NotNull
    default public <K, V> WireOut marshallable(@Nullable Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass, boolean leaf) throws InvalidMarshallableException {
        if (map == null) {
            this.nu11();
            return this.wireOut();
        }
        MapMarshaller mapMarshaller = MM_TL.get();
        mapMarshaller.params(map, kClass, vClass, leaf);
        this.marshallable(mapMarshaller);
        return this.wireOut();
    }

    @NotNull
    default public WireOut object(@Nullable Object value) throws InvalidMarshallableException {
        String typeName;
        LongValue value2;
        if (value == null) {
            return this.nu11();
        }
        Class<?> valueClass = value.getClass();
        switch (valueClass.getName()) {
            case "[B": {
                this.typePrefix(byte[].class).bytes((byte[])value);
                this.endTypePrefix();
                return this.wireOut();
            }
            case "[S": 
            case "[C": 
            case "[I": 
            case "[J": 
            case "[F": 
            case "[D": 
            case "[Z": {
                ValueOut valueOut = this.typePrefix(valueClass);
                boolean wasLeaf = valueOut.swapLeaf(true);
                valueOut.sequence(value, (v, out) -> {
                    int len = Array.getLength(v);
                    for (int i = 0; i < len; ++i) {
                        out.untypedObject(Array.get(v, i));
                    }
                });
                valueOut.swapLeaf(wasLeaf);
                this.endTypePrefix();
                return this.wireOut();
            }
            case "net.openhft.chronicle.threads.NamedThreadFactory": {
                return this.text(((NamedThreadFactory)value).getName());
            }
            case "net.openhft.chronicle.wire.RawText": {
                return this.rawText(((RawText)value).text);
            }
            case "java.util.concurrent.atomic.AtomicReference": {
                return this.object(((AtomicReference)value).get());
            }
            case "java.util.concurrent.atomic.AtomicLong.class": {
                return this.int64(((AtomicLong)value).get());
            }
            case "java.util.concurrent.atomic.AtomicInteger": {
                return this.int32(((AtomicInteger)value).get());
            }
            case "java.util.concurrent.atomic.AtomicBoolean": {
                return this.bool(((AtomicBoolean)value).get());
            }
            case "java.lang.String": {
                return this.text((String)value);
            }
            case "java.lang.StringBuilder": {
                return this.text((StringBuilder)value);
            }
            case "java.lang.Byte": {
                return this.fixedInt8((Byte)value);
            }
            case "java.lang.Boolean": {
                return this.bool((Boolean)value);
            }
            case "java.lang.Character": {
                return this.text(value.toString());
            }
            case "java.lang.Class": {
                return this.typeLiteral((Class)value);
            }
            case "java.lang.Short": {
                return this.fixedInt16((Short)value);
            }
            case "java.lang.Integer": {
                return this.fixedInt32((Integer)value);
            }
            case "java.lang.Long": {
                return this.fixedInt64((Long)value);
            }
            case "java.lang.Double": {
                return this.fixedFloat64((Double)value);
            }
            case "java.lang.Float": {
                return this.fixedFloat32(((Float)value).floatValue());
            }
            case "[Ljava.lang.String;": {
                return this.array(v -> Stream.of((String[])value).forEach(v::text), Object[].class);
            }
            case "[Ljava.lang.Object;": {
                return this.array(v -> Stream.of((Object[])value).forEach(v::object), Object[].class);
            }
            case "java.time.LocalTime": {
                WireOut result = this.optionalTyped(LocalTime.class).time((LocalTime)value);
                this.endTypePrefix();
                return result;
            }
            case "java.time.LocalDate": {
                WireOut result = this.optionalTyped(LocalDate.class).date((LocalDate)value);
                this.endTypePrefix();
                return result;
            }
            case "java.time.LocalDateTime": {
                WireOut result = this.optionalTyped(LocalDateTime.class).dateTime((LocalDateTime)value);
                this.endTypePrefix();
                return result;
            }
            case "java.time.ZonedDateTime": {
                WireOut result = this.optionalTyped(ZonedDateTime.class).zonedDateTime((ZonedDateTime)value);
                this.endTypePrefix();
                return result;
            }
            case "java.util.BitSet": {
                this.typePrefix(BitSet.class);
                BitSet bs = (BitSet)value;
                boolean isYamlWire = YamlWireOut.YamlValueOut.class.isAssignableFrom(this.getClass());
                return this.sequence((ValueOut v) -> {
                    for (int i = 0; i < bs.size() >> 6; ++i) {
                        long l = BitSetUtil.getWord(bs, i);
                        WireOut wireOut = v.int64(l);
                        if (!isYamlWire) continue;
                        String bits = Long.toBinaryString(l);
                        wireOut.writeComment(ZEROS_64.substring(bits.length()) + bits);
                    }
                });
            }
            case "java.util.UUID": {
                WireOut result = this.optionalTyped(UUID.class).uuid((UUID)value);
                this.endTypePrefix();
                return result;
            }
            case "java.sql.Timestamp": 
            case "java.sql.Time": 
            case "java.util.Date": 
            case "java.sql.Date": {
                WireOut result = Wires.SerializeJavaLang.writeDate((Date)value, this.typePrefix(valueClass));
                this.endTypePrefix();
                return result;
            }
            case "java.util.GregorianCalendar": {
                GregorianCalendar gc = (GregorianCalendar)value;
                WireOut result = this.typePrefix(GregorianCalendar.class).untypedObject(gc.toZonedDateTime());
                this.endTypePrefix();
                return result;
            }
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.time.Duration": 
            case "java.io.File": {
                WireOut result = this.optionalTyped(valueClass).text(value.toString());
                this.endTypePrefix();
                return result;
            }
        }
        if (value instanceof WriteMarshallable) {
            if (ValueOut.isAnEnum(value)) {
                Jvm.debug().on(this.getClass(), "Treating " + valueClass + " as enum not WriteMarshallable");
                return this.typedScalar(value);
            }
            if (valueClass.getName().contains("$$Lambda")) {
                return this.marshallable((WriteMarshallable)value);
            }
            return this.typedMarshallable((WriteMarshallable)value);
        }
        if (value instanceof WriteBytesMarshallable) {
            if (!Wires.warnedUntypedBytesOnce) {
                Jvm.warn().on(ValueOut.class, "BytesMarshallable found in field which is not matching exactly, the object may not unmarshall correctly if that type is not specified: " + valueClass.getName() + ". The warning will not repeat so there may be more types affected.");
                Wires.warnedUntypedBytesOnce = true;
            }
            return this.bytesMarshallable((WriteBytesMarshallable)((BytesMarshallable)value));
        }
        if (value instanceof BytesStore) {
            return this.bytes((BytesStore)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Map) {
            if (value instanceof SortedMap) {
                this.typePrefix(SortedMap.class);
            }
            return this.map((Map)value);
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        if (ValueOut.isAnEnum(value)) {
            return this.typedScalar(value);
        }
        if (value instanceof Collection) {
            if (value instanceof SortedSet) {
                this.typePrefix(SortedSet.class);
            } else if (value instanceof Set) {
                this.typePrefix(Set.class);
            }
            return this.sequence((ValueOut v) -> ((Collection)value).forEach(v::object));
        }
        if (WireSerializedLambda.isSerializableLambda(valueClass)) {
            WireSerializedLambda.write(value, this);
            return this.wireOut();
        }
        if (Object[].class.isAssignableFrom(valueClass)) {
            @NotNull Class<?> type = valueClass.getComponentType();
            return this.array(v -> Stream.of((Object[])value).forEach(val -> v.object(type, val)), valueClass);
        }
        if (value instanceof Thread) {
            return this.text(((Thread)value).getName());
        }
        if (value instanceof Serializable) {
            return this.typedMarshallable((Serializable)value);
        }
        if (value instanceof ByteBuffer) {
            return this.object(BytesStore.wrap((ByteBuffer)((ByteBuffer)value)));
        }
        if (value instanceof LongValue) {
            value2 = (LongValue)value;
            return this.int64forBinding(value2.getValue(), value2);
        }
        if (value instanceof IntValue) {
            value2 = (IntValue)value;
            return this.int32forBinding(value2.getValue(), (IntValue)value2);
        }
        if (value instanceof Reference) {
            return this.object(((Reference)value).get());
        }
        if (Wires.isInternal(value)) {
            throw new IllegalArgumentException("type=" + valueClass + " is unsupported, it must either be of type Marshallable, String or AutoBoxed primitive Object");
        }
        try {
            typeName = Wires.typeNameFor(this.classLookup(), value);
        }
        catch (IllegalArgumentException e) {
            if (this.isBinary()) {
                throw e;
            }
            typeName = valueClass.getName();
        }
        if (typeName != null) {
            this.typePrefix(typeName);
        }
        this.marshallable((WireOut w) -> Wires.writeMarshallable(value, w));
        if (typeName != null) {
            this.endTypePrefix();
        }
        return this.wireOut();
    }

    default public WireOut bytesMarshallable(WriteBytesMarshallable value) throws InvalidMarshallableException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    default public ValueOut optionalTyped(Class aClass) {
        return this;
    }

    @NotNull
    default public WireOut fixedFloat32(float value) {
        return this.typePrefix(Float.TYPE).float32(value);
    }

    @NotNull
    default public WireOut fixedInt8(byte value) {
        return this.typePrefix(Byte.TYPE).int8(value);
    }

    @NotNull
    default public WireOut fixedInt16(short value) {
        return this.typePrefix(Short.TYPE).int16(value);
    }

    @NotNull
    default public WireOut fixedInt32(int value) {
        return this.typePrefix(Integer.TYPE).int32(value);
    }

    @NotNull
    default public WireOut fixedFloat64(double value) {
        return this.float64(value);
    }

    @NotNull
    default public WireOut fixedInt64(long value) {
        return this.int64(value);
    }

    @NotNull
    default public WireOut untypedObject(@Nullable Object value) throws InvalidMarshallableException {
        if (value == null) {
            return this.nu11();
        }
        switch (value.getClass().getName()) {
            case "[B": {
                return this.bytes((byte[])value);
            }
            case "java.lang.Byte": {
                return this.int8((Byte)value);
            }
            case "java.lang.Short": {
                return this.int16((Short)value);
            }
            case "java.lang.Integer": {
                return this.int32((Integer)value);
            }
            case "java.lang.Long": {
                return this.int64((Long)value);
            }
            case "java.lang.Double": {
                return this.float64((Double)value);
            }
            case "java.lang.Float": {
                return this.float32(((Float)value).floatValue());
            }
            case "java.time.LocalTime": {
                return this.time((LocalTime)value);
            }
            case "java.time.LocalDate": {
                return this.date((LocalDate)value);
            }
            case "java.time.LocalDateTime": {
                return this.dateTime((LocalDateTime)value);
            }
            case "java.time.ZonedDateTime": {
                return this.zonedDateTime((ZonedDateTime)value);
            }
            case "java.util.UUID": {
                return this.uuid((UUID)value);
            }
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.io.File": {
                return this.text(value.toString());
            }
        }
        if (ValueOut.isAnEnum(value)) {
            String name = value instanceof DynamicEnum ? ((DynamicEnum)value).name() : ((Enum)value).name();
            return this.text(name);
        }
        if (value instanceof Marshallable) {
            return this.marshallable((Marshallable)value);
        }
        if (value instanceof WriteBytesMarshallable) {
            return this.bytesMarshallable((WriteBytesMarshallable)((BytesMarshallable)value));
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            @NotNull Class<?> type = value.getClass().getComponentType();
            return this.array(v -> Stream.of((Object[])value).forEach(val -> v.object(type, val)), Object[].class);
        }
        return this.object(value);
    }

    @NotNull
    default public WireOut typedScalar(@NotNull Object value) {
        this.typePrefix(Wires.typeNameFor(this.classLookup(), value));
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        if (value instanceof CoreDynamicEnum) {
            value = ((CoreDynamicEnum)value).name();
        } else if (!(value instanceof CharSequence)) {
            value = value.toString();
        }
        this.text((CharSequence)value);
        this.endTypePrefix();
        return this.wireOut();
    }

    @NotNull
    default public WireOut throwable(@NotNull Throwable t) throws InvalidMarshallableException {
        this.typedMarshallable(t.getClass().getName(), w -> {
            w.write("message").text(t.getMessage()).write("stackTrace").sequence((ValueOut w3) -> {
                for (StackTraceElement ste : t.getStackTrace()) {
                    w3.marshallable((WireOut w4) -> w4.write("class").text(ste.getClassName()).write("method").text(ste.getMethodName()).write("file").text(ste.getFileName()).write("line").int32(ste.getLineNumber()));
                }
            });
            if (t.getCause() != null) {
                w.write("cause").throwable(t.getCause());
            }
        });
        return this.wireOut();
    }

    @NotNull
    public WireOut wireOut();

    @NotNull
    default public WireOut compress(@NotNull String compression, @Nullable Bytes<?> uncompressedBytes) {
        if (uncompressedBytes == null) {
            return this.nu11();
        }
        if (uncompressedBytes.readRemaining() < 64L) {
            return this.bytes((BytesStore)uncompressedBytes);
        }
        try (ScopedResource<Bytes<?>> stlBytes = Wires.acquireBytesScoped();){
            Bytes tmpBytes = (Bytes)stlBytes.get();
            Compression.compress((CharSequence)compression, uncompressedBytes, (Bytes)tmpBytes);
            this.bytes(compression, (BytesStore)tmpBytes);
            WireOut wireOut = this.wireOut();
            return wireOut;
        }
    }

    default public int compressedSize() {
        return Integer.MAX_VALUE;
    }

    default public void resetBetweenDocuments() {
        this.resetState();
    }

    public void resetState();

    default public boolean isBinary() {
        return false;
    }

    default public WireOut writeBoolean(boolean x) {
        return this.bool(x);
    }

    default public WireOut writeByte(byte x) {
        return this.int8(x);
    }

    default public WireOut writeChar(char x) {
        return this.uint16(x);
    }

    default public WireOut writeShort(short x) {
        return this.int16(x);
    }

    default public WireOut writeInt(int x) {
        return this.int32(x);
    }

    default public WireOut writeLong(long x) {
        return this.int64(x);
    }

    default public WireOut writeFloat(float x) {
        return this.float32(x);
    }

    default public WireOut writeDouble(double x) {
        return this.float64(x);
    }

    default public WireOut writeString(CharSequence x) {
        return this.text(x);
    }

    default public WireOut writeInt(IntConverter intConverter, int i) {
        try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            intConverter.append(sb, i);
            WireOut wireOut = this.rawText(sb);
            return wireOut;
        }
    }

    default public WireOut writeLong(LongConverter longConverter, long l) {
        try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            longConverter.append(sb, l);
            if (longConverter.allSafeChars(this.wireOut()) && sb.length() > 0) {
                WireOut wireOut = this.rawText(sb);
                return wireOut;
            }
            WireOut wireOut = this.text(sb);
            return wireOut;
        }
    }

    public static class MapMarshaller<K, V>
    implements WriteMarshallable {
        private Map<K, V> map;
        private Class<K> kClass;
        private Class<V> vClass;
        private boolean leaf;

        void params(@Nullable Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass, boolean leaf) {
            this.map = map;
            this.kClass = kClass;
            this.vClass = vClass;
            this.leaf = leaf;
        }

        @Override
        public void writeMarshallable(@NotNull WireOut wire) throws InvalidMarshallableException {
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                ValueOut valueOut = wire.writeEvent(this.kClass, entry.getKey());
                boolean wasLeaf = valueOut.swapLeaf(this.leaf);
                valueOut.object(this.vClass, entry.getValue());
                valueOut.swapLeaf(wasLeaf);
            }
        }
    }
}

