/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.reduction;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ExcerptListener;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import net.openhft.chronicle.wire.domestic.reduction.Reduction;
import org.jetbrains.annotations.NotNull;

public final class ReductionUtil {
    private ReductionUtil() {
    }

    public static long accept(@NotNull MarshallableIn tailer, @NotNull ExcerptListener excerptListener) throws InvalidMarshallableException {
        Objects.requireNonNull(tailer);
        long lastIndex = -1L;
        boolean end = false;
        while (!end) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                Wire wire = dc.wire();
                if (dc.isPresent() && wire != null) {
                    lastIndex = dc.index();
                    excerptListener.onExcerpt(wire, lastIndex);
                    continue;
                }
                end = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
            }
        }
        return lastIndex;
    }

    public static final class VanillaDoubleReductionBuilder
    implements Reduction.DoubleReductionBuilder {
        private final ToDoubleDocumentExtractor extractor;

        public VanillaDoubleReductionBuilder(@NotNull ToDoubleDocumentExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public <A> Reduction<DoubleSupplier> reducing(@NotNull Supplier<A> supplier, @NotNull ObjDoubleConsumer<A> accumulator, @NotNull ToDoubleFunction<A> finisher) {
            ObjectUtils.requireNonNull(supplier);
            ObjectUtils.requireNonNull(accumulator);
            ObjectUtils.requireNonNull(finisher);
            return new DoubleSupplierReduction<A>(this.extractor, supplier, accumulator, finisher);
        }
    }

    public static final class VanillaLongReductionBuilder
    implements Reduction.LongReductionBuilder {
        private final ToLongDocumentExtractor extractor;

        public VanillaLongReductionBuilder(@NotNull ToLongDocumentExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public <A> Reduction<LongSupplier> reducing(@NotNull Supplier<A> supplier, @NotNull ObjLongConsumer<A> accumulator, @NotNull ToLongFunction<A> finisher) {
            ObjectUtils.requireNonNull(supplier);
            ObjectUtils.requireNonNull(accumulator);
            ObjectUtils.requireNonNull(finisher);
            return new LongSupplierReduction<A>(this.extractor, supplier, accumulator, finisher);
        }
    }

    public static final class VanillaReductionBuilder<E>
    implements Reduction.ReductionBuilder<E> {
        private final DocumentExtractor<E> extractor;

        public VanillaReductionBuilder(@NotNull DocumentExtractor<E> extractor) {
            this.extractor = extractor;
        }

        @Override
        public <A, R> Reduction<R> collecting(@NotNull Collector<E, A, ? extends R> collector) {
            ObjectUtils.requireNonNull(collector);
            return new CollectorReduction<E, A, R>(this.extractor, collector);
        }
    }

    public static final class DoubleSupplierReduction<A>
    implements Reduction<DoubleSupplier> {
        private final ToDoubleDocumentExtractor extractor;
        private final ObjDoubleConsumer<A> accumulator;
        private final A accumulation;
        private final ToDoubleFunction<A> finisher;

        public DoubleSupplierReduction(@NotNull ToDoubleDocumentExtractor extractor, @NotNull Supplier<A> supplier, @NotNull ObjDoubleConsumer<A> accumulator, @NotNull ToDoubleFunction<A> finisher) {
            this.extractor = Objects.requireNonNull(extractor);
            this.accumulator = Objects.requireNonNull(accumulator);
            Objects.requireNonNull(supplier);
            this.accumulation = Objects.requireNonNull(supplier.get());
            this.finisher = Objects.requireNonNull(finisher);
        }

        @Override
        public void onExcerpt(@NotNull Wire wire, long index) throws InvalidMarshallableException {
            double element = this.extractor.extractAsDouble(wire, index);
            if (!Double.isNaN(element)) {
                this.accumulator.accept(this.accumulation, element);
            }
        }

        @Override
        @NotNull
        public DoubleSupplier reduction() {
            return () -> this.finisher.applyAsDouble(this.accumulation);
        }

        @Override
        public long accept(@NotNull MarshallableIn tailer) throws InvalidMarshallableException {
            Objects.requireNonNull(tailer);
            return ReductionUtil.accept(tailer, this);
        }
    }

    public static final class LongSupplierReduction<A>
    implements Reduction<LongSupplier> {
        private final ToLongDocumentExtractor extractor;
        private final ObjLongConsumer<A> accumulator;
        private final A accumulation;
        private final ToLongFunction<A> finisher;

        public LongSupplierReduction(@NotNull ToLongDocumentExtractor extractor, @NotNull Supplier<A> supplier, @NotNull ObjLongConsumer<A> accumulator, @NotNull ToLongFunction<A> finisher) {
            this.extractor = Objects.requireNonNull(extractor);
            this.accumulator = Objects.requireNonNull(accumulator);
            Objects.requireNonNull(supplier);
            this.accumulation = Objects.requireNonNull(supplier.get());
            this.finisher = Objects.requireNonNull(finisher);
        }

        @Override
        public void onExcerpt(@NotNull Wire wire, long index) throws InvalidMarshallableException {
            long element = this.extractor.extractAsLong(wire, index);
            if (element != Long.MIN_VALUE) {
                this.accumulator.accept(this.accumulation, element);
            }
        }

        @Override
        @NotNull
        public LongSupplier reduction() {
            return () -> this.finisher.applyAsLong(this.accumulation);
        }

        @Override
        public long accept(@NotNull MarshallableIn tailer) throws InvalidMarshallableException {
            Objects.requireNonNull(tailer);
            return ReductionUtil.accept(tailer, this);
        }
    }

    public static final class CollectorReduction<E, A, R>
    implements Reduction<R> {
        private final DocumentExtractor<E> extractor;
        private final Collector<E, A, ? extends R> collector;
        private final A accumulation;

        public CollectorReduction(@NotNull DocumentExtractor<E> extractor, @NotNull Collector<E, A, ? extends R> collector) {
            this.extractor = extractor;
            this.collector = collector;
            if (!collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT)) {
                Jvm.warn().on(CollectorReduction.class, "The collector " + collector + " should generally have the characteristics CONCURRENT");
            }
            this.accumulation = collector.supplier().get();
        }

        @Override
        public void onExcerpt(@NotNull Wire wire, long index) throws InvalidMarshallableException {
            E element = this.extractor.extract(wire, index);
            if (element != null) {
                this.collector.accumulator().accept(this.accumulation, element);
            }
        }

        @Override
        @NotNull
        public R reduction() {
            if (this.collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                return (R)this.accumulation;
            }
            return this.collector.finisher().apply(this.accumulation);
        }

        @Override
        public long accept(@NotNull MarshallableIn tailer) throws InvalidMarshallableException {
            Objects.requireNonNull(tailer);
            return ReductionUtil.accept(tailer, this);
        }
    }
}

