/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.channel.impl.internal.Handler;

public class ChronicleChannelCfg<C extends ChronicleChannelCfg<C>>
extends SelfDescribingMarshallable {
    private boolean initiator;
    private boolean buffered;
    private PauserMode pauser = PauserMode.yielding;
    private String hostname;
    private int port;
    private double connectionTimeoutSecs = 1.0;

    public ChronicleChannelCfg initiator(boolean initiator) {
        this.initiator = initiator;
        return this;
    }

    public boolean initiator() {
        return this.initiator;
    }

    public String hostname() {
        return this.hostname;
    }

    public C hostname(String hostname) {
        this.hostname = hostname;
        return (C)this;
    }

    public int port() {
        return this.port;
    }

    public C port(int port) {
        this.port = port;
        return (C)this;
    }

    public boolean buffered() {
        return this.buffered;
    }

    public C buffered(boolean buffered) {
        this.buffered = buffered;
        return (C)this;
    }

    public PauserMode pauserMode() {
        return this.pauser;
    }

    public C pauserMode(PauserMode pauser) {
        this.pauser = pauser;
        return (C)this;
    }

    public double connectionTimeoutSecs() {
        if (this.connectionTimeoutSecs <= 0.0) {
            return Jvm.isDebug() ? 120.0 : 10.0;
        }
        return this.connectionTimeoutSecs;
    }

    public C connectionTimeoutSecs(double connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        return (C)this;
    }

    static {
        Handler.init();
    }
}

