/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSVWire
extends TextWire {
    private static final ThreadLocal<WeakReference<StopCharTester>> ESCAPED_END_OF_TEXT = new ThreadLocal();
    static final Supplier<StopCharTester> COMMA_STOP_ESCAPING = () -> ((StopCharTesters)StopCharTesters.COMMA_STOP).escaping();
    private final List<String> header = new ArrayList<String>();

    public CSVWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super(bytes, use8bit);
        while (this.lineStart == 0L) {
            long start = bytes.readPosition();
            this.header.add(this.valueIn.text());
            if (bytes.readPosition() != start) continue;
            break;
        }
    }

    public CSVWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static CSVWire fromFile(String name) throws IOException {
        return new CSVWire(BytesUtil.readFile((String)name), true);
    }

    @NotNull
    public static CSVWire from(@NotNull String text) {
        return new CSVWire(Bytes.from((String)text));
    }

    @NotNull
    static StopCharTester getEscapingCSVEndOfText() {
        StopCharTester escaping = (StopCharTester)ThreadLocalHelper.getTL(ESCAPED_END_OF_TEXT, COMMA_STOP_ESCAPING);
        escaping.isStopChar(32);
        return escaping;
    }

    @Override
    @NotNull
    protected TextWire.TextValueOut createValueOut() {
        return new CSVValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new CSVValueIn();
    }

    @Override
    @NotNull
    public StringBuilder readField(@NotNull StringBuilder sb) {
        this.valueIn.text(sb);
        return sb;
    }

    public void consumePaddingStart() {
        block0: while (true) {
            int codePoint;
            if ((codePoint = this.peekCode()) == 35) {
                while (true) {
                    if (this.readCode() < 32) continue block0;
                }
            }
            if (!Character.isWhitespace(codePoint)) break;
            if (codePoint == 10 || codePoint == 13) {
                this.lineStart = this.bytes.readPosition() + 1L;
            }
            this.bytes.readSkip(1L);
        }
    }

    @Override
    public void consumePadding() {
        int codePoint;
        while (Character.isWhitespace(codePoint = this.peekCode()) && codePoint >= 32) {
            this.bytes.readSkip(1L);
        }
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumePadding();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        s.setLength(0);
        return this;
    }

    class CSVValueIn
    extends TextWire.TextValueIn {
        CSVValueIn() {
            super(CSVWire.this);
        }

        @Override
        public boolean hasNext() {
            CSVWire.this.consumePaddingStart();
            return CSVWire.this.bytes.readRemaining() > 0L;
        }

        @Nullable
        <ACS extends Appendable & CharSequence> ACS textTo0(@NotNull ACS a) {
            int prev;
            CSVWire.this.consumePadding();
            int ch = CSVWire.this.peekCode();
            switch (ch) {
                case 34: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, CSVWire.this.getEscapingQuotes());
                    } else {
                        CSVWire.this.bytes.parseUtf8(a, CSVWire.this.getEscapingQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code == 34) {
                        CSVWire.this.readCode();
                    }
                    if ((code = CSVWire.this.peekCode()) != 44) break;
                    CSVWire.this.readCode();
                    break;
                }
                case 39: {
                    CSVWire.this.bytes.readSkip(1L);
                    if (CSVWire.this.use8bit) {
                        CSVWire.this.bytes.parse8bit(a, TextWire.getEscapingSingleQuotes());
                    } else {
                        CSVWire.this.bytes.parseUtf8(a, TextWire.getEscapingSingleQuotes());
                    }
                    TextWire.unescape(a);
                    int code = CSVWire.this.peekCode();
                    if (code != 39) break;
                    CSVWire.this.readCode();
                    break;
                }
                default: {
                    if (CSVWire.this.bytes.readRemaining() > 0L) {
                        if (a instanceof Bytes || CSVWire.this.use8bit) {
                            CSVWire.this.bytes.parse8bit(a, CSVWire.getEscapingCSVEndOfText());
                        } else {
                            CSVWire.this.bytes.parseUtf8(a, CSVWire.getEscapingCSVEndOfText());
                        }
                    } else {
                        AppendableUtil.setLength(a, (int)0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                    }
                    break block0;
                }
            }
            if ((prev = this.peekBack()) == 58 || prev == 35 || prev == 125) {
                CSVWire.this.bytes.readSkip(-1L);
            }
            return a;
        }

        @Override
        protected long readLengthMarshallable() {
            long start = CSVWire.this.bytes.readPosition();
            try {
                CSVWire.this.consumePadding();
                while (true) {
                    int code = CSVWire.this.readCode();
                    switch (code) {
                        case -1: 
                        case 0: 
                        case 10: 
                        case 13: {
                            long l = CSVWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                }
            }
            finally {
                CSVWire.this.bytes.readPosition(start);
            }
        }

        @Override
        public boolean hasNextSequenceItem() {
            CSVWire.this.consumePadding();
            int ch = CSVWire.this.peekCode();
            if (ch == 44) {
                CSVWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean marshallable(@NotNull ReadMarshallable object) {
            if (this.isNull()) {
                return false;
            }
            this.pushState();
            long len = this.readLengthMarshallable();
            long limit = CSVWire.this.bytes.readLimit();
            long position = CSVWire.this.bytes.readPosition();
            long newLimit = position + len;
            try {
                CSVWire.this.bytes.readLimit(newLimit);
                CSVWire.this.consumePadding();
                object.readMarshallable(CSVWire.this);
            }
            finally {
                CSVWire.this.bytes.readLimit(limit);
                CSVWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            CSVWire.this.consumePadding();
            return true;
        }
    }

    class CSVValueOut
    extends TextWire.TextValueOut {
        CSVValueOut() {
            super(CSVWire.this);
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@Nullable CharSequence type) {
            if (type == null) {
                return this.nu11();
            }
            throw new UnsupportedOperationException("Type literals not supported in CSV, cannot write " + type);
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) {
            throw new UnsupportedOperationException("Serializable objects not supported in CSV, cannot write " + object);
        }
    }
}

