/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodWriter;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.MethodWriterValidationException;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.utils.JavaSourceCodeFormatter;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;
import net.openhft.compiler.CompilerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMethodWriter {
    public static final String UPDATE_INTERCEPTOR = UpdateInterceptor.class.getSimpleName();
    static final boolean DUMP_CODE = Jvm.getBoolean((String)"dumpCode");
    private static final String DOCUMENT_CONTEXT = DocumentContext.class.getSimpleName();
    private static final String WRITE_DOCUMENT_CONTEXT = WriteDocumentContext.class.getSimpleName();
    private static final String MARSHALLABLE_OUT = MarshallableOut.class.getSimpleName();
    private static final String METHOD_ID = MethodId.class.getSimpleName();
    private static final String VALUE_OUT = ValueOut.class.getSimpleName();
    private static final String CLOSEABLE = Closeable.class.getSimpleName();
    private static final String UPDATE_INTERCEPTOR_FIELD = "updateInterceptor";
    private static final Map<String, Map<List<Class<?>>, String>> TEMPLATE_METHODS = new LinkedHashMap();
    private final boolean metaData;
    private final boolean useMethodId;
    private final String packageName;
    private final Set<Class<?>> interfaces;
    private final String className;
    private final ClassLoader classLoader;
    private final WireType wireType;
    private final String genericEvent;
    private final boolean useUpdateInterceptor;
    private final ConcurrentMap<Class<?>, String> methodWritersMap = new ConcurrentHashMap();
    private final AtomicInteger indent = new AtomicInteger();

    private GenerateMethodWriter(String packageName, Set<Class<?>> interfaces, String className, ClassLoader classLoader, WireType wireType, String genericEvent, boolean metaData, boolean useMethodId, boolean useUpdateInterceptor) {
        this.packageName = packageName;
        this.interfaces = interfaces;
        this.className = className;
        this.classLoader = classLoader;
        this.wireType = wireType;
        this.genericEvent = genericEvent;
        this.metaData = metaData;
        this.useMethodId = useMethodId;
        this.useUpdateInterceptor = useUpdateInterceptor;
    }

    @Nullable
    public static Class<?> newClass(String fullClassName, Set<Class<?>> interfaces, ClassLoader classLoader, WireType wireType, String genericEvent, boolean metaData, boolean useMethodId, boolean useUpdateInterceptor) {
        int lastDot = fullClassName.lastIndexOf(46);
        String packageName = "";
        String className = fullClassName;
        if (lastDot != -1) {
            packageName = fullClassName.substring(0, lastDot);
            className = fullClassName.substring(lastDot + 1);
        }
        return new GenerateMethodWriter(packageName, interfaces, className, classLoader, wireType, genericEvent, metaData, useMethodId, useUpdateInterceptor).createClass();
    }

    public static DocumentContext acquireDocumentContext(boolean metaData, ThreadLocal<DocumentContextHolder> documentContextTL, MarshallableOut out) {
        DocumentContextHolder contextHolder = documentContextTL.get();
        if (!contextHolder.isClosed()) {
            return contextHolder;
        }
        contextHolder.documentContext(out.writingDocument(metaData));
        return contextHolder;
    }

    private static CharSequence toString(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return "bool";
        }
        if (Byte.TYPE.equals(type)) {
            return "writeByte";
        }
        if (Character.TYPE.equals(type)) {
            return "character";
        }
        if (Short.TYPE.equals(type)) {
            return "int16";
        }
        if (Integer.TYPE.equals(type)) {
            return "int32";
        }
        if (Long.TYPE.equals(type)) {
            return "int64";
        }
        if (Float.TYPE.equals(type)) {
            return "float32";
        }
        if (Double.TYPE.equals(type)) {
            return "float64";
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return "marshallable";
        }
        return "object";
    }

    @NotNull
    private static String nameForClass(Class type) {
        return type.getName().replace('$', '.');
    }

    @NotNull
    private static String nameForClass(Set<String> importSet, Class type) {
        if (type.isArray()) {
            return GenerateMethodWriter.nameForClass(importSet, type.getComponentType()) + "[]";
        }
        String s = GenerateMethodWriter.nameForClass(type);
        Package aPackage = type.getPackage();
        if (aPackage != null && (importSet.contains(s) || "java.lang".equals(aPackage.getName()) || !type.getName().contains("$") && importSet.contains(aPackage.getName() + ".*"))) {
            return type.getSimpleName();
        }
        return s;
    }

    private static String signature(Method m) {
        return m.getReturnType() + " " + m.getName() + " " + Arrays.toString(m.getParameterTypes());
    }

    @NotNull
    private Appendable methodSignature(SortedSet<String> importSet, Method dm) {
        JavaSourceCodeFormatter result = new JavaSourceCodeFormatter(this.indent);
        String sep = "";
        for (Parameter p : dm.getParameters()) {
            result.append(sep);
            sep = ", ";
            IntConversion intConversion = p.getAnnotation(IntConversion.class);
            LongConversion longConversion = p.getAnnotation(LongConversion.class);
            if (intConversion != null) {
                result.append("@IntConversion(").append(GenerateMethodWriter.nameForClass(importSet, intConversion.value())).append(".class) ");
            } else if (longConversion != null) {
                result.append("@LongConversion(").append(GenerateMethodWriter.nameForClass(importSet, longConversion.value())).append(".class) ");
            }
            result.append("final ").append(GenerateMethodWriter.nameForClass(importSet, p.getType())).append(' ').append(p.getName());
        }
        return result;
    }

    private Class<?> createClass() {
        SourceCodeFormatter interfaceMethods = new SourceCodeFormatter(1);
        JavaSourceCodeFormatter imports = new JavaSourceCodeFormatter();
        try {
            imports.append("package " + this.packageName + ";\n\n");
            TreeSet<String> importSet = new TreeSet<String>();
            importSet.add(IntConversion.class.getName());
            importSet.add(LongConversion.class.getName());
            importSet.add(GenerateMethodWriter.class.getName());
            importSet.add(MessageHistory.class.getName());
            importSet.add(MethodReader.class.getName());
            importSet.add(UpdateInterceptor.class.getName());
            importSet.add(MethodId.class.getName());
            importSet.add(GenerateMethodWriter.class.getName());
            importSet.add(DocumentContext.class.getName());
            importSet.add(WriteDocumentContext.class.getName());
            importSet.add(MethodWriterInvocationHandlerSupplier.class.getName());
            importSet.add(Jvm.class.getName());
            importSet.add(Closeable.class.getName());
            importSet.add(DocumentContextHolder.class.getName());
            importSet.add(InvocationHandler.class.getName());
            importSet.add(Method.class.getName());
            importSet.add(IntStream.class.getName());
            importSet.add(ArrayList.class.getName());
            importSet.add(List.class.getName());
            importSet.add(Supplier.class.getName());
            for (Class<?> interfaceClazz : this.interfaces) {
                importSet.add(GenerateMethodWriter.nameForClass(interfaceClazz));
                if (!interfaceClazz.isInterface()) {
                    throw new MethodWriterValidationException("expecting an interface instead of class=" + interfaceClazz.getName());
                }
                for (Method dm : interfaceClazz.getMethods()) {
                    String template;
                    if (dm.isDefault() || Modifier.isStatic(dm.getModifiers()) || (template = this.templateFor(dm, interfaceClazz)) != null) continue;
                    for (Class<?> pType : dm.getParameterTypes()) {
                        if (pType.isPrimitive() || pType.isArray() || pType.getPackage().getName().equals("java.lang")) continue;
                        importSet.add(GenerateMethodWriter.nameForClass(pType));
                    }
                }
            }
            importSet.removeIf(s -> s.startsWith("net.openhft.chronicle.bytes"));
            importSet.add("net.openhft.chronicle.bytes.*");
            importSet.removeIf(s -> s.startsWith("net.openhft.chronicle.wire"));
            importSet.add("net.openhft.chronicle.wire.*");
            for (String s2 : importSet) {
                imports.append("import ").append(s2).append(";\n");
            }
            imports.append("\npublic final class ").append(this.className).append(" implements ");
            HashSet<String> handledMethodSignatures = new HashSet<String>();
            HashSet<String> methodIds = new HashSet<String>();
            for (Class clazz : this.interfaces) {
                String interfaceName = GenerateMethodWriter.nameForClass(importSet, clazz);
                imports.append(interfaceName);
                imports.append(", ");
                if (!clazz.isInterface()) {
                    throw new MethodWriterValidationException("expecting an interface instead of class=" + clazz.getName());
                }
                for (Method dm : clazz.getMethods()) {
                    if (Modifier.isStatic(dm.getModifiers())) continue;
                    Class returnType = (Class)GenericReflection.getReturnType((Method)dm, (Type)clazz);
                    if (dm.isDefault() && !returnType.equals(Void.TYPE) && !returnType.isInterface() || !handledMethodSignatures.add(GenerateMethodWriter.signature(dm))) continue;
                    String template = this.templateFor(dm, clazz);
                    if (template == null) {
                        interfaceMethods.append(this.createMethod(importSet, dm, clazz, methodIds));
                        continue;
                    }
                    interfaceMethods.append(template);
                }
            }
            imports.append(MethodWriter.class.getSimpleName());
            imports.append(" {\n\n");
            this.constructorAndFields(importSet, this.className, imports);
            this.addMarshallableOut(imports);
            imports.append(interfaceMethods);
            imports.append("\n}\n");
            if (DUMP_CODE) {
                System.out.println(imports);
            }
            return CompilerUtils.CACHED_COMPILER.loadFromJava(this.classLoader, this.packageName + '.' + this.className, imports.toString());
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getCause() instanceof LinkageError) {
                try {
                    return Class.forName(this.packageName + '.' + this.className, true, this.classLoader);
                }
                catch (ClassNotFoundException x) {
                    throw Jvm.rethrow((Throwable)x);
                }
            }
            throw Jvm.rethrow((Throwable)((Object)e));
        }
        catch (MethodWriterValidationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + imports, e));
        }
    }

    private String templateFor(Method dm, Class interfaceType) {
        Map<List<Class<?>>, String> map = TEMPLATE_METHODS.get(dm.getName());
        if (map == null) {
            return null;
        }
        ArrayList<Class> sig = new ArrayList<Class>();
        sig.add((Class)GenericReflection.getReturnType((Method)dm, (Type)interfaceType));
        Collections.addAll(sig, dm.getParameterTypes());
        return map.get(sig);
    }

    private void addMarshallableOut(SourceCodeFormatter codeFormatter) {
        codeFormatter.append("@Override\n");
        codeFormatter.append("public void marshallableOut(MarshallableOut out) {\n");
        codeFormatter.append("this.out = () -> out;");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            codeFormatter.append(String.format("\n    this.%s.remove();", e.getValue()));
        }
        codeFormatter.append("\n}\n");
    }

    private CharSequence constructorAndFields(Set<String> importSet, String className, SourceCodeFormatter result) {
        result.append("// result\nprivate transient final Closeable closeable;\n");
        if (this.useUpdateInterceptor) {
            result.append("private transient final " + UPDATE_INTERCEPTOR + " " + UPDATE_INTERCEPTOR_FIELD + ";\n");
        }
        result.append("private transient Supplier<").append(MARSHALLABLE_OUT).append("> out;\n");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            result.append(String.format("private transient ThreadLocal<%s> %s;\n", GenerateMethodWriter.nameForClass(importSet, (Class)e.getKey()), e.getValue()));
        }
        result.append('\n');
        result.append(String.format("// constructor\npublic %s(Supplier<" + MARSHALLABLE_OUT + "> out, " + CLOSEABLE + " closeable, " + UpdateInterceptor.class.getSimpleName() + " " + UPDATE_INTERCEPTOR_FIELD + ") {\n", className));
        if (this.useUpdateInterceptor) {
            result.append("this.updateInterceptor= updateInterceptor;\n");
        }
        result.append("this.out = out;\nthis.closeable = closeable;");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            result.append(String.format("\n%s = ThreadLocal.withInitial(() -> out.get().methodWriter(%s.class));", e.getValue(), GenerateMethodWriter.nameForClass((Class)e.getKey())));
        }
        result.append("\n}\n\n");
        return result;
    }

    private CharSequence createMethod(SortedSet<String> importSet, Method dm, Class<?> interfaceClazz, Set<String> methodIds) {
        String eventName;
        boolean passthrough;
        if (Modifier.isStatic(dm.getModifiers())) {
            return "";
        }
        if (dm.getParameterTypes().length == 0 && dm.isDefault()) {
            return "";
        }
        int parameterCount = dm.getParameterCount();
        Parameter[] parameters = dm.getParameters();
        int len = parameters.length;
        Class returnType = (Class)GenericReflection.getReturnType((Method)dm, interfaceClazz);
        String typeName = GenerateMethodWriter.nameForClass(importSet, returnType);
        StringBuilder body = new StringBuilder();
        String methodIDAnotation = "";
        if (this.useUpdateInterceptor) {
            String name;
            if (parameterCount > 1) {
                Jvm.debug().on(this.getClass(), "Generated code to call updateInterceptor for " + dm + " only using last argument");
            }
            if (parameterCount > 0) {
                Class<?> type = parameters[parameterCount - 1].getType();
                if (type.isPrimitive()) {
                    Jvm.warn().on(this.getClass(), "Generated code to call updateInterceptor for " + dm + " will box and generate garbage");
                }
                name = parameters[parameterCount - 1].getName();
            } else {
                name = "null";
            }
            body.append("// updateInterceptor\nif (! this.updateInterceptor.update(\"" + dm.getName() + "\", " + name + ")) return" + this.returnDefault(returnType) + ";\n");
        }
        boolean terminating = returnType == Void.class || returnType == Void.TYPE || returnType.isPrimitive();
        boolean bl = passthrough = returnType == DocumentContext.class;
        if (!passthrough) {
            body.append("try (");
        }
        body.append("final ").append(WRITE_DOCUMENT_CONTEXT).append(" dc = (").append(WRITE_DOCUMENT_CONTEXT).append(") this.out.get().acquireWritingDocument(").append(this.metaData).append(")");
        if (passthrough) {
            body.append(";\n");
        } else {
            body.append(") {\n");
        }
        body.append("try {\n");
        body.append("dc.chainedElement(" + (!terminating && !passthrough) + ");\n");
        body.append("if (out.get().recordHistory()) MessageHistory.writeHistory(dc);\n");
        int startJ = 0;
        if (parameterCount > 0 && dm.getName().equals(this.genericEvent)) {
            eventName = parameters[0].getName();
            startJ = 1;
        } else {
            eventName = '\"' + dm.getName() + '\"';
        }
        methodIDAnotation = this.writeEventNameOrId(dm, body, eventName);
        if (methodIDAnotation.length() > 0 && !methodIds.add(methodIDAnotation)) {
            throw new MethodWriterValidationException("Duplicate methodIds. Cannot add " + methodIDAnotation + " to " + methodIds);
        }
        if (parameters.length > 0) {
            this.writeArrayOfParameters(dm, len, body, startJ);
        }
        if (dm.getParameterTypes().length == 0) {
            body.append("valueOut.text(\"\");\n");
        }
        body.append("} catch (Throwable t) {\n");
        body.append("dc.rollbackOnClose();\n");
        body.append("throw Jvm.rethrow(t);\n");
        body.append("}\n");
        if (!passthrough) {
            body.append("}\n");
        }
        return String.format("\n%s public %s %s(%s) {\n %s%s}\n", methodIDAnotation, typeName, dm.getName(), this.methodSignature(importSet, dm), body, this.methodReturn(importSet, dm, interfaceClazz));
    }

    private String returnDefault(Class<?> returnType) {
        if (returnType == Void.TYPE) {
            return "";
        }
        if (returnType.isPrimitive() || returnType == Void.class) {
            return " " + ObjectUtils.defaultValue(returnType);
        }
        return " this";
    }

    private String writeEventNameOrId(Method dm, StringBuilder body, String eventName) {
        Optional methodId;
        String methodID = "";
        Optional<Object> optional = this.useMethodId ? Arrays.stream(dm.getAnnotations()).filter(MethodId.class::isInstance).findFirst() : (methodId = Optional.empty());
        if (this.wireType != WireType.TEXT && this.wireType != WireType.YAML && methodId.isPresent()) {
            long value = ((MethodId)methodId.get()).value();
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventId(%s, %d);\n", eventName, value));
            methodID = String.format("@" + METHOD_ID + "(%d)\n", value);
        } else {
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventName(%s);\n", eventName));
        }
        return methodID;
    }

    private void writeArrayOfParameters(Method dm, int len, StringBuilder body, int startJ) {
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("valueOut.array(v -> {\n");
        }
        for (int j = startJ; j < len; ++j) {
            Optional<String> longConversion;
            Parameter p = dm.getParameters()[j];
            Optional<String> intConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == IntConversion.class).map(x -> ((IntConversion)x).value().getName()).findFirst();
            String name = intConversion.orElseGet(() -> GenerateMethodWriter.lambda$writeArrayOfParameters$6(longConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == LongConversion.class).map(x -> ((LongConversion)x).value().getName()).findFirst()));
            if (!(name.isEmpty() || WireType.TEXT != this.wireType && WireType.YAML != this.wireType)) {
                body.append(String.format("//todo improve this\nvalueOut.rawText(new %s().asText(%s));\n", name, p.getName()));
                continue;
            }
            if (p.getType().isPrimitive() || CharSequence.class.isAssignableFrom(p.getType())) {
                if (longConversion.isPresent()) {
                    body.append(String.format("%s.writeLong(%s.INSTANCE, %s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", longConversion.get(), p.getName()));
                    continue;
                }
                if (intConversion.isPresent()) {
                    body.append(String.format("%s.writeInt(%s.INSTANCE, %s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", intConversion.get(), p.getName()));
                    continue;
                }
                body.append(String.format("%s.%s(%s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", GenerateMethodWriter.toString(p.getType()), p.getName()));
                continue;
            }
            this.writeValue(dm, body, startJ, p);
        }
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("}, Object[].class);\n");
        }
    }

    private void writeValue(Method dm, StringBuilder body, int startJ, Parameter p) {
        String className = p.getType().getTypeName().replace('$', '.');
        body.append(dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut").append(".object(").append(className).append(".class, ").append(p.getName()).append(");\n");
    }

    private StringBuilder methodReturn(Set<String> importSet, Method dm, Class<?> interfaceClazz) {
        StringBuilder result = new StringBuilder();
        Class returnType = (Class)GenericReflection.getReturnType((Method)dm, interfaceClazz);
        if (returnType == Void.class || returnType == Void.TYPE) {
            return result;
        }
        if (returnType == DocumentContext.class) {
            result.append("return dc;\n");
        } else if (returnType.isAssignableFrom(interfaceClazz) || returnType == interfaceClazz) {
            result.append("return this;\n");
        } else if (returnType.isInterface()) {
            this.methodWritersMap.computeIfAbsent(returnType, k -> "methodWriter" + k.getSimpleName() + "TL");
            result.append("// method return\n");
            result.append(String.format("return methodWriter%sTL.get();\n", returnType.getSimpleName()));
        } else if (!returnType.isPrimitive()) {
            result.append("return null;\n");
        } else if (returnType == Boolean.TYPE) {
            result.append("return false;\n");
        } else if (returnType == Byte.TYPE) {
            result.append("return (byte)0;\n");
        } else {
            result.append("return 0;\n");
        }
        return result;
    }

    private static /* synthetic */ String lambda$writeArrayOfParameters$6(Optional longConversion) {
        return longConversion.orElse("");
    }

    static {
        Wires.init();
        TEMPLATE_METHODS.put("close", Collections.singletonMap(Collections.singletonList(Void.TYPE), "public void close() {\n   if (this.closeable != null) {\n        this.closeable.close();\n   }\n}\n"));
        TEMPLATE_METHODS.put("recordHistory", Collections.singletonMap(Collections.singletonList(Boolean.TYPE), "public boolean recordHistory() {\n    return out.get().recordHistory();\n}\n"));
        List dcBoolean = Stream.of(DocumentContext.class, Boolean.TYPE).collect(Collectors.toList());
        TEMPLATE_METHODS.put("acquireWritingDocument", Collections.singletonMap(dcBoolean, "public " + DOCUMENT_CONTEXT + " acquireWritingDocument(boolean metaData){\n    return out.get().acquireWritingDocument(metaData);\n}\n"));
        LinkedHashMap<List<Class>, String> wd = new LinkedHashMap<List<Class>, String>();
        wd.put(Collections.singletonList(DocumentContext.class), "public " + DOCUMENT_CONTEXT + " writingDocument(){\n    return out.get().writingDocument();\n}\n");
        wd.put(dcBoolean, "public " + DOCUMENT_CONTEXT + " writingDocument(boolean metaData){\nreturn out.get().writingDocument(metaData);\n}\n");
        TEMPLATE_METHODS.put("writingDocument", wd);
    }
}

