/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import net.openhft.chronicle.core.time.LongTime;
import net.openhft.chronicle.wire.LongConverter;

public class MicroTimestampLongConverter
implements LongConverter {
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final MicroTimestampLongConverter INSTANCE = new MicroTimestampLongConverter();
    private final ZoneId zoneId;
    private final DateTimeFormatter dtf;

    public MicroTimestampLongConverter() {
        this(System.getProperty("mtlc.zoneId", "UTC"));
    }

    public MicroTimestampLongConverter(String zoneId) {
        this.zoneId = ZoneId.of(zoneId);
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true);
        if (!this.zoneId.equals(UTC)) {
            builder.appendLiteral(' ').appendZoneOrOffsetId();
        }
        this.dtf = builder.toFormatter();
    }

    @Override
    public long parse(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0L;
        }
        try {
            if (text.length() > 4 && text.charAt(4) == '/') {
                text = text.toString().replace('/', '-');
            }
            TemporalAccessor parse = this.dtf.parse(text);
            long time = parse.getLong(ChronoField.EPOCH_DAY) * 86400000000L;
            if (parse.isSupported(ChronoField.MICRO_OF_DAY)) {
                time += parse.getLong(ChronoField.MICRO_OF_DAY);
            } else if (parse.isSupported(ChronoField.MILLI_OF_DAY)) {
                time += parse.getLong(ChronoField.MILLI_OF_DAY) * 1000L;
            } else if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
                time += parse.getLong(ChronoField.SECOND_OF_DAY) * 1000000L;
            }
            return time;
        }
        catch (DateTimeParseException dtpe) {
            try {
                long number = LongTime.toMicros((long)Long.parseLong(text.toString()));
                if (LongTime.isMicros((long)number)) {
                    System.out.println("In input data, replace " + text + " with " + this.asString(number));
                } else if (number != 0L) {
                    System.out.println("In input data, replace " + text + " with a real date.");
                }
                return number;
            }
            catch (NumberFormatException e) {
                throw dtpe;
            }
        }
    }

    @Override
    public void append(StringBuilder text, long value) {
        if (value <= 0L) {
            text.append(value);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(value / 1000000L, (int)(value % 1000000L * 1000L), ZoneOffset.UTC);
        if (this.zoneId.equals(UTC)) {
            this.dtf.formatTo(ldt, text);
        } else {
            this.dtf.formatTo(ZonedDateTime.of(ldt, this.zoneId), text);
        }
    }
}

