/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodWriterListener;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodWriter;
import net.openhft.chronicle.wire.MethodWriterInvocationHandlerSupplier;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.utils.JavaSourceCodeFormatter;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;
import net.openhft.compiler.CompilerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMethodWriter {
    public static final String UPDATE_INTERCEPTOR = UpdateInterceptor.class.getSimpleName();
    static final boolean DUMP_CODE = Jvm.getBoolean((String)"dumpCode");
    private static final String DOCUMENT_CONTEXT = DocumentContext.class.getSimpleName();
    private static final String MARSHALLABLE_OUT = MarshallableOut.class.getSimpleName();
    private static final String METHOD_ID = MethodId.class.getSimpleName();
    private static final String VALUE_OUT = ValueOut.class.getSimpleName();
    private static final String CLOSEABLE = Closeable.class.getSimpleName();
    private static final String MARSHALLABLE = Marshallable.class.getSimpleName();
    private static final String UPDATE_INTERCEPTOR_FIELD = "updateInterceptor";
    private final boolean metaData;
    private final boolean useMethodId;
    private final String packageName;
    private final Set<Class> interfaces;
    private final String className;
    private final ClassLoader classLoader;
    private final WireType wireType;
    private final String genericEvent;
    private final boolean useUpdateInterceptor;
    private ConcurrentMap<Class, String> methodWritersMap = new ConcurrentHashMap<Class, String>();
    private boolean hasMethodWriterListener;
    private AtomicInteger indent = new AtomicInteger();

    private GenerateMethodWriter(String packageName, Set<Class> interfaces, String className, ClassLoader classLoader, WireType wireType, String genericEvent, boolean hasMethodWriterListener, boolean metaData, boolean useMethodId, boolean useUpdateInterceptor) {
        this.packageName = packageName;
        this.interfaces = interfaces;
        this.className = className;
        this.classLoader = classLoader;
        this.wireType = wireType;
        this.genericEvent = genericEvent;
        this.hasMethodWriterListener = hasMethodWriterListener;
        this.metaData = metaData;
        this.useMethodId = useMethodId;
        this.useUpdateInterceptor = useUpdateInterceptor;
    }

    @Nullable
    public static Class newClass(String fullClassName, Set<Class> interfaces, ClassLoader classLoader, WireType wireType, String genericEvent, boolean hasMethodWriterListener, boolean metaData, boolean useMethodId, boolean useUpdateInterceptor) {
        int lastDot = fullClassName.lastIndexOf(46);
        String packageName = "";
        String className = fullClassName;
        if (lastDot != -1) {
            packageName = fullClassName.substring(0, lastDot);
            className = fullClassName.substring(lastDot + 1);
        }
        return new GenerateMethodWriter(packageName, interfaces, className, classLoader, wireType, genericEvent, hasMethodWriterListener, metaData, useMethodId, useUpdateInterceptor).createClass();
    }

    public static DocumentContext acquireDocumentContext(boolean metaData, ThreadLocal<DocumentContextHolder> documentContextTL, MarshallableOut out) {
        DocumentContextHolder contextHolder = documentContextTL.get();
        if (!contextHolder.isClosed()) {
            return contextHolder;
        }
        contextHolder.documentContext(out.writingDocument(metaData));
        return contextHolder;
    }

    @Deprecated
    public static void addComment(Bytes<?> bytes, Object arg) {
        if (arg instanceof Marshallable) {
            bytes.comment((CharSequence)arg.getClass().getSimpleName());
        } else {
            bytes.comment((CharSequence)String.valueOf(arg));
        }
    }

    private static CharSequence toString(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return "bool";
        }
        if (Byte.TYPE.equals(type)) {
            return "writeByte";
        }
        if (Character.TYPE.equals(type)) {
            return "character";
        }
        if (Short.TYPE.equals(type)) {
            return "int16";
        }
        if (Integer.TYPE.equals(type)) {
            return "fixedInt32";
        }
        if (Long.TYPE.equals(type)) {
            return "fixedInt64";
        }
        if (Float.TYPE.equals(type)) {
            return "fixedFloat32";
        }
        if (Double.TYPE.equals(type)) {
            return "fixedFloat64";
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Marshallable.class.isAssignableFrom(type)) {
            return "marshallable";
        }
        return "object";
    }

    @NotNull
    private static String nameForClass(Class type) {
        return type.getName().replace('$', '.');
    }

    @NotNull
    private static String nameForClass(Set<String> importSet, Class type) {
        if (type.isArray()) {
            return GenerateMethodWriter.nameForClass(importSet, type.getComponentType()) + "[]";
        }
        String s = GenerateMethodWriter.nameForClass(type);
        Package aPackage = type.getPackage();
        if (aPackage != null && (importSet.contains(s) || "java.lang".equals(aPackage.getName()) || !type.getName().contains("$") && importSet.contains(aPackage.getName() + ".*"))) {
            return type.getSimpleName();
        }
        return s;
    }

    @NotNull
    private Appendable methodSignature(SortedSet<String> importSet, Method dm, int len) throws IOException {
        JavaSourceCodeFormatter result = new JavaSourceCodeFormatter(this.indent);
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            String className = GenerateMethodWriter.nameForClass(importSet, p.getType());
            Optional<String> intConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == IntConversion.class).map(x -> ((IntConversion)x).value().getName()).findFirst();
            Optional<String> longConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == LongConversion.class).map(x -> ((LongConversion)x).value().getName()).findFirst();
            if (intConversion.isPresent()) {
                result.append("@IntConversion(").append(intConversion.get()).append(".class) ");
            } else {
                longConversion.ifPresent(s -> {
                    try {
                        result.append("@LongConversion(").append((CharSequence)s).append(".class) ");
                    }
                    catch (Exception w) {
                        throw Jvm.rethrow((Throwable)w);
                    }
                });
            }
            result.append("final ");
            result.append(className);
            result.append(' ').append(p.getName());
            if (j == len - 1) break;
            result.append(',');
        }
        return result;
    }

    private Class createClass() {
        SourceCodeFormatter interfaceMethods = new SourceCodeFormatter(1);
        JavaSourceCodeFormatter imports = new JavaSourceCodeFormatter();
        try {
            imports.append("package " + this.packageName + ";\n\n");
            TreeSet<String> importSet = new TreeSet<String>();
            importSet.add(IntConversion.class.getName());
            importSet.add(LongConversion.class.getName());
            importSet.add(GenerateMethodWriter.class.getName());
            importSet.add(MessageHistory.class.getName());
            importSet.add(MethodReader.class.getName());
            importSet.add(UpdateInterceptor.class.getName());
            importSet.add(MethodId.class.getName());
            importSet.add(GenerateMethodWriter.class.getName());
            importSet.add(DocumentContext.class.getName());
            importSet.add(MethodWriterInvocationHandlerSupplier.class.getName());
            importSet.add(Jvm.class.getName());
            importSet.add(Closeable.class.getName());
            importSet.add(DocumentContextHolder.class.getName());
            importSet.add(MethodWriterListener.class.getName());
            importSet.add(InvocationHandler.class.getName());
            importSet.add(Method.class.getName());
            importSet.add(IntStream.class.getName());
            importSet.add(ArrayList.class.getName());
            importSet.add(List.class.getName());
            for (Class clazz : this.interfaces) {
                importSet.add(GenerateMethodWriter.nameForClass(clazz));
                if (!clazz.isInterface()) {
                    throw new IllegalArgumentException("expecting and interface instead of class=" + clazz.getName());
                }
                for (Method dm : clazz.getMethods()) {
                    if (dm.isDefault() || Modifier.isStatic(dm.getModifiers())) continue;
                    for (Class<?> pType : dm.getParameterTypes()) {
                        if (pType.isPrimitive() || pType.isArray() || pType.getPackage().getName().equals("java.lang")) continue;
                        importSet.add(GenerateMethodWriter.nameForClass(pType));
                    }
                }
            }
            importSet.removeIf(s -> s.startsWith("net.openhft.chronicle.bytes"));
            importSet.add("net.openhft.chronicle.bytes.*");
            importSet.removeIf(s -> s.startsWith("net.openhft.chronicle.wire"));
            importSet.add("net.openhft.chronicle.wire.*");
            for (String string : importSet) {
                imports.append("import ").append(string).append(";\n");
            }
            imports.append("\npublic final class ").append(this.className).append(" implements ");
            for (Class<Object> clazz : this.interfaces) {
                String interfaceName = GenerateMethodWriter.nameForClass(importSet, clazz);
                imports.append(interfaceName);
                imports.append(", ");
                if (!clazz.isInterface()) {
                    throw new IllegalArgumentException("expecting and interface instead of class=" + clazz.getName());
                }
                for (Method dm : clazz.getMethods()) {
                    if (dm.isDefault() || Modifier.isStatic(dm.getModifiers())) continue;
                    interfaceMethods.append(this.createMethod(importSet, dm, clazz));
                }
            }
            imports.append(MethodWriter.class.getSimpleName());
            imports.append(" {\n\n");
            this.constructorAndFields(importSet, this.className, imports);
            this.addMarshallableOut(imports);
            imports.append(interfaceMethods);
            imports.append("\n}\n");
            if (DUMP_CODE) {
                System.out.println(imports);
            }
            return CompilerUtils.CACHED_COMPILER.loadFromJava(this.classLoader, this.packageName + '.' + this.className, imports.toString());
        }
        catch (LinkageError e) {
            try {
                return Class.forName(this.packageName + '.' + this.className, true, this.classLoader);
            }
            catch (ClassNotFoundException x) {
                throw Jvm.rethrow((Throwable)x);
            }
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + imports, e));
        }
    }

    private void addMarshallableOut(SourceCodeFormatter imports) {
        imports.append("   @Override\n   public void marshallableOut(MarshallableOut out){\n        this.out=out;\n");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            imports.append(String.format("    this.%s.remove();\n", e.getValue()));
        }
        imports.append("}\n");
    }

    private CharSequence constructorAndFields(Set<String> importSet, String className, SourceCodeFormatter result) {
        result.append("// result\nprivate transient final Closeable closeable;\n");
        if (this.hasMethodWriterListener) {
            result.append("private transient final MethodWriterListener methodWriterListener;\n");
        }
        if (this.useUpdateInterceptor) {
            result.append("private transient final " + UPDATE_INTERCEPTOR + " " + UPDATE_INTERCEPTOR_FIELD + ";\n");
        }
        result.append("private transient ").append(MARSHALLABLE_OUT).append(" out;\n");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            result.append(String.format("private transient ThreadLocal<%s> %s;\n", GenerateMethodWriter.nameForClass(importSet, (Class)e.getKey()), e.getValue()));
        }
        result.append('\n');
        result.append(String.format("// constructor\npublic %s(" + MARSHALLABLE_OUT + " out, " + CLOSEABLE + " closeable, MethodWriterListener methodWriterListener, " + UpdateInterceptor.class.getSimpleName() + " " + UPDATE_INTERCEPTOR_FIELD + ") {\n", className));
        if (this.hasMethodWriterListener) {
            result.append("this.methodWriterListener = methodWriterListener;\n");
        }
        if (this.useUpdateInterceptor) {
            result.append("this.updateInterceptor= updateInterceptor;\n");
        }
        result.append("this.out = out;\nthis.closeable = closeable;\n");
        for (Map.Entry e : this.methodWritersMap.entrySet()) {
            result.append(String.format("%s = ThreadLocal.withInitial(() -> out.methodWriter(%s.class));\n", e.getValue(), GenerateMethodWriter.nameForClass((Class)e.getKey())));
        }
        result.append("}\n\n");
        return result;
    }

    private CharSequence createMethod(SortedSet<String> importSet, Method dm, Class<?> interfaceClazz) throws IOException {
        if (Modifier.isStatic(dm.getModifiers())) {
            return "";
        }
        if (dm.getParameterTypes().length == 0 && dm.isDefault()) {
            return "";
        }
        int parameterCount = dm.getParameterCount();
        Parameter[] parameters = dm.getParameters();
        int len = parameters.length;
        Class<?> returnType = dm.getReturnType();
        String typeName = GenerateMethodWriter.nameForClass(importSet, returnType);
        StringBuilder body = new StringBuilder();
        String methodIDAnotation = "";
        if (dm.getReturnType() == Void.TYPE && "close".equals(dm.getName()) && parameterCount == 0) {
            body.append("if (this.closeable != null) {\n    this.closeable.close();\n}\n");
        } else {
            String eventName;
            boolean terminating;
            Class<?> type;
            if (parameterCount >= 1 && this.useUpdateInterceptor && !(type = parameters[parameterCount - 1].getType()).isPrimitive()) {
                String name = parameters[parameterCount - 1].getName();
                body.append("// updateInterceptor\nif (! this.updateInterceptor.update(\"" + dm.getName() + "\", " + name + ")) return;\n");
            }
            boolean bl = terminating = returnType == Void.class || returnType == Void.TYPE || returnType.isPrimitive();
            if (terminating) {
                body.append("try (");
            }
            body.append("final " + DOCUMENT_CONTEXT + " dc = this.out.acquireWritingDocument(").append(this.metaData).append(")");
            if (terminating) {
                body.append(") {\n");
            } else {
                body.append(";\n");
            }
            body.append("if (out.recordHistory()) MessageHistory.writeHistory(dc);\n");
            int startJ = 0;
            if (parameterCount > 0 && dm.getName().equals(this.genericEvent)) {
                eventName = parameters[0].getName();
                startJ = 1;
            } else {
                eventName = '\"' + dm.getName() + '\"';
            }
            methodIDAnotation = this.writeEventNameOrId(dm, body, eventName);
            if (this.hasMethodWriterListener && parameterCount > 0) {
                this.createMethodWriterListener(dm, body);
            } else if (parameters.length > 0) {
                this.writeArrayOfParameters(dm, len, body, startJ);
            }
            if (dm.getParameterTypes().length == 0) {
                body.append("valueOut.text(\"\");\n");
            }
            if (terminating) {
                body.append("}\n");
            }
        }
        return String.format("\n%s public %s %s(%s) {\n %s%s}\n", methodIDAnotation, typeName, dm.getName(), this.methodSignature(importSet, dm, len), body, this.methodReturn(importSet, dm, interfaceClazz));
    }

    private String writeEventNameOrId(Method dm, StringBuilder body, String eventName) {
        Optional methodId;
        String methodID = "";
        Optional<Object> optional = methodId = this.useMethodId ? Arrays.stream(dm.getAnnotations()).filter(f -> f instanceof MethodId).findFirst() : Optional.empty();
        if (this.wireType != WireType.TEXT && this.wireType != WireType.YAML && methodId.isPresent()) {
            long value = ((MethodId)methodId.get()).value();
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventId(%s, %d);\n", eventName, value));
            methodID = String.format("@" + METHOD_ID + "(%d)\n", value);
        } else {
            body.append(String.format("final " + VALUE_OUT + " valueOut = dc.wire().writeEventName(%s);\n", eventName));
        }
        return methodID;
    }

    private void writeArrayOfParameters(Method dm, int len, StringBuilder body, int startJ) {
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("valueOut.array(v -> {\n");
        }
        for (int j = startJ; j < len; ++j) {
            Optional<String> longConversion;
            Parameter p = dm.getParameters()[j];
            Optional<String> intConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == IntConversion.class).map(x -> ((IntConversion)x).value().getName()).findFirst();
            String name = intConversion.orElseGet(() -> GenerateMethodWriter.lambda$writeArrayOfParameters$12(longConversion = Arrays.stream(p.getAnnotations()).filter(a -> a.annotationType() == LongConversion.class).map(x -> ((LongConversion)x).value().getName()).findFirst()));
            if (!(name.isEmpty() || WireType.TEXT != this.wireType && WireType.YAML != this.wireType)) {
                body.append(String.format("//todo improve this\nvalueOut.rawText(new %s().asText(%s));\n", name, p.getName()));
                continue;
            }
            if (p.getType().isPrimitive() || CharSequence.class.isAssignableFrom(p.getType())) {
                body.append(String.format("%s.%s(%s);\n", dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut", GenerateMethodWriter.toString(p.getType()), p.getName()));
                continue;
            }
            this.writeValue(dm, body, startJ, p);
        }
        if (dm.getParameterTypes().length > startJ + 1) {
            body.append("}, Object[].class);\n");
        }
    }

    private void writeValue(Method dm, StringBuilder body, int startJ, Parameter p) {
        String className = p.getType().getTypeName().replace('$', '.');
        body.append(dm.getParameterTypes().length > startJ + 1 ? "v" : "valueOut").append(".object(").append(className).append(".class, ").append(p.getName()).append(");\n");
    }

    private void createMethodWriterListener(Method dm, StringBuilder body) {
        body.append("Object[] args$$ = new Object[]{\n");
        for (int i1 = 0; i1 < dm.getParameters().length; ++i1) {
            body.append("(Object)").append(dm.getParameters()[i1].getName());
            if (i1 >= dm.getParameters().length - 1) continue;
            body.append(",\n");
        }
        body.append("\n};\n");
        body.append(String.format("this.methodWriterListener.onWrite(\"%s\",args$$);\n", dm.getName()));
        if (dm.getParameterCount() == 1) {
            if (Marshallable.class.isAssignableFrom(dm.getParameterTypes()[0])) {
                body.append(String.format("if (args$$[0].getClass() == %s.class){\n", dm.getParameterTypes()[0].getName().replace('$', '.')));
                body.append("valueOut.marshallable((").append(MARSHALLABLE).append(")args$$[0]);\n");
                body.append("} else {\n");
                body.append("valueOut.object(args$$[0]);\n}\n");
            } else {
                body.append("valueOut.object(args$$[0]);\n");
            }
        } else {
            body.append("valueOut.object(args$$);\n");
        }
    }

    private StringBuilder methodReturn(Set<String> importSet, Method dm, Class<?> interfaceClazz) {
        StringBuilder result = new StringBuilder();
        if (dm.getReturnType() == Void.class || dm.getReturnType() == Void.TYPE) {
            return result;
        }
        if (dm.getReturnType().isAssignableFrom(interfaceClazz) || dm.getReturnType() == interfaceClazz) {
            result.append("return this;\n");
        } else if (dm.getReturnType().isInterface()) {
            String index = this.methodWritersMap.computeIfAbsent(dm.getReturnType(), k -> "methodWriter" + k.getSimpleName() + "TL");
            result.append("// method return\n");
            String aClass = GenerateMethodWriter.nameForClass(importSet, dm.getReturnType());
            result.append(String.format("return methodWriter%sTL.get();\n", aClass, aClass, index));
        } else if (!dm.getReturnType().isPrimitive()) {
            result.append("return null;\n");
        } else if (dm.getReturnType() == Boolean.TYPE) {
            result.append("return false;\n");
        } else if (dm.getReturnType() == Byte.TYPE) {
            result.append("return (byte)0;\n");
        } else {
            result.append("return 0;\n");
        }
        return result;
    }

    private static /* synthetic */ String lambda$writeArrayOfParameters$12(Optional longConversion) {
        return longConversion.orElse("");
    }
}

